<?php
require_once('config.php');
/**
 * Create Refund Request
 * İade İsteği Oluştur
 */
$request = new \Hepsipay\Request\CreateRefundRequest();
/**
 * Set Options
 * Ayarları Set Et
 */
$request->setOptions($options);
$request->setTransactionTime(time()); // İşlem Zamanı, Varsayılan zaman ise şuan.
$request->setTransactionId("tx_" . rand(100000, 999999)); // Ödemeye Ait Tekil Kodu (Maksimum 40 karakterdir)
$request->setReferenceTransactionId("tx_532998"); // İade Edilecek Ödemeye Ait Tekil Kod (Maksimum 40 karakterdir)
$request->setAmount("120,99"); // Toplam İade Tutarı
$request->setCurrency(\Hepsipay\Model\Currency::TL); // Toplam Ödeme Tutar Birimi
/**
 * Make Request
 * İsteği Oluştur
 */
$response = \Hepsipay\Model\Refund::create($request);
/**
 * Print Response ve Request Details
 * Yanıtı ve İstek Detaylarını Yazdır
 */
echo "<pre>";
echo "\nRESPONSE\n\n";
print_r($response); // Response
echo "\nREQUEST\n\n";
print_r($request->toJsonString()); // Request
echo "</pre>";