<?php
require_once('config.php');
/**
 * Create Payment Request
 * Ödeme İsteği Oluştur
 */
$request = new \Hepsipay\Request\CreatePaymentRequest();
/**
 * Set Options
 * Ayarları Set Et
 */
$request->setOptions($options);
$request->setTransactionTime();    // Ödeme İşlem Zamanı, Varsayılan zaman ise şuan.
$request->setTransactionId("tx_" . rand(100000, 999999));    // Ödemeye Ait Tekil Kodu (Maksimum 40 karakterdir)
$request->setDescription("E-Ticaret Ödemesi"); // Açıklama alanıdır (Maksimum 40 karakterdir)
$request->setAmount("120,99"); // Toplam Ödeme Tutarı
$request->setCurrency(\Hepsipay\Model\Currency::TL); // Toplam Ödeme Tutar Birimi
$request->setInstallment(9); // Ödeme Taksit Sayısı (1'den 12'ye kadar taksit değeridir)
/**
 * Registered Card Info
 * Kayıtlı Kart Bilgileri
 */
$request->setMerchantCardId("93da18c7-2de2-4a9f-9fbf-a7160149f767");
/**
 * Customer Info
 * Müşteri Bilgileri
 */
$customer = new \Hepsipay\Model\Customer();
$customer->setName("Ali"); // Müşteri İsim (Maksimum 20 karakterdir. Sadece alfabetik karakterler ve boşluk kabul eder.)
$customer->setSurName("Veli"); // Müşteri Soyisim (Maksimum 20 karakterdir. Sadece alfabetik karakterler ve boşluk kabul eder.)
$customer->setEmail("ali.veli@alivelimarket.com.tr"); // Müşteri Mail (Eposta adresidir.)
$customer->setIpAddress("72.125.165.16"); // Müşteri IP Adresi (IP adresidir.)
$customer->setPhoneNumber("+905350000000"); // Müşteri Telefon Numarası (Maksimum 13 karakterdir. Sadece nümerik ve + değerlerini alabilir.)
$customer->setCode("7cefdf61-38cd-4b35-b5f0-4c98c5805d41"); // Müşteri Kodu (Maksimum 36 karakterdir.)
$customer->setTckn("12345678910"); // Müşteri Kimik Numarısı (TC Kimlik numarasıdır.)
$customer->setVatNumber("12345678910"); // Müşteri Vergi Numarası (Şirketlere ve firmalara tekil vergi numarası)
$customer->setMemberSince("20151124"); // Müşteri Üyelik tarihi (Müşteri üyelik tarihi formatı YYYYMMDD’dır.)
$customer->setBirthDate("19781123"); // Müşteri Doğum tarihi (Müşteri üyelik tarihi formatı YYYYMMDD’dır.)
$request->setCustomer($customer);
/**
 * Shipping Address
 * Teslimat/Nakliye Adresi
 */
$shippingAddress = new \Hepsipay\Model\Address();
$shippingAddress->setName("Ali Veli"); // Sipariş Teslimatının yapılacağı kişi adı ve soyadı (Maksimum 40 karakterdir. Sadece alfabetik karakterler ve boşluk kabul eder.)
$shippingAddress->setAddress("Kuştepe Mahallesi Mecidiyeköy Yolu Cad. No:12 Trump Towers Kule:2 Kat:11 Mecidiyeköy"); // Siparişin teslim edileceği adres (Maksimum 500 karakterdir. Sadece alfanümerik karakterler, &.,/: ve boşluk karakterini kabul eder.)
$shippingAddress->setCountry("Türkiye"); // Sipariş teslimatının yapılacağı ülke (Maksimum 20 karakterdir. Sadece alfabetik olabilir.)
$shippingAddress->setCountryCode("TUR"); // Sipariş teslimatının yapılacağı ülke (2 veya 3 haneli ISO ülke kodudur.Sadece alfabetik olabilir.)
$shippingAddress->setCity("Istanbul"); // Sipariş teslimatının yapılacağı şehir (Maksimum 20 karakterdir.Sadece alfabetik olabilir.)
$shippingAddress->setCityCode("34"); // Sipariş teslimatının yapılacağı şehir (Şehire ait ulusal veya uluslararası kod alanıdır. Türkiye için plaka kodu kullanılabilir.)
$shippingAddress->setZipCode("34580"); // Sipariş teslimatının yapılacağı posta kodu (Uluslararası posta kodu alanıdır.)
$shippingAddress->setDistrict("Şişli"); // Sipariş teslimatının yapılacağı ilçe (İlçe alanıdır.)
$shippingAddress->setDistrictCode(""); // Sipariş teslimatının yapılacağı ilçe kodu (İlçe kodu alanıdır.)
$shippingAddress->setShippingCompany("XXX"); // Taşıyıcı kargo bilgisi (Taşıyıcı kargo bilgisi alanıdır.)
$request->setShippingAddress($shippingAddress);
/**
 * Invoice Address
 * Fature Adresi
 */
$invoceAddress = new \Hepsipay\Model\Address();
$invoceAddress->setName("Ali Veli"); // Fatura kesilecek kişi veya kurum adı (Maksimum 40 karakterdir. Sadece alfanümerik karakterler, & . ve boşluk karakterini kabul eder.)
$invoceAddress->setAddress("Kuştepe Mahallesi Mecidiyeköy Yolu Cad. No:12 Trump Towers Kule:2 Kat:11 Şişli"); // Fatura adresi (Maksimum 500 karakterdir. Sadece alfanümerik karakterler, &.,/: ve boşluk karakterini kabul eder.)
$invoceAddress->setCountry("Türkiye"); // Fatura ülkesi (Maksimum 20 karakterdir. Sadece alfabetik olabilir.)
$invoceAddress->setCountryCode("TUR"); // Fatura ülkesi (2 veya 3 haneli ISO ülke kodudur. Sadece alfabetik olabilir.)
$invoceAddress->setCity("Istanbul"); // Fatura şehri (Maksimum 20 karakterdir. Sadece alfabetik olabilir.)
$invoceAddress->setCityCode("34"); // Fatura şehri (Şehire ait ulusal veya uluslararası kod alanıdır. Türkiye için plaka kodu kullanılabilir.)
$invoceAddress->setZipCode("34580"); // Fatura zip code (Uluslararası posta kodu alanıdır.)
$invoceAddress->setDistrict("Şişli"); // Sipariş teslimatının yapılacağı ilçe (İlçe alanıdır.)
$invoceAddress->setDistrictCode(""); // Sipariş teslimatının yapılacağı ilçe kodu (İlçe kodu alanıdır.)
$invoceAddress->setShippingCompany("XXX"); // Taşıyıcı kargo bilgisi (Taşıyıcı kargo bilgisi alanıdır.)
$request->setInvoiceAddress($invoceAddress);
/**
 * Cart
 * Sepet
 */
$basketItems = array();
$firstBasketItem = new \Hepsipay\Model\BasketItem();
$firstBasketItem->setDescription("Boyama Kalem Seti"); // Ürün ismi (Maksimum 40 karakterdir.)
$firstBasketItem->setProductCode("7cefdf61-38cd-4b35-b5f0-4c98c5805d41"); // Ürün kodu (Maksimum 36 karakterdir.)
$firstBasketItem->setAmount("87,50"); // Ürün fiyatı (Nokta ve virgülden arındırılmış double değerdir.)
$firstBasketItem->setVatRatio("18"); // Tutarın KDV içerip içermediğini belirtir (0, 8 veya 18 değerlerini alabilir.)
$firstBasketItem->setCount("1"); // Ürün miktarı (Maksimum 3 haneli nümerik değerdir.)
$firstBasketItem->setUrl("http://www.alivelimarket.com.tr/boyama-kalem-seti"); // Ürün web adresi (Web URL'idir)
$firstBasketItem->setBasketItemType(\Hepsipay\Model\BasketItemType::PHYSICAL); // Ürün tipi (Ürünler için PHYSICAL, Kargo bilgisi için SHIPPING.)
$firstBasketItem->setBasketItemId("basket_1");  // Ürün kodu (Maksimum 40 karakterdir.)
$basketItems[] = $firstBasketItem;
$secondBasketItem = new \Hepsipay\Model\BasketItem();
$secondBasketItem->setDescription("Boyama Kitabı");
$secondBasketItem->setProductCode("7cefdf61-38cd-4b35-b5f0-4c98c5805d41");
$secondBasketItem->setAmount("25,50");
$secondBasketItem->setVatRatio("18");
$secondBasketItem->setCount("3");
$secondBasketItem->setUrl("http://www.alivelimarket.com.tr/boyama-kitabi");
$secondBasketItem->setBasketItemType(\Hepsipay\Model\BasketItemType::PHYSICAL);
$secondBasketItem->setBasketItemId("basket_2");
$basketItems[1] = $secondBasketItem;
$thirdBasketItem = new \Hepsipay\Model\BasketItem();
$thirdBasketItem->setDescription("KargoBedeli");
$thirdBasketItem->setAmount("10,00");
$thirdBasketItem->setVatRatio("18");
$thirdBasketItem->setCount("1");
$thirdBasketItem->setBasketItemType(\Hepsipay\Model\BasketItemType::SHIPPING);
$thirdBasketItem->setBasketItemId("basket_3");
$basketItems[] = $thirdBasketItem;
$request->setBasketItems($basketItems);
/**
 * Make Request
 * İsteği Oluştur
 */
$response = \Hepsipay\Model\Payment::create($request);
/**
 * Print Response ve Request Details
 * Yanıtı ve İstek Detaylarını Yazdır
 */
echo "<pre>";
echo "\nRESPONSE\n\n";
print_r($response); // Response
echo "\nREQUEST\n\n";
print_r($request->toJsonString()); // Request
echo "</pre>";