<?php
function cevir($metin){
    $metin = trim($metin);
    $turkce = ['Ç', 'Ğ', 'İ', 'I', 'Ö', 'Ş', 'Ü', 'ç', 'ğ', 'ı', 'ö', 'ş', 'ü'];
    $duz    = ['C', 'G', 'I', 'I', 'O', 'S', 'U', 'c', 'g', 'i', 'o', 's', 'u'];
    $metin = str_replace($turkce, $duz, $metin);
    $metin = mb_strtolower($metin, 'UTF-8');
	$metin = preg_replace('/[^a-z0-9]/u', '-', $metin);
    $metin = preg_replace('/-+/', '-', $metin);
    $metin = trim($metin, '-');
    return $metin;
}

function cevir1($metin) {
    $metin = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $metin);
    $metin = strtolower($metin);
    $arama = ['ş','Ş','ı','İ','ç','Ç','ü','Ü','ö','Ö','ğ','Ğ'];
    $degis = ['s','s','i','i','c','c','u','u','o','o','g','g'];
    $metin = str_replace($arama, $degis, $metin);
    $metin = preg_replace('/[^a-z0-9]+/i', '-', $metin);
    $metin = trim($metin, '-');
    return $metin;
}

function cevir2($metin) {return $metin; }
function cevir3($metin){return $metin;}

function cevir4($metin) {	//Formlarda kullanılıyor
    // Türkçe karakterleri sadeleştir
    $turkce = ["ç","Ç","ğ","Ğ","ı","İ","ö","Ö","ş","Ş","ü","Ü"];
    $latin  = ["c","C","g","G","i","I","o","O","s","S","u","U"];
    $metin = str_replace($turkce, $latin, $metin);

    // Harf, rakam ve boşluk dışındaki karakterleri temizle
    $metin = preg_replace('/[^A-Za-z0-9 ]/', '', $metin);

    // Boşlukları alt çizgi yap
    $metin = str_replace(' ', '_', $metin);

    // Baştaki ve sondaki alt çizgileri kırp
    $metin = trim($metin, '_');

    return $metin;
}

function cevir5($metin){ return $metin; }
function BadChar($metin){ return $metin; }

function virgul($metin,$cmd){
if($cmd=="boz"){
	$metin = str_replace(",", "U+002C", $metin);
}else{
	$metin = str_replace("U+002C", ",", $metin);
}
	return $metin;
}
// Büyük harfleri küçük harfe çevirip Türkçe özel karakterleri sadeleştiriyor


function ssl($metin){
	global $f4;
	if($f4=="1"){ $metin = str_replace('http://', 'https://', $metin); }	
	return $metin;
}

function qv($metin){
	$metin = str_replace(" ", "+", $metin);
	$metin = str_replace("%20", "+", $metin);
	return $metin;
}

function qa($metin){
	$metin = str_replace("_", " ", $metin);
	$metin = str_replace("+", " ", $metin);
	return $metin;
}

function badge($metin){
	$metin = str_replace('{', '<span class="v3-badge">', $metin);
	$metin = str_replace('}', '</span>', $metin);
	return $metin;
}

function rstr($metin){
	foreach ($_POST as $key => $value){
		$metin = str_replace("{".$key."}", $value, $metin);
	}
	foreach ($_SESSION as $key => $value){
		$metin = str_replace("{".$key."}", $value, $metin);
	}
	return $metin;
}

function seo($metin) {
    global $module, $mobile, $conn, $id;
    $lamp = ($module["amp"] != "" && $mobile != "") ? "/amp" : "";

    if ($module["seo_auto"] == "1") {
        $stmt = $conn->prepare("SELECT * FROM " . $_SESSION["lang"] . " WHERE (ne='kayit' OR ne='sayfa' OR ne='haber') AND n4<>'' AND id<>?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $n4 = '';
        while ($rseo = $result->fetch_assoc()) {
            $n4 .= "," . $rseo["n4"];
        }
        $keys = explode(',', $n4);

        foreach ($keys as $key) {
            $key = trim($key);
            if ($key != "") {
                $stmt = $conn->prepare("SELECT * FROM " . $_SESSION["lang"] . " WHERE (ne='kayit' OR ne='sayfa' OR ne='haber') AND n4 LIKE ?");
                $likeKey = '%' . $key . '%';
                $stmt->bind_param("s", $likeKey);
                $stmt->execute();
                $result = $stmt->get_result();
                $rseo = $result->fetch_assoc();

                $n = $rseo["ne"] == "kayit" ? "d" : ($rseo["ne"] == "sayfa" ? "s" : ($rseo["ne"] == "haber" ? "h" : $rseo["ne"][0]));
                $link = "<a href='" . linked($n, $rseo["id"]) . "' target='_blank'>" . $key . "</a>";

                // Regex ile kelimeyi sadece bağımsız geçtiğinde değiştir
                $pattern = '/\b' . preg_quote($key, '/') . '\b/i';
                $metin = preg_replace($pattern, $link, $metin);
            }
        }
    } else {
        $result = $conn->query("SELECT * FROM genel WHERE ne='seo' ORDER BY id DESC"); while ($rseo = $result->fetch_assoc()) {
            $key = $rseo["n1"];
            $link = "<a href='" . $lamp . $rseo["n2"] . "' target='" . $rseo["t2"] . "'>" . $key . "</a>";

            $pattern = '/\b' . preg_quote($key, '/') . '\b/i';
            $metin = preg_replace($pattern, $link, $metin);
        }
    }

    // Dış linklere nofollow ekle
    $metin = str_replace('href="http', 'rel="nofollow" target="_blank" href="http', $metin);

    return rlang($metin);
}

function rlang($metin){
	global $module; global $firm; global $city; global $lcity; global $baslik; global $weburl; global $conn; global $sayfa; global $sayfa1; global $t2; global $kpb; global $locc;
	$filePath = $weburl."/deppo/datas/translations.json";
	static $translations = null; // Cache burada olacak
	if ($translations === null){
		$translations = json_decode(file_get_contents($filePath), true);
	}
	$sql_tahsilat=mysqli_query($conn, "select id,n1 from genel where ne='tahsilat'"); $rst=mysqli_fetch_assoc($sql_tahsilat);
	$sql_client=mysqli_query($conn, "select id,t1,t2,t4,n5,n17 from t5 where id=".$_SESSION["User_ID"].""); $rsc=mysqli_fetch_assoc($sql_client);  $jsic = json_decode($rsc["n17"], true);
	if($sayfa1=="odeme"){
		$urunler .= '<table class="v3-table">';
		$urunler .= '<tr>';
		$urunler .= '<td>'.translate("Urun Adi").'</td>';
		$urunler .= '<td style="text-align:right;">'.translate("Adet").' x '.translate("Fiyat").'</td>';
		$urunler .= '<tr>';
		$sqls = mysqli_query($conn, "select * from eticaret where ne='sepet' and t4='".$_SESSION["Order_No"]."' and t5='sepet' order by id desc"); while($rsepet=mysqli_fetch_assoc($sqls)){
			$sqlu = mysqli_query($conn, "select * from ".$_SESSION["lang"]." where id=".$rsepet["s3"].""); $rsu=mysqli_fetch_assoc($sqlu);
			$urunler .= '<tr>';
			$urunler .= '<td>'.badge($rsepet["n1"]).'</td>';
			$urunler .= '<td style="text-align:right;">'.$rsepet["s2"].' x '.price($rsu["id"],"pb1").' '.$kpb.'</td>';
			$urunler .= '<tr>';
			$skdv = $skdv+($rsepet["pb3"]*$rsepet["s2"]);
			$sdesi = $sdesi+($rsepet["s6"]*$rsepet["s2"]);
			$toplam2 = $toplam2+($rsepet["pb4"]*$rsepet["s2"]);
			$toplam1 = $toplam1+($rsepet["pb2"]*$rsepet["s2"]);
		}
		$urunler .= '<tr>';
		$urunler .= '<td style="">'.translate("Kargo").' {'.$_SESSION["Order_Cargo"].'}</td>';
		$urunler .= '<td style="text-align:right;">'.wprice($_SESSION["Order_Cargo_Price"]).' '.$kpb.'</td>';
		$urunler .= '<tr>';
		if($_SESSION["Order_Discount_Code_Status"]<>""){
			$total_price = (($toplam1-$_SESSION["Order_Discount_Code_Price"])+$_SESSION["Order_Cargo_Price"]);
			$urunler .= '<tr>';
			$urunler .= '<td style="">Toplam</td>';
			$urunler .= '<td style="text-align:right;"><b><del>'.wprice(($toplam1)).'</del> '.wprice(($total_price)).' '.$kpb.'</b></td>';
			$urunler .= '<tr>';
		}else{
			$total_price = $toplam1+$_SESSION["Order_Cargo_Price"];
			$urunler .= '<tr>';
			$urunler .= '<td style="">Toplam</td>';
			$urunler .= '<td style="text-align:right;"><b>'.wprice(($total_price)).' '.$kpb.'</b></td>';
			$urunler .= '<tr>';
		}
		$urunler .= '</table>';
	}
	if ($module["m1"]<>""){$d=0; $diller = explode(',',$module["m1"]); foreach($diller as $dil) {$d++;
		if ($_SESSION["lang"]=="lang".$d.""){$dill=$dil;}}}
		$firma	= srep($firm["firma"]);
		$ftel		= srep($firm["ftel"]);
		$ffax		= srep($firm["ffax"]);
		$fgsm	= srep($firm["fgsm"]);
		$fmail	= srep($firm["fmail"]);
		$fweb	= srep($weburl);
		$fadres	= srep($firm["fadres"]);
		$fadres2= srep($firm["fadres2"]);
		$fadres3= srep($firm["fadres3"]);
		$ftel2	= srep($firm["ftel2"]);
		$ftel3	= srep($firm["ftel3"]);
		$fvd		= srep($firm["fvd"]);
		$fvn		= srep($firm["fvn"]);
		preg_match_all('/\{([^}]+)\}/', $metin, $matches);
		foreach ($matches[1] as $match) {
			foreach ($translations as $translation) {
				if (isset($translation["key"], $translation[$_SESSION["lang"]]) && $translation["key"] === "{" . $match . "}") {
					$metin = str_replace($translation["key"], $translation[$_SESSION["lang"]], $metin);
				}
			}
		}
		$etiketler = ["/{sehir}", "/{Sehir}", "/{city}", "/{City}", "{sehir}", "{Sehir}", "{city}", "{City}"];
		if($locc<>""){
			$degisimler = ["/" . cevir($locc), "/" . cevir($locc), "/" . cevir($locc), "/" . cevir($locc), $locc, $locc, $locc, $locc];
		}elseif($city<>""){
			$degisimler = ["/" . cevir($city), "/" . cevir($city), "/" . cevir($city), "/" . cevir($city), $city, $city, $city, $city];
		}else{
			$degisimler = ["/" . cevir($module["city"]), "/" . cevir($module["city"]), "/" . cevir($module["city"]), "/" . cevir($module["city"]), $module["city"], $module["city"], $module["city"], $module["city"]];
		}
		$metin = str_replace($etiketler, $degisimler, $metin);
		$metin = str_replace("{ftel}", "<a href='tel:".telefon($firm["ftel"])."'>".$firm["ftel"]."</a>", $metin);
		$metin = str_replace("{ffax}", $firm["ffax"], $metin);
		$metin = str_replace("{fmail}", $firm["fmail"], $metin);
		$metin = str_replace("{weburl}", $weburl, $metin);
		$metin = str_replace("{purl}", "<a href='".$rst["n1"]."' target='_blank'>".$rst["n1"]."</a>", $metin);
		$metin = str_replace("{url}", $module["n9"], $metin);
		$metin = str_replace("{firma}", $firm["firma"], $metin);
		$metin = str_replace("{fvd}", $firm["fvd"], $metin);
		$metin = str_replace("{fvn}", $firm["fvn"], $metin);
		$metin = str_replace("{fadres}", $firm["fadres"], $metin);
		$metin = str_replace("{fgsm}", "<a href='tel:".telefon($firm["fgsm"])."'>".$firm["fgsm"]."</a>", $metin);
		$metin = str_replace("{t1}", $baslik, $metin);
		$metin = str_replace("{loc}", $locc, $metin);
		$metin = str_replace("{Tarih}", dtarih(date("Y-m-d"),"gg ua yyyy"), $metin);
		$metin = str_replace("{Sepet}", $urunler, $metin);
		$metin = str_replace("{SiparisAdres}", "".$_SESSION["Order_Delivery_Adress"]."", $metin);
		$metin = str_replace('{container}', '<div class="v3-container">', $metin);
		$metin = str_replace('{row}', '<div class="v3-row">', $metin);
		$metin = str_replace('{col-1}', '<div class="v3-col-md-1">', $metin);
		$metin = str_replace('{col-2}', '<div class="v3-col-md-2">', $metin);
		$metin = str_replace('{col-3}', '<div class="v3-col-md-3">', $metin);
		$metin = str_replace('{col-4}', '<div class="v3-col-md-4">', $metin);
		$metin = str_replace('{col-5}', '<div class="v3-col-md-5">', $metin);
		$metin = str_replace('{col-6}', '<div class="v3-col-md-6">', $metin);
		$metin = str_replace('{col-7}', '<div class="v3-col-md-7">', $metin);
		$metin = str_replace('{col-8}', '<div class="v3-col-md-8">', $metin);
		$metin = str_replace('{col-9}', '<div class="v3-col-md-9">', $metin);
		$metin = str_replace('{col-10}', '<div class="v3-col-md-10">', $metin);
		$metin = str_replace('{col-11}', '<div class="v3-col-md-11">', $metin);
		$metin = str_replace('{col-12}', '<div class="v3-col-md-12">', $metin);
		$metin = str_replace('{bg-info}', '<div class="v3-bg-info">', $metin);
		$metin = str_replace('{bg-warning}', '<div class="v3-bg-warning">', $metin);
		$metin = str_replace('{bg-success}', '<div class="v3-bg-success">', $metin);
		$metin = str_replace('{bg-danger}', '<div class="v3-bg-danger">', $metin);
		$metin = str_replace('{/div}', '</div>', $metin);
		$metin = str_replace('{pre}', '<pre>', $metin); $metin = str_replace('{/pre}', '</pre>', $metin);
		$metin = str_replace('{code}', '<code>', $metin); $metin = str_replace('{/code}', '</code>', $metin);
		$metin = str_replace('{h1}', '<h1>', $metin); $metin = str_replace('{/h1}', '</h1>', $metin);
		$metin = str_replace('{h2}', '<h2>', $metin); $metin = str_replace('{/h2}', '</h2>', $metin);
		$metin = str_replace('{h3}', '<h3>', $metin); $metin = str_replace('{/h3}', '</h3>', $metin);
		$metin = str_replace('{h4}', '<h4>', $metin); $metin = str_replace('{/h4}', '</h4>', $metin);
		$metin = str_replace('{h5}', '<h5>', $metin); $metin = str_replace('{/h5}', '</h5>', $metin);
		if(mysqli_num_rows($sql_client)>0){
			$metin = str_replace("{UserID}", $rsc["id"], $metin);
			$metin = str_replace("{Adres}", $rsc["n5"], $metin);
			$metin = str_replace("{Ad_Soyad}", $rsc["t1"], $metin);
			$metin = str_replace("{Telefon}", $rsc["t4"], $metin);
			$metin = str_replace("{E-Mail}", v3d($rsc["t2"]), $metin);
			$metin = str_replace("{IDN}", $rsc["t13"], $metin);
			$metin = str_replace("{Vergi_Dairesi}", $jsic["ivnumara"], $metin);
			$metin = str_replace("{Vergi_Numarasi}", $jsic["ivnumara"], $metin);
			$metin = str_replace("{Firma}", $jsic["ifirma"], $metin);
			if($jsiu["ifirma"]<>""){
				$metin = str_replace("{Alici}", $jsic["ifirma"], $metin);
			}else{
				$metin = str_replace("{Alici}", $rsc["t1"], $metin);
			}
		}
		return $metin;
	}

function telefon($metin) {
    // Türkiye kodları temizle (+90, 90, 0)
    $metin = preg_replace('/^\+?90|^0/', '', $metin);
    
    // Parantez, boşluk, tire ve artı işaretlerini temizle
    $metin = str_replace(['(', ')', ' ', '-', '+'], '', $metin);
    return $metin;
}

function para($i){
	$str = explode(",", $i); $cstr=count($str);
	if($cstr=="2"){
		$i = str_replace(".", "", $i);
	}
	$i = str_replace(",", ".", $i);
	return $i;
}

function sprice($number) {
    if (strpos($number, ',') !== false) {
        $number = str_replace('.', '', $number);
        $number = str_replace(',', '.', $number);
    }
    $number = number_format((float)$number, 2, ',', '');
    return $number;
}

function wprice($i) {
    global $module;
    $i = str_replace(",", ".", $i); // "12,35" -> "12.35"
    $i = floatval($i); // "12.35" -> 12.35 (sayı)
    $cc = !empty($module["currency_coin"]) ? 2 : 0;
    if ($cc == 2) {
        $i = floor($i * 100) / 100; // Yuvarlama olmadan kes
    }
    return number_format($i, $cc, ",", ".");
}

function jsprice($i){				//js hesaplama için virgülsüz
	$str = explode(",", $i); $cstr=count($str);
	if($cstr=="2"){
		$i = str_replace(".", "", $i);
	}
	$i = str_replace(",", ".", $i);
	return $i;
}
// number_format(sayı, ondalık hane sayısı, ondalık ayırıcı, binlik ayırıcı)

function wcount($i){
	$i = number_format($i,0,",",".");
	return $i;
}

function wpara($i){
	$str = explode(",", $i); $cstr=count($str);
	if($cstr >= 2){	//if 
		$i = str_replace(".", "*", $i);
	}
	$i = str_replace(",", ".", $i);
	$i = str_replace("*", ",", $i);
	return $i;
}

function cevirf($metin){
	$metin = str_replace("%2F", "/", $metin);
	return $metin;
}

function vcevir($metin){
	$metin = str_replace("/v/", "/embed/", $metin);
	$metin = str_replace("/watch?v=", "/embed/", $metin);
	$metin = str_replace("?version=3&amp;autohide=1", "", $metin);
	return $metin;
}

function kisagun($metin){
	$gunler = ["Sun" => "Pa","Mon" => "Pts","Tue" => "Sa", "Wed" => "Ça", "Thu" => "Pe", "Fri" => "Cu", "Sat" => "Ct"];
    foreach ($gunler as $english => $turkish) {
        $metin = str_replace($english, $turkish, $metin);
    }
    return $metin;
}

function uzungun($metin){
	$gunler = [ "Sunday"    => "Pazar", "Monday"    => "Pazartesi", "Tuesday"   => "Salı", "Wednesday" => "Çarşamba", "Thursday"  => "Perşembe", "Friday"    => "Cuma", "Saturday"  => "Cumartesi" ];
    foreach ($gunler as $english => $turkish) {
        $metin = str_replace($english, $turkish, $metin);
    }
    return $metin;
}

function kisaay($metin) {
    $aylar = [ "01" => "Oca", "02" => "Şub", "03" => "Mar", "04" => "Nis", "05" => "May", "06" => "Haz", "07" => "Tem", "08" => "Ağu", "09" => "Eyl", "10" => "Eki", "11" => "Kas", "12" => "Ara" ];
    foreach ($aylar as $numara => $isim) {
        $metin = str_replace($numara, $isim, $metin);
    }
    return $metin;
}

function uzunay($metin){
	$aylar = [ "01" => "Ocak", "02" => "Şubat", "03" => "Mart", "04" => "Nisan", "05" => "Mayıs", "06" => "Haziran", "07" => "Temmuz", "08" => "Ağustos", "09" => "Eylül", "10" => "Ekim", "11" => "Kasım", "12" => "Aralık", "1"  => "Ocak", "2"  => "Şubat", "3"  => "Mart", "4"  => "Nisan", "5"  => "Mayıs", "6"  => "Haziran", "7"  => "Temmuz", "8"  => "Ağustos", "9"  => "Eylül" ];
	foreach ($aylar as $numara => $isim) {
        $metin = str_replace($numara, $isim, $metin);
    }
    return $metin;
}

function aylar($metin){
	$aylar = [ "01" => "Ocak", "02" => "Şubat", "03" => "Mart", "04" => "Nisan", "05" => "Mayıs", "06" => "Haziran", "07" => "Temmuz", "08" => "Ağustos", "09" => "Eylül", "10" => "Ekim", "11" => "Kasım", "12" => "Aralık", "1"  => "Ocak", "2"  => "Şubat", "3"  => "Mart", "4"  => "Nisan", "5"  => "Mayıs", "6"  => "Haziran", "7"  => "Temmuz", "8"  => "Ağustos", "9"  => "Eylül" ];
	foreach ($aylar as $numara => $isim){
        $metin = str_replace($numara, $isim, $metin);
    }
    return $metin;
}

function gunler($metin){
	$metin="";
	$gunler = ["0" => "Pazar", "1" => "Pazartesi", "2" => "Salı", "3" => "Çarşamba", "4" => "Perşembe", "5" => "Cuma", "6" => "Cumartesi"];
    foreach ($gunler as $numara => $isim) {
        $metin = str_replace($numara, $isim, $metin);
    }
    return $metin;
}
//echo str_replace($url0, $url1, $rs["t1"]); //Replace
?>