<?php
// ncelikle cache kullanm kontrol edilir
$nocache = explode(",", tanim("nocache", "n1", 0));
$nc = 0;
foreach ($nocache as $q) {
    if (strpos($q, $sayfa[0]) !== false || strpos($q, $sayfa) !== false) {
        $nc++;
    }
}
// Cache kullanmna izin veriliyorsa ve sayfa uygun ise ilem yaplr
if ($module["cache"] == 1 && ($sayfa[0] !== "e" && $sayfa[0] !== "p") && $nc == 0) {
    class Cache {
        public $start_time;
        public $cache_file;
        public $to_create;
        function __construct() {
            $this->to_create = true;
            $this->Start();
        }
        // Cache balangc
        function Start() {
            global $module;
            $this->start_time = microtime(true);
            $cache_time = $module["cache_time"];
            // Cache key oluturulurken sadece nemli GET parametreleri ekleniyor
            $str = 'https://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
            $query_params = [];
            // nemli GET parametrelerini seelim
            if (!empty($_GET)) {
                foreach ($_GET as $k => $v) {
                    // rnein, sadece 'filter', 'page', vb. parametreleri dahil edebiliriz
                    if (in_array($k, ['filter', 'page'])) {
                        $query_params[$k] = $v;
                    }
                }
            }
            // GET parametreleri ekleniyor
            ksort($query_params);
            foreach ($query_params as $k => $v) {
                $str .= $k . $v;
            }
            // Cache dosyasnn yolu belirleniyor
            $this->cache_file = $_SERVER['DOCUMENT_ROOT'] . "/deppo/cache/" . md5($str) . ".html";
            // Eer cache dosyas geerliyse, hemen ykleyelim
            if (file_exists($this->cache_file) && (time() - $cache_time < filemtime($this->cache_file))) {
                include($this->cache_file);
                $this->to_create = false;
                exit;  // Cache kullanld, ilem sonlandrlr
            }
            // Cache dosyas geerli deilse, tampon balatlr
            ob_start();
        }
        // Cache dosyasn kaydet
        function End() {
            // Cache ieriini dosyaya yazyoruz
            if ($fp = fopen($this->cache_file, 'w')) {
                if (fwrite($fp, ob_get_contents()) === false) {
                    error_log("Cache dosyasna yazlamad: " . $this->cache_file);
                }
                fclose($fp);
            } else {
                error_log("Cache dosyasna yazlamad: " . $this->cache_file);
            }
            ob_end_flush();
        }
        // Cache snf sonlandnda, cache dosyasn olutur
        function __destruct() {
            if ($this->to_create) {
                $this->End();
            }
        }
    }
    // Cache dosyalarn kontrol edip eski olanlar temizleyelim
    $cdir = $_SERVER['DOCUMENT_ROOT'] . "/deppo/cache/";
    foreach (glob($cdir . "*") as $cfile) {
        // Geersiz dosyalar silinir
        if (filemtime($cfile) < time() - $module["cache_time"]) {
            unlink($cfile);
        }
    }
    // Yeni cache snf oluturuluyor
    $cache = new Cache();
}
?>