<?php
error_reporting(0);
$jsonFile = '../../ranking.json';
$data = json_decode(file_get_contents($jsonFile), true);
// Kelimeleri gruplama
$kelimeGruplari = [];
foreach ($data as $item) {
    $kelime = $item['kelime'];
    $kelimeGruplari[$kelime][] = $item;
}
// Sıralama değerine göre küçükten büyüğe sıralama
foreach ($kelimeGruplari as &$group) {
    usort($group, fn($a, $b) => intval($a['sira']) - intval($b['sira']));
}
$aylar = [
    "January" => "Ocak", "February" => "Şubat", "March" => "Mart", "April" => "Nisan", "May" => "Mayıs", "June" => "Haziran",
    "July" => "Temmuz", "August" => "Ağustos", "September" => "Eylül", "October" => "Ekim", "November" => "Kasım", "December" => "Aralık"
];
$oncekiAy = $aylar[date("F", strtotime("-1 month"))] . " " . date("Y", strtotime("-1 month"));
$raporTarihi = date("d.m.Y");
$webAdres = $_SERVER['HTTP_HOST'];
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <title>SEO Kelime Raporu</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f7f7f7; margin: 20px; }
        .container { margin: auto; background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .kelime { font-size: 20px; font-weight: bold; margin-top: 15px; padding: 10px; background: #f0f0f0; border-radius: 6px; display: flex; justify-content: space-between; align-items: center; }
        .rekabet-aralik { font-size: 14px; color: #666; }
        .satir { padding: 8px; display: flex; justify-content: space-between; font-size: 16px; border-bottom: 1px solid #ddd; }
        .tarih { font-weight: bold; color: #333; }
        .detay { font-weight: bold; color: #222; }
        .antet { display: flex; justify-content: space-between; align-items: center; background: #f8f8f8; padding: 15px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); margin-bottom: 20px; }
		.logo img { height: 50px; margin-right: 10px;  float:left;}
        .rapor-baslik { font-size: 18px; font-weight: bold; color: #333; float:left; line-height: 50px;}
        .bilgiler { text-align: right; font-size: 14px; color: #555; }
    </style>
</head>
<body>
<div class="container">
<div class="antet">
    <div class="logo">
        <img src="https://cdn.crmplus.com.tr/images/crm.png" alt="Logo">
        <div class="rapor-baslik"><?= $oncekiAy ?> SEO Raporu</div>
    </div>
    <div class="bilgiler">
        <div>Web Adres: <?= $webAdres ?></div>
        <div>Rapor Tarihi: <?= $raporTarihi ?></div>
        <div><a href="/ranking/graphic" target="_blank">Grafik Rapor</a></div>
    </div>
</div>
<div class="">
    <?php foreach ($kelimeGruplari as $kelime => $veriler): ?>
        <?php
        $rekabetler = array_column($veriler, 'rekabet');
        $minRekabet = min($rekabetler);
        $maxRekabet = max($rekabetler);
        // Önceki aya göre sıralama değişimini hesapla
        $ikon = "";
		usort($veriler, fn($a, $b) => strtotime($b['tarih']) - strtotime($a['tarih']));
        if (count($veriler) > 1) {
			$oncekiSira = intval($veriler[1]['sira']); // Önceki ay
			$yeniSira = intval($veriler[0]['sira']);   // Şu anki ay
			if (($oncekiSira == 0 && $yeniSira > 0) || $yeniSira < $oncekiSira) {
				$ikon = "fas fa-arrow-up text-success"; // Yükselmiş
			} elseif ($yeniSira > $oncekiSira) {
				$ikon = "fas fa-arrow-down text-danger"; // Düşmüş
			} else {
				$ikon = "fas fa-minus text-info"; // Aynı kalmış
			}
		}
    ?>
		<div class="kelime">
			<span><i class="<?= $ikon ?>"></i> <?= htmlspecialchars($kelime) ?></span>
			<span class="rekabet-aralik">
				<?= number_format($minRekabet, 0, ',', '.') ?>
				<?= ($minRekabet !== $maxRekabet) ? " - " . number_format($maxRekabet, 0, ',', '.') : "" ?> Rekabet
			</span>
		</div>
        <?php foreach (array_slice($veriler, 0, 3) as $v): ?>
            <div class="satir">
                <span class="tarih"><?= $aylar[date("F", strtotime($v['tarih']))] ?></span>
                <span class="detay"><?= ($v['sira'] == 0) ? 'İlk 100 kayıt içinde bulunamadı' : intval($v['sira']) . '. sıra' ?> </span>
            </div>
        <?php endforeach; ?>
    <?php endforeach; ?>
</div>
</div>
</body>
</html>