<?php
$i = 0; // SQL dosyas sayac
$backup_status = "Yedekle"; // Varsaylan yedekleme durumu
$backup_dir = '../deppo/backup';
$files = scandir($backup_dir);
foreach ($files as $file) {
    if (pathinfo($file, PATHINFO_EXTENSION) === "sql") { // Sadece .sql uzantl dosyalar
        $i++;
        // Dosya adndan tarih bilgisini alma (crmplus_cloud_backup_04032025.sql)
        if (preg_match('/(\d{8})\.sql$/', $file, $matches)) {
            $date_str = $matches[1]; // 04032025
            $dates = DateTime::createFromFormat('dmY', $date_str);
            if ($dates instanceof DateTime) {
                $formatted_date = $dates->format('Y-m-d');
                // Dosya tarihini kontrol et
                if ($formatted_date <= date('Y-m-d', strtotime("-" . $module["backup_days"] . " days"))) {
                    $file_path = $backup_dir . '/' . $file;
                    if (file_exists($file_path) && !unlink($file_path)) {
                        echo "Hata: $file dosyas silinemedi.";
                    }
                }
                // Gnlk yedekleme durumu kontrol
                if ($dates->format('d-m') == date("d-m")) {
                    $backup_status = "Tamamland"; // Yedekleme zaten yaplm
                }
            }
        }
    }
}
// Hi SQL dosyas yoksa yedekleme durumu "Yedekle" olarak kalr
?>