<?php
// ai_process.php
header('Content-Type: text/event-stream; charset=utf-8');
header('Cache-Control: no-cache');
header('Connection: keep-alive');

$path="../../";
include("../../map.php");

// OpenAI
$apiKey = tanim("openai","n1",0);
$apiUrl = "https://api.openai.com/v1/chat/completions";

// flush ayarları
ob_implicit_flush(true);
ob_end_flush();

function sseSend($msg) {
    echo "data: {$msg}\n\n";
    @ob_flush();
    flush();
}

function fetchFromAPI($prompt, $apiUrl, $apiKey, $maxTokens = 800) {
    $data = [
        "model" => "gpt-3.5-turbo",
        "messages" => [
            ["role" => "system", "content" => "You are a helpful assistant."],
            ["role" => "user", "content" => $prompt]
        ],
        "max_tokens" => $maxTokens,
        "temperature" => 0.7,
    ];

    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "Authorization: Bearer " . $apiKey
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        $err = curl_error($ch);
        curl_close($ch);
        return ['success' => false, 'error' => "CURL error: " . $err];
    }
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    $responseData = json_decode($response, true);
    if (!is_array($responseData) || !isset($responseData['choices'][0]['message']['content'])) {
        $raw = $response ?: 'empty response';
        return ['success' => false, 'error' => "API response format error. HTTP: {$httpCode}. Raw: {$raw}"];
    }

    $content = trim($responseData['choices'][0]['message']['content']);
    return ['success' => true, 'content' => $content];
}

function formatParagraphs($content) {
    $paragraphs = preg_split("/\n|\r\n?/", trim($content));
    $formatted = "";
    foreach ($paragraphs as $p) {
        if (trim($p) !== '') {
            $formatted .= "<p>" . trim($p) . "</p>\n";
        }
    }
    return $formatted;
}

// ---------- input ----------
$prompt   = trim($_GET['prompt'] ?? '');
$columns  = $_GET['columns'] ?? [];
$ne       = trim($_GET['table'] ?? 'sayfa');
$langTab  = $_SESSION['lang'] ?? 'lang1';

if ($prompt === '' || empty($columns)) {
    sseSend("⚠️ Eksik parametre: prompt veya sütun seçimi yok.");
    exit;
}

if (!preg_match('/^lang\d+$/', $langTab)) $langTab = "lang1";
$table = $langTab;

// 🔹 İşlem türünü belirle
$adet = (int)($_GET['count'] ?? 0);
$mode = ($adet > 0) ? "insert" : "update";

// ============================================================
// LIMIT ve PID işlemleri
// ============================================================
$limitSql = "";
if (!empty($_GET['limit']) && is_numeric($_GET['limit'])) {
    $limitSql = " LIMIT " . intval($_GET['limit']);
}

$pID = "";
if (!empty($_GET['pid']) && is_numeric($_GET['pid'])) {
    $pID = " AND id=".$_GET['pid'];
}

// ============================================================
// INSERT modu (çoklu ekleme destekli)
// ============================================================
if ($mode === "insert" && $adet > 0) {
    sseSend("🆕 {$adet} yeni içerik eklenecek...");

    for ($i=1; $i<=$adet; $i++) {
        $combinedPrompt = "Kullanıcının talimatı: \"{$prompt}\".\n";
        $combinedPrompt .= "Başlık üret, ardından istenen sütunlar için içerik hazırla.\n";
        foreach ($columns as $key) {
            switch ($key) {
                case 't1': $combinedPrompt .= "SEO başlık (max 120) -> t1\n"; break;
                case 'n1': $combinedPrompt .= "Paragraflı, detaylı, seo uyumlu ve en az 800 kelimelik içerik üret (HTML yok) -> n1\n"; break;
                case 'n2': $combinedPrompt .= "Maksimum 160 karakter, SEO uyumlu meta description -> n2\n"; break;
                case 'n3': $combinedPrompt .= "Maksimum 120 karakter, SEO odaklı başlık -> n3\n"; break;
                case 'n4': $combinedPrompt .= "5-12 anahtar kelime üret, virgülle ayır -> n4\n"; break;
                case 'n9': $combinedPrompt .= "3-5 cümlelik kısa özet -> n9\n"; break;
            }
        }
        $combinedPrompt .= "Çıktıyı sadece geçerli JSON ver. Başka açıklama ekleme.\n";
        $combinedPrompt .= "Format: {\"t1\":\"Başlık\",\"n1\":\"Makale\",\"n2\":\"Meta\",\"n3\":\"SEO Başlık\",\"n4\":\"Anahtar kelimeler\",\"n9\":\"Özet\"}";

        // API isteği
        $api = fetchFromAPI($combinedPrompt, $apiUrl, $apiKey, 2000);
        if ($api['success']) {
            $jsonText = $api['content'];
            if (preg_match('/(\{.*\}|\[.*\])/s', $api['content'], $m)) {
                $jsonText = $m[0];
            } else {
                $jsonText = '{}';
            }
            $data = json_decode($jsonText, true);

            if (json_last_error() === JSON_ERROR_NONE && is_array($data)) {
                $fields = [
                    'ne'   => $ne,
                    's13'  => 1,
                    'ts1'  => date("Y-m-d H:i:s")
                ];
                foreach ($data as $k=>$v) {
                    if ($k === 'n1') $fields[$k] = formatParagraphs($v);
                    elseif ($k === 'n4') $fields[$k] = preg_replace('/\s*,\s*/', ',', trim($v));
                    else $fields[$k] = trim($v);
                }

                $cols = "`".implode("`,`", array_keys($fields))."`";
                $vals = "'" . implode("','", array_map(fn($v)=>mysqli_real_escape_string($conn,$v), $fields)) . "'";
                $sql = "INSERT INTO `$table` ($cols) VALUES ($vals)";
                
                if ($conn->query($sql)) {
                    sseSend("✅ Yeni içerik eklendi (ID={$conn->insert_id})");
                } else {
                    sseSend("❌ INSERT DB ERROR: " . $conn->error);
                }
            } else {
                sseSend("❌ JSON parse hatası. Raw: " . substr($api['content'],0,300));
            }
        } else {
            sseSend("❌ API ERROR: " . $api['error']);
        }
        sseSend("----------------------------------------");
    }

    sseSend("🎉 {$adet} içerik eklendi.");
    exit;
}

// ============================================================
// UPDATE modu
// ============================================================
$neEsc = mysqli_real_escape_string($conn, $ne);
$selectSql = "SELECT id, t1 FROM `{$table}` WHERE ne = '{$neEsc}' AND s13 = 1 {$pID} {$limitSql}"; $result = $conn->query($selectSql);

if (!$result || $result->num_rows === 0) {
	sseSend("⚠️ İşlem yapılacak aktif kayıt bulunamadı: {$table} ne='{$ne}' s13=1 {$pID}");
	exit;
}

while ($row = $result->fetch_assoc()) {
    $id    = (int)$row['id'];
    $title = trim($row['t1'] ?? '');
    $baslik = ($title ?: '[başlık yok]');

    sseSend("⏳ {$baslik} (ID={$id}) işleniyor...");

    $combinedPrompt = "Mevcut başlık: \"{$title}\".\nKullanıcının talimatı: \"{$prompt}\".\n";
    $combinedPrompt .= "Aşağıdaki sütunlar için çıktı üret:\n";
    foreach ($columns as $key) {
        switch ($key) {
			case 't1': $combinedPrompt .= "SEO başlık (max 120) -> t1\n"; break;
            case 'n1': $combinedPrompt .= "Paragraflı, detaylı, seo uyumlu ve en az 800 kelimelik içerik üret (HTML yok) -> n1\n"; break;
            case 'n2': $combinedPrompt .= "Maksimum 160 karakter, SEO uyumlu meta description -> n2\n"; break;
            case 'n3': $combinedPrompt .= "Maksimum 120 karakter, SEO odaklı başlık -> n3\n"; break;
            case 'n4': $combinedPrompt .= "5-12 anahtar kelime üret, virgülle ayır -> n4\n"; break;
            case 'n9': $combinedPrompt .= "3-5 cümlelik kısa özet -> n9\n"; break;
        }
    }
    $combinedPrompt .= "Lütfen çıktıyı sadece JSON formatında ver, örn: {\"n1\":\"...\",\"n2\":\"...\",...}";

    $api = fetchFromAPI($combinedPrompt, $apiUrl, $apiKey, 2000);
    $updates = [];

    if ($api['success']) {
        $jsonText = $api['content'];
        if (preg_match('/\{.*\}/s', $jsonText, $m)) {
            $jsonText = $m[0];
        }
        $data = json_decode($jsonText, true);

        if (json_last_error() === JSON_ERROR_NONE && is_array($data)) {
            foreach ($data as $k => $v) {
                if ($k === 'n1') $updates['n1'] = formatParagraphs($v);
                elseif ($k === 'n4') $updates['n4'] = preg_replace('/\s*,\s*/', ',', trim($v));
                else $updates[$k] = trim($v);
            }
        } else {
            sseSend("❌ {$baslik} (ID={$id}) JSON parse hatası. Raw: " . substr($api['content'],0,300));
        }
    } else {
        sseSend("❌ {$baslik} (ID={$id}) API ERROR: " . $api['error']);
    }

    if (!empty($updates)) {
        $setParts = [];
        foreach ($updates as $f => $v) {
            $setParts[] = "`$f`='" . mysqli_real_escape_string($conn, $v) . "'";
        }
        $sql = "UPDATE `$table` SET " . implode(", ", $setParts) . ", ts1=NOW() WHERE id=" . intval($id);
        
        if ($conn->query($sql)) {
            sseSend("✅ {$baslik} (ID={$id}) işlendi: " . implode(", ", array_keys($updates)));
        } else {
            sseSend("❌ {$baslik} (ID={$id}) DB ERROR: " . $conn->error);
        }
    } else {
        sseSend("⚠️ {$baslik} (ID={$id}) için güncellenecek veri oluşmadı.");
    }

    sseSend("----------------------------------------");
}

sseSend("🎉 Tüm kayıtlar işleme alındı.");