<?php
$directory = '../../../alva/conversations/';
$request = json_decode(file_get_contents('php://input'), true);
$fileName = basename($request['fileName'] ?? '');

// Hatalı isim kontrolü
if (empty($fileName)) {
    echo json_encode(['success' => false, 'error' => 'Geçersiz dosya adı']);
    exit;
}

$filePath = $directory . $fileName;

// Silme işlemi
if (file_exists($filePath)) {
    if (unlink($filePath)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Dosya silinemedi']);
    }
} else {
    echo json_encode([
        'success' => false,
        'error' => 'Dosya bulunamadı',
        'filePath' => $filePath // Debug için
    ]);
}