<?php
$path="../../";
include("../../map.php");
// Bugnn tarihi
$todayDate = date('Y-m-d');
// JSON dosyasndaki log verilerini al
function getLogs($date = null) {
    $logDir = findDirectoryPath("deppo").'/logs';  // Log dosyalarnn bulunduu dizin
    $logFiles = glob($logDir . "/log_*.json");
    $logs = [];
    foreach ($logFiles as $logFile) {
        $fileData = json_decode(file_get_contents($logFile), true);
        foreach ($fileData as $log) {
            if ($date === null || strpos($log['timestamp'], $date) === 0) {
                $logs[] = $log;  // Eer tarih eleiyorsa logu ekle
            }
        }
    }
    return $logs;
}
// Loglar al ve yalnzca bugnn verilerini filtrele
$logs = getLogs($todayDate); // Bugnn loglarn al
$groupedLogs = [];
// Loglar tarihe gre grupla
foreach ($logs as $log) {
    $date = date('Y-m-d', strtotime($log['timestamp'])); // Yl-Ay-Gn formatnda tarih
    if (!isset($groupedLogs[$date])) {
        $groupedLogs[$date] = [];
    }
    $groupedLogs[$date][] = $log;  // Gn grubu iinde logu ekle
}
?>
<div class="mt-3 mb-3">
    <div class="timeline timeline-simple mt-3 mb-3">
        <div class="tm-body">
            <div class="tm-title">
                <h5 class="m-0 pt-2 pb-2 text-uppercase"><?php echo aylar(date('m')) ?> <?php echo date('Y') ?></h5>
            </div>
            <ol class="tm-items" style="">
                <?php foreach ($groupedLogs as $date => $dailyLogs){?>
                    <li>
                        <div class="tm-box">
                            <h4><?php echo dtarih($dailyLogs[0]['timestamp'], "gg ka yyyy") ?></h4>
                            <ul class="list-unstyled">
                                <?php foreach ($dailyLogs as $log) { ?>
                                    <li>
                                        <table class="v3-table noshadow" style="margin-bottom:0px;">
                                            <tr class="bg-<?= $log['action_color'] ?> text-white">
                                                <td class="w1 mw1"><?php echo dtarih($dailyLogs[0]['timestamp'],"time")?></td>
                                                <td><?= $log['additional_info'] ?></td>
                                                <td class="w5 mw5"><span class="badge bg-<?= $log['action_color'] ?>"><?= ihb($log['action']) ?></span></td>
                                                <td class="w20 mw20"><span class="badge bg-<?= $log['action_color'] ?>"><?= $log['user'] ?> #<?= ($log['user'] !== "anonymous") ? $log['user_id'] : ""; ?></span></td>
                                                <td class="w1 mw1"><span class="badge bg-<?= $log['action_color'] ?>"><?= $log['ip'] ?></span></td>
                                            </tr>
                                        </table>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                    </li>
                <?php } ?>
            </ol>
        </div>
    </div>
</div>