<?php
// JSON dosyasını oku ve verileri getir
$file = '../../../deppo/ads_report.json';
$id = isset($_GET['id']) ? $_GET['id'] : null;
if ($id && file_exists($file)) {
    $data = json_decode(file_get_contents($file), true);
    if ($_GET["durum"] === 'dreport' && isset($data[$id])) {
        // ID'ye göre veriyi temizle
        unset($data[$id]);
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
        exit;
    }
    $report = isset($data[$id]) ? $data[$id] : [];
} else {
    $report = [];
}
// Son 7 günlük verileri al
$last7Days = [];
$today = date('d.m.Y');
$todayTotal = 0;
$todayUnique = 0;
for ($i = 6; $i >= 0; $i--) {
    $date = date('d.m.Y', strtotime("-$i days"));
    $last7Days[$date] = isset($report[$date]) ? $report[$date] : ['total' => 0, 'unique' => 0];
    // Bugünün verilerini al
    if ($date == date('d.m.Y')) {
        $todayTotal = $last7Days[$date]['total'];
        $todayUnique = $last7Days[$date]['unique'];
    }
}
// Aylık verileri hesapla
$monthlyData = [];
$monthTotal = 0;
$monthUnique = 0;
foreach ($report as $date => $values) {
    $monthYear = substr($date, 3); // Tarihten ay ve yıl bilgisi
    if (!isset($monthlyData[$monthYear])) {
        $monthlyData[$monthYear] = ['total' => 0, 'unique' => 0];
    }
    $monthlyData[$monthYear]['total'] += $values['total'];
    $monthlyData[$monthYear]['unique'] += $values['unique'];
    // Bu ayın toplamlarını hesapla
    if ($monthYear == date('m.Y')) {
        $monthTotal += $values['total'];
        $monthUnique += $values['unique'];
    }
}
// JSON ile veri aktarımı için PHP'den JavaScript'e veri gönder
echo "
<script type='text/javascript'>
	var last7DaysData = " . json_encode($last7Days) . ";
	var monthlyData = " . json_encode($monthlyData) . ";
</script>";
?>
<fieldset style="">
	<legend>{<b><?php echo $rs["t1"];?></b>} <?php echo $reklam[0]; //Reklam?>  <?php echo $sdil[38]; //Rapor?>
		<div onclick="location.href='?ne=<?php echo $_GET["ne"];?>&islem=<?php echo $_GET["islem"];?>&id=<?php echo $_GET["id"];?>&durum=dreport'" title="Rapor Temizle" class="fas fa-trash v3-btn"></div>
		<!--<div onclick="location.href='?ne=<?php echo $_GET["ne"];?>&islem=<?php echo $_GET["islem"];?>&id=<?php echo $_GET["id"];?>&durum=export'" title="Excel Olarak İndir" class="fas fa-file-excel v3-btn"></div> -->
	</legend>
	<div style="width:100%; position:relative; min-height:100px;">
		<div id="piechart_3dz" style="width: 49%; height: 400px; float:left;"></div>
		<div id="chart_div" style="width: 49%; height: 400px; float:right;"></div>
	</div>
<div class="d-flex gap-2 mt-3" style="display: inline-block; margin-top:15px;">
    <button class="btn btn-success">
        <b>
 Bugün:</b> <?php echo $todayUnique; ?> uniq, <?php echo $todayTotal; ?> toplam
    </button>
    
    <button class="btn btn-primary">
        <b>📆 Bu Ay:</b> <?php echo $monthUnique; ?> uniq, <?php echo $monthTotal; ?> toplam
    </button>
</div>
</fieldset>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
	google.charts.load('current', { packages: ['corechart'] });
	google.charts.setOnLoadCallback(drawCharts);
	function drawCharts() {
        // Son 7 Günlük Pie Chart Verisi
		var pieDataArray = [['Day', 'Total', 'Uniq']];
		for (var date in last7DaysData) {
			var total = last7DaysData[date].total || 0;
			var unique = last7DaysData[date].unique || 0;
            pieDataArray.push([date, total, unique]); // Total ve Unique verileri ekleniyor
        }
        var pieData = google.visualization.arrayToDataTable(pieDataArray);
        var pieOptions = {
        	title: 'Son 7 Günlük Ziyaretler / Last 7 Days Visits',
        	pieHole: 0.4,
        	is3D: true
        };
        var pieChart = new google.visualization.PieChart(document.getElementById('piechart_3dz'));
        pieChart.draw(pieData, pieOptions);
        // Aylık Bar Chart Verisi
        var barDataArray = [['Month', 'Total', 'Uniq']];
        for (var month in monthlyData) {
        	var total = monthlyData[month].total || 0;
        	var unique = monthlyData[month].unique || 0;
        	barDataArray.push([month, total, unique]);
        }
        var barData = google.visualization.arrayToDataTable(barDataArray);
        var barOptions = {
        	title: 'Aylık Ziyaretler / Monthly Visits',
        	vAxis: { title: 'Ay / Month', titleTextStyle: { color: 'red' } },
        	hAxis: { title: 'Ziyaretler / Visits', titleTextStyle: { color: 'blue' } },
            isStacked: true // Toplam ve Unique veriler üst üste gösterilir
        };
        var barChart = new google.visualization.BarChart(document.getElementById('chart_div'));
        barChart.draw(barData, barOptions);
    }
</script>