<?php
session_start();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Yapım Aşamasında</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
<style>
	.underconstruction { position: fixed; width: 100%; height: 100vh; background: rgba(0, 0, 0, 0.95) url('https://cdn.crmplus.com.tr/themes/images/offices.jpg') no-repeat center center; background-size: cover; z-index: 999999; color: #fff; overflow: hidden; }
	.underconstruction::before { content: ''; position: absolute; top: 0; left: -75%; width: 50%; height: 100%; background: linear-gradient(120deg, rgba(255,255,255,0) 0%, rgba(255,255,255,0.2) 50%, rgba(255,255,255,0) 100%); transform: skewX(-25deg); animation: shine 6s infinite; pointer-events: none; }
	@keyframes shine { 0% { left: -75%; } 100% { left: 125%; } }
	.underconstruction h1, .underconstruction h2, .underconstruction h3, .underconstruction p { color: #fff !important; }
	.uc-footer { position: absolute; bottom: 0; width: 100%; background: rgba(0, 0, 0, 0.5); padding: 30px 0 20px; font-size: 0.95rem; }
	.uc-footer .container { display: flex; flex-direction: column; align-items: center; text-align: center; }
	.uc-footer h2 { font-size: 1.25rem; margin-bottom: 10px; }
	.uc-footer p { margin: 0; line-height: 1.6; }
	.uc-footer a { color: #fff; text-decoration: none; transition: color 0.2s; }
	.uc-footer a:hover { color: #ddd; }
	.uc-footer .btn { margin-top: 15px; }
	@media (min-width: 768px) {
		.uc-footer .container { flex-direction: row; justify-content: space-between; align-items: center; text-align: left; flex-wrap: wrap; }
		.uc-footer p, .uc-footer h2 { margin: 0 20px 10px; }
		.uc-footer .btn { margin: 10px 20px 0 auto; }
	}
</style>

</head>
<body>
<?php if (!isset($_SESSION["skip_underconstruction"])): ?>
<div class="underconstruction d-flex align-items-center justify-content-center text-center flex-column" id="underConstruction">
  <img src="<?php echo $logo ?>" alt="Logo" class="mb-4" style="max-height: 100px;">
  <div class="mb-4 px-4">
    <!--<h1 class="mb-3">Site Yapım Aşamasında</h1>-->
    <p style="margin-top:15px;"><?php echo $n20 ?></p>
  </div>
  <div class="uc-footer">
    <div class="container">
      <h2 class="h5 mb-2"><?php echo ($firma !== "Firma" ? $firma : $powered); ?></h2>
      <p>
        <a href="tel:<?php echo ($ftel !== "Tel" ? $ftel : $ptel); ?>" class="text-white me-3">
          <i class="bi bi-telephone"></i> <?php echo ($ftel !== "Tel" ? $ftel : $ptel); ?>
        </a>
        <a href="mailto:<?php echo $fmail ?>" class="text-white me-3">
          <i class="bi bi-envelope"></i> <?php echo $fmail ?>
        </a>
        <span class="text-white d-block"><i class="bi bi-geo-alt"></i> <?php echo $fadres ?></span>
      </p>
      <a href="#" id="skipBtn" class="btn btn-outline-light mt-2"><i class="bi bi-forward-fill"></i> Atla</a>
    </div>
  </div>
</div>
<?php endif; ?>
<script>
  document.addEventListener("DOMContentLoaded", function() {
    if (sessionStorage.getItem("skip_underconstruction") === "skipped") {
      const ucDiv = document.getElementById("underConstruction");
      if (ucDiv) ucDiv.remove();
    }
    const skipBtn = document.getElementById("skipBtn");
    if (skipBtn) {
      skipBtn.addEventListener("click", function(e) {
        e.preventDefault();
        sessionStorage.setItem("skip_underconstruction", "skipped");
        // PHP tarafına da ilet
        fetch('?skip=true').then(() => location.reload());
      });
    }
  });
</script>
<?php
// JS'den fetch ile gelirse session'a kaydet
if (isset($_GET["skip"])) {
  $_SESSION["skip_underconstruction"] = "skipped";
  exit();
}
?>
</body>
</html>