<?php
header('Content-type: text/html; charset=utf-8');

$translationFileLocal = $_SERVER['DOCUMENT_ROOT'] . "/deppo/datas/translations.json";

// Yazma işlemini güvenli hale getiren yardımcı fonksiyon
function safeWriteJson($file, $data) {
    $json = json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    // LOCK_EX kullanarak aynı anda yazma çakışmalarını önleriz
    return file_put_contents($file, $json, LOCK_EX);
}

if ($_GET["type"] == "transfer") {
    $data = json_decode(file_get_contents('php://input'), true);
    if (empty($data)) { exit('Geçersiz veya boş veri.'); }
    
    if (safeWriteJson($translationFileLocal, $data)) {
        echo 'Başarıyla güncellendi.';
    }
} 
elseif ($_GET["type"] == "add") {
    // Hem 'key' hem 'metin' parametrelerini kontrol et (Çakışmayı önlemek için)
    $metin = $_POST['key'] ?? $_POST['metin'] ?? '';
    
    if (empty($metin)) { exit; }

    $translations = [];
    if (file_exists($translationFileLocal)) {
        $content = file_get_contents($translationFileLocal);
        $translations = json_decode($content, true);

        // KRİTİK: Eğer JSON bozuksa veya okunmadıysa, üzerine yazma!
        if (!is_array($translations)) {
            exit('Dosya okuma hatası: İçerik korunuyor.'); 
        }

        // Mevcut mu kontrol et
        foreach ($translations as $translation) {
            if (($translation['key'] ?? '') === $metin) {
                exit; // Zaten var
            }
        }
    }

    // Benzersiz ID oluştur (Eğer liste boşsa 1'den başla)
    $newId = (!empty($translations)) ? max(array_keys($translations)) + 1 : 1;

    // Yeni çeviriyi ekle
    $translations[$newId] = [
        "key"   => $metin,
        "lang1" => (strpos($metin, '+') === 0 ? substr($metin, 1) : $metin) // + varsa temizleyip lang1'e yaz
    ];

    // Kaydet
    safeWriteJson($translationFileLocal, $translations);
}
?>