<?php
class SOAPAPI {
protected $client, $base_url, $options, $auth_params, $additional_params, $convert_to_objects, $debug;
public function __construct($base_url, $auth_params = [], $login = [], $additional_params = [], $convert_to_objects = false, $debug = false){
	$this->base_url = $base_url;
	$this->auth_params = $auth_params;
	$this->additional_params = $additional_params;
	$this->options = array_merge(['trace' => true, 'cache_wsdl' => WSDL_CACHE_NONE], $login);
	$this->convert_to_objects = $convert_to_objects;
	$this->debug = $debug;
}
protected function array_to_object($array){
	if(is_numeric(key($array))){
		foreach($array as $key => $value){
			$array[$key] = $this->array_to_object($value);
		}
		return $array;
	}
	$Object = new stdClass();
	foreach($array as $key => $value){
		if(is_array($value)){
			$Object->$key = $this->array_to_object($value);
		}else{
			$Object->$key = $value;
		}
	}
	return $Object;
}
public function call($service, $method, $params = []){
	try{
		$this->client = new \SoapClient(str_replace('{SERVICENAME}', $service, $this->base_url), $this->options);
	}catch(\SoapFault $e){
		print_r($e->getMessage());
		exit;
	}
	$params = array_merge(array_merge($this->auth_params, $params), $this->additional_params);
	if($this->convert_to_objects){
		$params = [$this->array_to_object($params)];
	}
	try{
		$response = $this->client->__soapCall($method, $params);
	}catch(\Exception $e){
		echo 'SOAP Error<br/>Message: ' . $e->getMessage() . '<br/>Headers: ' . $this->client->__getLastResponseHeaders() . '<br/>Request body: <pre>' . htmlentities($this->client->__getLastRequest()) .  '</pre>Request raw parameters: ';
		echo 'Request body: <pre>';
		print_r($params);
		echo '</pre>';
		exit;
	}
	if($this->debug){
		echo 'Request body: <pre>' . htmlentities($this->client->__getLastRequest()) .  '</pre>';
	}
	return $response;
}
}