<?php
// comments.php

// Güvenli Path Dahil Etme
$root_path = __DIR__ . "/../../../"; // Dosya konumuna göre göreceli tam yol
if(file_exists($root_path . "config/map.php")) {
    include($root_path . "config/map.php");
} else {
    // Fallback
    include("../../../map.php"); 
}
include("fonksiyon".$ver.".php");

// Güvenlik: ID integer zorlaması
$content_id = isset($_GET["id"]) ? (int)$_GET["id"] : 0;

if($content_id == 0) { exit; }

// Prepared Statement ile Veri Çekme
$sql = "SELECT * FROM genel WHERE ne='yorum' AND s1=? AND s4=1 ORDER BY ts1 DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $content_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    while ($rsy = $result->fetch_assoc()) {
        // Kullanıcı Adını Belirle
        $user_name = translate("Misafir");
        if ($rsy["s2"] > 0) {
            // Üye tablosundan çek (Performans için JOIN kullanılabilir ama yapıyı bozmuyoruz)
            $sub_stmt = $conn->prepare("SELECT t1 FROM t5 WHERE id=?");
            $sub_stmt->bind_param("i", $rsy["s2"]);
            $sub_stmt->execute();
            $sub_res = $sub_stmt->get_result();
            if ($u_row = $sub_res->fetch_assoc()) {
                $user_name = $u_row["t1"];
            }
            $sub_stmt->close();
        } elseif (!empty($rsy["t4"])) {
            $user_name = $rsy["t4"];
        }

        // XSS Koruması: Çıktıları Temizle
        $clean_name = htmlspecialchars($user_name, ENT_QUOTES, 'UTF-8');
        $clean_comment = nl2br(htmlspecialchars($rsy["n1"], ENT_QUOTES, 'UTF-8'));
        $clean_reply = (!empty($rsy["n2"])) ? nl2br(htmlspecialchars($rsy["n2"], ENT_QUOTES, 'UTF-8')) : '';
        $time_ago = timeAgo($rsy["ts1"]);
        $stars = (int)$rsy["s3"];
?>

    <div class="comment-item" style="border:1px solid #eee; border-radius:5px; padding:15px; margin-bottom:15px; background:#fff;">
        <div style="display:flex; align-items:flex-start;">
            <div style="flex:0 0 50px; text-align:center; margin-right:15px;">
                <div style="width:50px; height:50px; background:#f1f1f1; border-radius:50%; display:flex; align-items:center; justify-content:center; color:#888;">
                    <i class="fas fa-user" style="font-size:24px;"></i>
                </div>
            </div>

            <div style="flex:1;">
                <div style="display:flex; justify-content:space-between; margin-bottom:5px;">
                    <div>
                        <strong style="font-size:14px; color:#333;"><?php echo $clean_name; ?></strong>
                        <small style="color:#999; margin-left:10px; font-size:12px;"><i class="far fa-clock"></i> <?php echo $time_ago; ?></small>
                    </div>
                    <?php if($stars > 0): ?>
                    <div style="color:#f39c12; font-size:12px;">
                        <?php 
                        for($i=0; $i<$stars; $i++) echo '<i class="fas fa-star"></i>';
                        for($i=$stars; $i<5; $i++) echo '<i class="far fa-star"></i>'; // Boş yıldızlar
                        ?>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div style="font-size:14px; color:#555; line-height:1.5;">
                    <?php echo $clean_comment; ?>
                </div>

                <?php if($clean_reply): ?>
                <div style="margin-top:15px; background:#f9f9f9; padding:10px; border-left:3px solid #3498db; border-radius:3px;">
                    <div style="display:flex; align-items:center; margin-bottom:5px;">
                        <i class="fas fa-user-shield" style="color:#3498db; margin-right:8px;"></i>
                        <strong style="font-size:13px; color:#333;"><?php echo translate("Yetkili Cevabı"); ?></strong>
                        <small style="color:#999; margin-left:auto; font-size:11px;"><?php echo timeAgo($rsy["ts2"]); ?></small>
                    </div>
                    <div style="font-size:13px; color:#666;">
                        <?php echo $clean_reply; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

<?php 
    } // While sonu
} else {
    // Hiç yorum yoksa boş dönebilir veya UI tarafında yönetilebilir.
}
$stmt->close();
?>