<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
// Cihaz tipini tespit eden fonksiyon
function getDeviceType() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    if (strpos($userAgent, 'Mobile') !== false || strpos($userAgent, 'Tablet') !== false) {
        return 'Mobile';
    }
    return 'Desktop';
}
// Kullanc IP adresini tespit eden fonksiyon
function getVisitorIP() {
    return $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';
}
// JSON dosyasndan veri alr
function loadData($file) {
    if (!file_exists($file)) {
        return [
            'daily' => [], // Gnlk veriler
            'urls' => [], // URL'lere gre hitler
            'devices' => ['Mobile' => ['total' => 0, 'unique' => 0], 'Desktop' => ['total' => 0, 'unique' => 0]], // Cihaz trleri
        ];
    }
    return json_decode(file_get_contents($file), true);
}
// Veriyi JSON dosyasna yazar
function saveData($file, $data) {
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
}
// Eski gnlk verileri temizler (1 hafta ncesini siler)
function removeOldDailyData(&$data) {
    $oneWeekAgo = new DateTime(date('Y-m-d', strtotime('-7 days')));
    foreach ($data['daily'] as $date => $stats) {
        $entryDate = new DateTime($date);
        if ($entryDate < $oneWeekAgo) { // Tarih kyaslamasn DateTime ile yap
            unset($data['daily'][$date]);
        }
    }
}
// Gnlk verileri gnceller
function updateDailyVisits(&$data) {
    $currentDate = date('Y-m-d');
    if (!isset($data['daily'][$currentDate])) {
        $data['daily'][$currentDate] = ['total' => 0, 'unique' => 0];
    }
    $data['daily'][$currentDate]['total'] += 1;
    if (!isset($_SESSION['visited_daily'][$currentDate])) {
        $data['daily'][$currentDate]['unique'] += 1;
        $_SESSION['visited_daily'][$currentDate] = true; // Unique hit kontrol
    }
}
// URL hitlerini gnceller
function updatePageVisits(&$data, $currentPage) {
    if (!isset($data['urls'][$currentPage])) {
        $data['urls'][$currentPage] = ['total' => 0, 'unique' => 0];
    }
    $data['urls'][$currentPage]['total'] += 1;
    if (!isset($_SESSION['visited_urls'][$currentPage])) {
        $data['urls'][$currentPage]['unique'] += 1;
        $_SESSION['visited_urls'][$currentPage] = true; // Unique hit kontrol
    }
}
// Cihaz tr verilerini gnceller
function updateDeviceVisits(&$data, $deviceType) {
    if (!isset($data['devices'][$deviceType])) {
        $data['devices'][$deviceType] = ['total' => 0, 'unique' => 0];
    }
    $data['devices'][$deviceType]['total'] += 1;
    if (!isset($_SESSION['visited_devices'][$deviceType])) {
        $data['devices'][$deviceType]['unique'] += 1;
        $_SESSION['visited_devices'][$deviceType] = true; // Unique hit kontrol
    }
}
// JSON dosyas ad
$dataFile = $_SERVER['DOCUMENT_ROOT'] . "/deppo/analytics.json";
// Veriyi ykle
$data = loadData($dataFile);
// Cihaz tipini tespit et
$deviceType = getDeviceType();
// Geerli sayfa URL'si
$currentPage = $_SERVER['QUERY_STRING'];
if (empty($currentPage)) {
    $currentPage = "anasayfa";
}
// zleme ilemi yaplyorsa
if (empty($notrack)) {
    // Eski gnlk verileri temizle
    removeOldDailyData($data);
    // Gnlk verileri gncelle
    updateDailyVisits($data);
    // URL hitlerini gncelle
    updatePageVisits($data, $currentPage);
    // Cihaz verilerini gncelle
    updateDeviceVisits($data, $deviceType);
    // Veriyi kaydet
    saveData($dataFile, $data);
}
?>