<?php
header('Content-Type: text/html; charset=utf-8');
error_reporting(0);
// Gerekli dosyaları dahil ediyoruz
$path = "../../";
include("../../map.php");
include("../../scripts.php");
include("../../secure.php");
// Analytics JSON dosyasını yüklüyoruz
$jsonPath = findDirectoryPath("deppo") . "/analytics.json";
if (!file_exists($jsonPath)) {
    die("Analytics dosyası bulunamadı.");
}
$jsonContent = file_get_contents($jsonPath);
$analyticsData = json_decode($jsonContent, true);
if (!is_array($analyticsData)) {
    die("Analytics verisi okunamadı veya geçerli bir JSON formatında değil.");
}
// Günlük, haftalık ve aylık verileri hesaplıyoruz
$dailyData = $analyticsData['daily'] ?? []; // Günlük veriler
$weeklyData = []; // Haftalık veriler
$monthlyData = []; // Aylık veriler
foreach ($dailyData as $date => $entry) {
    $week = date('o-W', strtotime($date)); // ISO yıl ve hafta
    $month = date('Y-m', strtotime($date)); // Yıl ve ay
    // Haftalık verileri topluyoruz
    if (!isset($weeklyData[$week])) {
        $weeklyData[$week] = ['total' => 0, 'unique' => 0];
    }
    $weeklyData[$week]['total'] += $entry['total'];
    $weeklyData[$week]['unique'] += $entry['unique'];
    // Aylık verileri topluyoruz
    if (!isset($monthlyData[$month])) {
        $monthlyData[$month] = ['total' => 0, 'unique' => 0];
    }
    $monthlyData[$month]['total'] += $entry['total'];
    $monthlyData[$month]['unique'] += $entry['unique'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Analytics</title>
</head>
<body>
    <div class="qmodal">
        <div class="qmodal-content">
            <!-- Header with Action Buttons -->
            <div class="qmodal-header">
			<div class="header-title">
				<nav aria-label="breadcrumb">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="?"><i class="fa fa-home"></i></a></li>
						<li class="breadcrumb-item"><a href="#">CrmPlus+</a></li>
						<li class="breadcrumb-item active" aria-current="page">Analytics</li>
					</ol>
				</nav>
			</div>
                <button type="button" class="btn btn-warning" onclick="location.href='?'"><i class="fas fa-home"></i></button>
				<?php if($MSA==1){?>
                <button type="button" class="btn btn-danger" onclick="location.href='?ne=<?php echo $_GET["ne"];?>&islem=<?php echo $_GET["islem"];?>&durum=danalytics'"><i class="fa fa-trash"></i></button>
              <?php }?>
            </div>
            <!-- Left Tab Menu -->
            <div class="v8-columns">
                <!-- Content Area -->
<!-- İçerik alanı -->
            <div class="col-12">
                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane show active" id="pills-content-1" role="tabpanel" aria-labelledby="pills-tab-1">
						<div class="row">
							<!-- Günlük ziyaretçi (Donut Chart) -->
							<div class="col-md-6">
								<h4>Günlük Ziyaretçi</h4>
								<div id="daily-donut-chart" style="height: 300px;"></div>
							</div>
							<!-- Aylık ziyaretçi (Bar Chart) -->
							<div class="col-md-6">
								<h4>Aylık Ziyaretçi</h4>
								<div id="monthly-bar-chart" style="height: 300px;"></div>
							</div>
						</div>
						<div class="row mt-5">
							<!-- Haftalık ziyaretçi -->
							<div class="col-md-4">
								<h4>Haftalık Ziyaretler</h4>
								<div id="weekly-bar-chart" style="height: 300px;"></div>
							</div>
							<!-- Son ziyaret edilen sayfalar -->
							<div class="col-md-4">
								<h4>Son Ziyaretler</h4>
								<ul id="recent-visits" class="list-group" style="height:475px; overflow:auto;"></ul>
							</div>
							<!-- Cihaz türleri -->
							<div class="col-md-4">
								<h4>Cihaz Türleri</h4>
								<div id="device-chart" style="height: 300px;"></div>
							</div>
						</div>
                    </div>
                </div>
            </div>
	 </div>
</div>
</body>
<?php
if($_GET["durum"]=="danalytics"){
  unlink($json);
  echo location("?ne=".$_GET["ne"]."&islem=".$_GET["islem"]."&durum=ok",self,500,1);  
}
?>
<?php echo $footer?>
<!-- Bootstrap JS -->
<script src="https://www.gstatic.com/charts/loader.js"></script>
<script>
    // Google Charts yükleniyor
    google.charts.load('current', {'packages': ['corechart', 'bar']});
    google.charts.setOnLoadCallback(drawCharts);
    function drawCharts() {
        drawDailyDonutChart();
        drawDeviceChart();
        populateRecentVisits();
        drawWeeklyChart();
        drawMonthlyChart();
    }
    // Günlük ziyaretçi (Donut Chart)
    function drawDailyDonutChart() {
    var data = google.visualization.arrayToDataTable([
        ['Gün', 'Eşsiz Ziyaretçi'], // Başlıklar
        <?php
        $limitedData = array_slice($dailyData, -7, 7, true); // Son 7 kaydı al
        foreach ($limitedData as $date => $entry) {
            echo "['" . $date . "', " . $entry['unique'] . "],";
        }
        ?>
    ]);
    var options = {
        title: 'Günlük Ziyaretçi (Eşsiz)',
        pieHole: 0.4
    };
    var chart = new google.visualization.PieChart(document.getElementById('daily-donut-chart'));
    chart.draw(data, options);
}
    // Cihaz türleri (Donut Chart)
    function drawDeviceChart() {
        var data = google.visualization.arrayToDataTable([
            ['Cihaz', 'Ziyaret'], // Başlıklar
            ['Mobile', <?php echo $analyticsData['devices']['Mobile']['total'] ?? 0; ?>],
            ['Desktop', <?php echo $analyticsData['devices']['Desktop']['total'] ?? 0; ?>],
        ]);
        var options = {
            title: 'Cihaz Türleri',
            pieHole: 0.4
        };
        var chart = new google.visualization.PieChart(document.getElementById('device-chart'));
        chart.draw(data, options);
    }
    // Haftalık ziyaret verileri (Bar Chart)
    function drawWeeklyChart() {
        var data = google.visualization.arrayToDataTable([
            ['Hafta', 'Eşsiz Ziyaretçi'], // Başlıklar
            <?php
            foreach ($weeklyData as $week => $entry) {
                echo "['" . $week . "', " . $entry['unique'] . "],";
            }
            ?>
        ]);
        var options = {
            title: 'Haftalık Ziyaretçi (Eşsiz)',
            chartArea: {width: '50%'},
            hAxis: {
                title: 'Eşsiz Ziyaretçi Sayısı',
                minValue: 0
            },
            vAxis: {
                title: 'Hafta'
            }
        };
        var chart = new google.visualization.BarChart(document.getElementById('weekly-bar-chart'));
        chart.draw(data, options);
    }
    // Aylık ziyaret verileri (Bar Chart)
    function drawMonthlyChart() {
        var data = google.visualization.arrayToDataTable([
            ['Ay', 'Eşsiz Ziyaretçi'], // Başlıklar
            <?php
            foreach ($monthlyData as $month => $entry) {
                echo "['" . $month . "', " . $entry['unique'] . "],";
            }
            ?>
        ]);
        var options = {
            title: 'Aylık Ziyaretçi (Eşsiz)',
            chartArea: {width: '50%'},
            hAxis: {
                title: 'Eşsiz Ziyaretçi Sayısı',
                minValue: 0
            },
            vAxis: {
                title: 'Ay'
            }
        };
        var chart = new google.visualization.BarChart(document.getElementById('monthly-bar-chart'));
        chart.draw(data, options);
    }
   // Son ziyaret edilen sayfalar (Listeleme)
function populateRecentVisits() {
    var visits = <?php echo json_encode($analyticsData['urls']); ?>; // PHP'den gelen URL verileri
    var list = document.getElementById('recent-visits'); // Liste DOM elementi
    // Ziyaretleri sıralı bir dizi haline getir (azalan sıralama)
    var sortedVisits = Object.entries(visits)
        .sort((a, b) => b[1].total - a[1].total) // Toplam hit sayısına göre azalan sırala
        .slice(0, 10); // İlk 10 kaydı al
    // Listeyi doldur
    list.innerHTML = ""; // Listeyi temizle
    sortedVisits.forEach(([page, hit]) => {
        list.innerHTML += `<li class="list-group-item"><a href="<?php echo $weburl?>?${page}" target="_blank">${page}</a> <span class="badge" title="(${hit.unique} Tekil">${hit.total}</span></li>`;
    });
}
</script>
</html>