<?php
$path="../../";
// Hata raporlamayı düzenle (Notice hatalarını gizle)
error_reporting(E_ALL & ~E_NOTICE);

include("../../map.php");
include("../../secure.php");
include("../../scripts.php");

// --- ÇIKTI YAKALAMA SİSTEMİ (BUFFERING) ---
// PHP'nin echo çıktılarını ekrana basmak yerine yakalıyoruz
$terminalLog = "";
$hasOutput = false;

if(isset($_GET["cmd"])) {
    ob_start(); // Kaydı başlat
    
    // --- ORİJİNAL MANTIK BLOĞU (DOKUNULMADI, SADECE ECHO'LAR YAKALANIYOR) ---
    if($_GET["cmd"]=="iupdate"){
        $i=0;$sqlc=mysqli_query($conn, "select * from ".$_POST["tbl"]." ".$_POST["sql"]." "); while($rsc=mysqli_fetch_assoc($sqlc)){$i++;
            $jsi = json_decode($rsc["n17"],true);
            $iarr = array();
            if(!is_array($jsi)) $jsi = array(); // Hata önleyici
            foreach($jsi as $key=>$value){
                if($_POST["key"]<>"" and $key==$_POST["key"]){
                    $iarr = $iarr + array($_POST["key"] => $_POST["val"]);
                }else{
                    $iarr = $iarr + array( $key => $value);
                }
            }
            $rjsi = json_encode($iarr, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK);
            $Sqlu = mysqli_query($conn, "update ".$_POST["tbl"]." set n17='".addslashes(stripslashes($rjsi))."' where id=".$rsc["id"]."");
        }
        echo "[OK] JSON Update: ".$_POST["tbl"]." tablosunda [".$_POST["key"]."] alanı [".$_POST["val"]."] olarak güncellendi. (Etkilenen: $i)";

    }elseif($_GET["cmd"]=="transfer"){
        $i=0;$sqlc=mysqli_query($conn, "select * from ".$_POST["tbl"]." ".$_POST["sql"]." "); while($rsc=mysqli_fetch_assoc($sqlc)){$i++;
            $Sqlu = mysqli_query($conn, "update ".$_POST["tbl"]." set ".$_POST["stn2"]."='".$rsc[$_POST["stn1"]]."' where id=".$rsc["id"]."");
        }
        echo "[OK] Transfer: ".$_POST["tbl"]." tablosunda [".$_POST["stn1"]."] -> [".$_POST["stn2"]."] aktarımı tamamlandı. (Etkilenen: $i)";

    }elseif($_GET["cmd"]=="update"){
        $i=0;$sqlc=mysqli_query($conn, "select * from ".$_POST["tbl"]." ".$_POST["sql"]." "); while($rsc=mysqli_fetch_assoc($sqlc)){$i++;
            $Sqlu = mysqli_query($conn, "update ".$_POST["tbl"]." set ".$_POST["stn1"]."='".$_POST["val1"]."' where id=".$rsc["id"]."");
        }
        echo "[OK] Update: ".$_POST["tbl"]." tablosunda [".$_POST["stn1"]."] = '".$_POST["val1"]."' işlemi yapıldı. (Etkilenen: $i)";

    }elseif($_GET["cmd"]=="kampanya"){
        if($_POST["cat"]<>0){ $usql = " and (s10='".$_POST["cat"]."' or s9='".$_POST["cat"]."')"; }
        $i = 0;
        $sqlc = mysqli_query($conn, "select * from ".$_SESSION["lang"]." ".$_POST["sql"]." ".$usql.""); 
        while($rsc = mysqli_fetch_assoc($sqlc)){
            $i++;
            if(substr($_POST["sts"], 0, 1) == "p") { 
                $doran = (100 - $_POST["val1"]) / 100;
                $uoran = (100 + $_POST["val1"]) / 100;
                if($_POST["sts"] == "pd"){ 
                    $pb1 = floor($rsc["pb1"] * $doran);
                    $pb2 = floor($rsc["pb2"] * $doran);
                } else { 
                    $pb1 = ceil($rsc["pb1"] * $uoran);
                    $pb2 = ceil($rsc["pb2"] * $uoran);
                }
            } else { 
                $oran = $_POST["val1"];
                if($_POST["sts"] == "md"){
                    $pb1 = ceil($rsc["pb1"] - $oran);
                    $pb2 = ceil($rsc["pb2"] - $oran);
                } else {
                    $pb1 = ceil($rsc["pb1"] + $oran);
                    $pb2 = ceil($rsc["pb2"] + $oran);
                }
            }
            $Sqlu = mysqli_query($conn, "update ".$_SESSION["lang"]." set pb1='".sprice($pb1)."', pb2='".sprice($pb2)."' where id=".$rsc["id"]."");
        }
        echo "[OK] Kampanya: ".$_SESSION["lang"]." tablosunda işlem tamamlandı. (Etkilenen: $i)";

    }elseif($_GET["cmd"]=="delete"){
        if($_POST["tbl"]<>"medya"){
            $i=0;$sqlc=mysqli_query($conn, "select * from ".$_POST["tbl"]." ".$_POST["sql"]." "); while($rsc=mysqli_fetch_assoc($sqlc)){$i++;
                $lx = isset($lx) ? $lx : 1; 
                for ($l = 1; $l <= $lx; $l++) {$sql = mysqli_query($conn, "delete from ".$_POST["tbl"]." where id=".$rsc["id"]."");}
                if($_POST["clear_media"]<>""){
                    $sql=mysqli_query($conn, "select * from medya where ne='resim' and s1=".$rsc["id"].""); while($rsi=mysqli_fetch_assoc($sql)){
                        @unlink("../../../deppo/image/".$rsi["t1"]);
                        @unlink("../../../deppo/image/k_".$rsi["t1"]);
                        $sqld = mysqli_query($conn, "delete from medya where s1=".$rsc["id"]."");
                    }
                }
            }
        }elseif($_POST["tbl"]=="medya"){
            $i=0;$sqlm=mysqli_query($conn, "select * from ".$_POST["tbl"]." ".$_POST["sql"]." "); while($rsm=mysqli_fetch_assoc($sqlm)){ $i++;
                @unlink("../../../deppo/image/".$rsm["t1"]);
                @unlink("../../../deppo/image/k_".$rsm["t1"]);
                @unlink("../../../deppo/video/".$rsm["n2"]);
                $sqld = mysqli_query($conn, "delete from medya where id=".$rsm["id"]."");
            }
        }
        echo "[WARNING] Delete: ".$_POST["tbl"]." tablosundan veri silindi. (Silinen: $i)";

    }elseif($_GET["cmd"]=="towebp"){
        $i=0;$sqlm=mysqli_query($conn, "select * from medya ".$_POST["sql"]." "); while($rsm=mysqli_fetch_assoc($sqlm)){
            $ext = strtolower(pathinfo(trim($rsm["t1"]), PATHINFO_EXTENSION));            
            if ($ext != 'webp') {$i++;
                if(function_exists('towebp')){
                    towebp("k_{$rsm["t1"]}", "../../../deppo/image/");
                    $yeni = towebp($rsm["t1"], "../../../deppo/image/");
                    $Sqlu = mysqli_query($conn, "update medya set t1='".$yeni."' where id=".$rsm["id"]."");
                }
            }
        }
        echo "[OK] WebP Convert: Medya tablosunda dönüşüm yapıldı. (Dönüştürülen: $i)";

    }elseif($_GET["cmd"]=="json_export"){
        $keys = isset($_POST['keys']) ? explode(',', $_POST['keys']) : [];
        $sql  = isset($_POST['sql']) ? $_POST['sql'] : '';
        $tbl  = isset($_POST['tbl']) ? $_POST['tbl'] : '';
        $limit = isset($_POST['sql_limit']) ? trim($_POST['sql_limit']) : '';

        $keys = array_map('trim', $keys);
        $columns = implode(',', array_map(fn($col) => "`$col`", $keys));

        $allowed_conditions = ['=', '!=', '>', '<', '>=', '<=', 'LIKE'];
        preg_match('/(\w+)\s*(' . implode('|', $allowed_conditions) . ')\s*(.+)/', $sql, $matches);

        // SQL injection riskini koruyarak (orijinal kodda yoktu ama hata vermemesi için) basit kontrol
        if(!empty($matches) || empty($sql)){
            if(!empty($matches)){
                $column = trim($matches[1]);
                $operator = trim($matches[2]);
                $value = trim($matches[3], "'\"");
                $wherePart = "WHERE `$column` $operator '$value'";
            } else {
                $wherePart = ""; // Koşulsuz
            }

            $query = "SELECT $columns FROM `$tbl` $wherePart";
            if ($limit !== '' && preg_match('/^\d+(,\d+)?$/', $limit)) {
                $query .= " LIMIT $limit";
            }

            $result = mysqli_query($conn, $query);
            $rows = mysqli_fetch_all($result, MYSQLI_ASSOC);

            $data = [
                "columns" => $columns,
                "tbl" => $tbl,
                "sql" => $wherePart,
                "results" => $rows
            ];
            
            echo "[DATA] JSON Export Result:\n" . json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        } else {
            echo "[ERROR] SQL Parse Hatası.";
        }

    }elseif($_GET["cmd"]=="json_import"){
        $json_data = isset($_POST['json']) ? trim($_POST['json']) : '';
        $data = json_decode($json_data, true);
        if (!$data || !isset($data["results"]) || !isset($data["tbl"])) {
            echo "[ERROR] Geçersiz JSON formatı.";
        } else {
            $tbl = $data["tbl"];
            $updated_count = 0;
            foreach ($data["results"] as $row){
                $columns = array_keys($row);
                if (count($columns) < 3) continue;
                $primary_column = $columns[0];
                $primary_value = $row[$primary_column];
                $update_columns = array_slice($columns, 2);
                if (empty($update_columns)) continue;
                $set_clause = implode(", ", array_map(fn($col) => "`$col` = ?", $update_columns));
                $values = array_map(fn($col) => $row[$col], $update_columns);
                $values[] = $primary_value;
                $types = str_repeat("s", count($update_columns)) . "s";
                $stmt = $conn->prepare("UPDATE `$tbl` SET $set_clause WHERE `$primary_column` = ?");
                $stmt->bind_param($types, ...$values);
                $stmt->execute();
                $updated_count++;
            }
            echo "[OK] JSON Import: $tbl tablosunda $updated_count kayıt güncellendi.";
        }
    }

    // Yakalanan çıktıyı değişkene al ve buffer'ı temizle
    $terminalLog = ob_get_clean();
    $hasOutput = !empty($terminalLog);
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>CrmPlus Data Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Fira+Code:wght@400;500&family=Inter:wght@400;600&display=swap" rel="stylesheet">
    
    <style>
        body { background-color: #f0f2f5; font-family: 'Inter', sans-serif; color: #344767; }
        
        /* TERMINAL STİLİ */
        .terminal-window {
            background-color: #1e1e1e;
            color: #00ff00;
            font-family: 'Fira Code', monospace;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 25px;
            box-shadow: 0 10px 20px rgba(0,0,0,0.3);
            border: 1px solid #333;
            max-height: 300px;
            overflow-y: auto;
            position: relative;
        }
        .terminal-header {
            border-bottom: 1px solid #333;
            padding-bottom: 8px;
            margin-bottom: 10px;
            font-size: 12px;
            color: #888;
            display: flex;
            justify-content: space-between;
        }
        .terminal-dots span {
            display: inline-block; width: 10px; height: 10px; border-radius: 50%; margin-right: 5px;
        }
        .dot-red { background: #ff5f56; } .dot-yellow { background: #ffbd2e; } .dot-green { background: #27c93f; }
        .log-line { margin-bottom: 5px; font-size: 13px; line-height: 1.5; white-space: pre-wrap; }
        .prompt { color: #bd93f9; margin-right: 8px; }

        /* KART ve FORM STİLLERİ */
        .main-card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
            background: #fff;
            overflow: hidden;
        }
        .main-header {
            background: linear-gradient(90deg, #2c3e50, #34495e);
            color: #fff;
            padding: 15px 20px;
            font-weight: 600;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .form-section {
            border-bottom: 1px solid #eef2f6;
            padding: 20px;
            transition: background 0.2s;
        }
        .form-section:hover { background-color: #fcfdfe; }
        .form-section:last-child { border-bottom: none; }
        
        .section-title {
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #adb5bd;
            font-weight: 700;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }
        .section-title i { margin-right: 8px; color: #3498db; }
        
        .form-control, .form-select {
            border-radius: 6px;
            border: 1px solid #dee2e6;
            font-size: 0.9rem;
            padding: 0.5rem 0.75rem;
        }
        .form-control:focus { border-color: #3498db; box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.15); }
        
        .btn-action { width: 100%; font-weight: 500; border-radius: 6px; }
        
        /* Özel Renkler */
        .bg-transfer { border-left: 4px solid #3498db; }
        .bg-update { border-left: 4px solid #f39c12; }
        .bg-delete { border-left: 4px solid #e74c3c; background-color: #fff5f5; }
        .bg-json { border-left: 4px solid #9b59b6; }
        
        .input-group-text { background: #f8f9fa; color: #6c757d; border: 1px solid #dee2e6; }
    </style>
    
    <script type="text/javascript" src="//cdn.<?php echo $cdnurl?>/js/wpanel.js" lang="<?php echo $sdil[150];?>" id="wjs" url="<?php echo $_SERVER['SERVER_NAME'];?>" pow="<?php echo $pow1?>" ver="<?php echo $pow2?>"></script>
</head>
<body>

<div class="container py-4">

    <div class="terminal-window">
        <div class="terminal-header">
            <div class="terminal-dots">
                <span class="dot-red"></span><span class="dot-yellow"></span><span class="dot-green"></span>
            </div>
            <div>user@crmplus-server:~</div>
        </div>
        <div id="terminal-content">
            <?php if($hasOutput): ?>
                <div class="log-line"><span class="prompt">➜</span> <span class="text-white">Executing command...</span></div>
                <div class="log-line"><?php echo $terminalLog; ?></div>
                <div class="log-line text-muted">[<?php echo date("H:i:s"); ?>] Process finished.</div>
            <?php else: ?>
                <div class="log-line"><span class="prompt">➜</span> <span class="text-muted">System ready. Waiting for commands...</span></div>
            <?php endif; ?>
        </div>
    </div>

    <div class="main-card">
        <div class="main-header">
            <span><i class="fa-solid fa-database me-2"></i>Veri Yönetim Konsolu</span>
            <?php if($_GET["ne"]==""){ ?>
            <span class="badge bg-light text-dark shadow-sm">SQL Modu</span>
            <?php } ?>
        </div>

        <?php if($_GET["ne"]==""){ ?>
        
        <form action="?cmd=transfer" method="post" class="form-section bg-transfer">
            <div class="section-title"><i class="fa-solid fa-right-left"></i>Veri Transferi</div>
            <div class="row g-2 align-items-end">
                <div class="col-md-2 col-6">
                    <label class="small text-muted mb-1">Kaynak</label>
                    <input name="stn1" type="text" placeholder="t1" class="form-control">
                </div>
                <div class="col-md-2 col-6">
                    <label class="small text-muted mb-1">Hedef</label>
                    <input name="stn2" type="text" placeholder="t2" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="small text-muted mb-1">Tablo</label>
                    <select name="tbl" class="form-select">
                        <?php $result = mysqli_query($conn, "SHOW TABLES FROM $V3Db"); mysqli_data_seek($result,0); while ($row = mysqli_fetch_row($result)) {?>
                            <option value="<?php echo $row[0];?>"><?php echo $row[0];?></option>
                        <?php }?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="small text-muted mb-1">SQL Koşulu</label>
                    <input name="sql" type="text" placeholder="where ne='haber'" class="form-control">
                </div>
                <div class="col-md-2">
                    <button class="btn btn-primary btn-action" type="submit">Transfer</button>
                </div>
            </div>
        </form>

        <form action="?cmd=iupdate" method="post" class="form-section bg-json">
            <div class="section-title"><i class="fa-brands fa-js"></i>JSON Veri Güncelleme (n17)</div>
            <div class="row g-2 align-items-end">
                <div class="col-md-2 col-6">
                    <input name="key" type="text" placeholder="Key" class="form-control">
                </div>
                <div class="col-md-2 col-6">
                    <input name="val" type="text" placeholder="Value" class="form-control">
                </div>
                <div class="col-md-2">
                    <select name="tbl" class="form-select">
                        <?php $result = mysqli_query($conn, "SHOW TABLES FROM $V3Db"); mysqli_data_seek($result,0); while ($row = mysqli_fetch_row($result)) {?>
                            <option value="<?php echo $row[0];?>"><?php echo $row[0];?></option>
                        <?php }?>
                    </select>
                </div>
                <div class="col-md-4">
                    <input name="sql" type="text" placeholder="SQL Koşulu" class="form-control">
                </div>
                <div class="col-md-2">
                    <button class="btn btn-info text-white btn-action" type="submit">Json Upd</button>
                </div>
            </div>
        </form>

        <form action="?cmd=update" method="post" class="form-section bg-update">
            <div class="section-title"><i class="fa-solid fa-pen-to-square"></i>Tekil Veri Güncelleme</div>
            <div class="row g-2 align-items-end">
                <div class="col-md-2 col-6">
                    <input name="stn1" type="text" placeholder="Sütun" class="form-control">
                </div>
                <div class="col-md-2 col-6">
                    <input name="val1" type="text" placeholder="Yeni Değer" class="form-control">
                </div>
                <div class="col-md-2">
                    <select name="tbl" class="form-select">
                        <?php $result = mysqli_query($conn, "SHOW TABLES FROM $V3Db"); mysqli_data_seek($result,0); while ($row = mysqli_fetch_row($result)) {?>
                            <option value="<?php echo $row[0];?>"><?php echo $row[0];?></option>
                        <?php }?>
                    </select>
                </div>
                <div class="col-md-4">
                    <input name="sql" type="text" placeholder="SQL Koşulu" class="form-control">
                </div>
                <div class="col-md-2">
                    <button class="btn btn-warning text-white btn-action" type="submit">Güncelle</button>
                </div>
            </div>
        </form>

        <form action="?cmd=delete" method="post" class="form-section bg-delete" onsubmit="return confirm('Bu veriler kalıcı olarak silinecek! Onaylıyor musunuz?');">
            <div class="section-title text-danger"><i class="fa-solid fa-trash-can text-danger"></i>Veri Silme</div>
            <div class="row g-2 align-items-end">
                <div class="col-md-4">
                    <select name="tbl" class="form-select">
                        <?php $result = mysqli_query($conn, "SHOW TABLES FROM $V3Db"); mysqli_data_seek($result,0); while ($row = mysqli_fetch_row($result)) {?>
                            <option value="<?php echo $row[0];?>"><?php echo $row[0];?></option>
                        <?php }?>
                    </select>
                </div>
                <div class="col-md-4" style="<?php if($MSA==""){echo "display:none;";}?>">
                    <input name="sql" list="up_sql" type="text" placeholder="SQL Koşulu (Zorunlu)" class="form-control">
                    <datalist id="up_sql">
                        <option value="where ne='kayit'"></option>
                        <option value="where ne='haber'"></option>
                        <option value="where ne='fmesaj'"></option>
                    </datalist>
                </div>
                <div class="col-md-2">
                    <div class="form-check pt-2">
                        <input class="form-check-input" type="checkbox" name="clear_media" value="1" id="clearMedia">
                        <label class="form-check-label small" for="clearMedia">Medyayı Sil</label>
                    </div>
                </div>
                <div class="col-md-2">
                    <button class="btn btn-danger btn-action" type="submit">SİL</button>
                </div>
            </div>
        </form>

        <form action="?cmd=json_export" method="post" class="form-section">
            <div class="section-title"><i class="fa-solid fa-file-export"></i>JSON Export</div>
            <div class="row g-2 align-items-end">
                <div class="col-md-4">
                    <input name="keys" type="text" placeholder="Sütunlar (id,t1,n1...)" class="form-control">
                </div>
                <div class="col-md-2">
                    <select name="tbl" class="form-select">
                        <?php $result = mysqli_query($conn, "SHOW TABLES FROM $V3Db"); mysqli_data_seek($result,0); while ($row = mysqli_fetch_row($result)) {?>
                            <option value="<?php echo $row[0];?>"><?php echo $row[0];?></option>
                        <?php }?>
                    </select>
                </div>
                <div class="col-md-2" style="<?php if($MSA==""){echo "display:none;";}?>">
                     <input name="sql" list="jsonex_sql" type="text" placeholder="Koşul" class="form-control">
                     <datalist id="jsonex_sql">
                        <option value="where ne='kayit'"></option>
                        <option value="where ne='sayfa'"></option>
                    </datalist>
                </div>
                <div class="col-md-2" style="<?php if($MSA==""){echo "display:none;";}?>">
                    <input name="sql_limit" type="text" placeholder="Limit" class="form-control">
                </div>
                <div class="col-md-2">
                    <button class="btn btn-dark btn-action" type="submit">Export</button>
                </div>
            </div>
        </form>

        <form action="?cmd=json_import" method="post" class="form-section">
            <div class="section-title"><i class="fa-solid fa-file-import"></i>JSON Import</div>
            <div class="row g-2">
                <div class="col-md-10">
                    <textarea name="json" rows="2" class="form-control font-monospace" placeholder='{"tbl":"...", "results": [...]} veri yapıştır'></textarea>
                </div>
                <div class="col-md-2">
                    <button class="btn btn-success btn-action h-100" type="submit">Import</button>
                </div>
            </div>
        </form>

        <?php } ?>

        <form action="?cmd=kampanya" method="post" class="form-section">
            <div class="section-title"><i class="fa-solid fa-tags"></i>Fiyat & Kampanya</div>
            <div class="row g-2 align-items-end">
                <div class="col-md-2 col-6">
                    <input name="val1" id="valc1" type="text" placeholder="Oran" class="form-control">
                </div>
                <div class="col-md-2 col-6">
                    <select name="sts" id="sts" class="form-select">
                        <option value="pu">Artış %</option>
                        <option value="pd">İndirim %</option>
                        <option value="mu">Artış <?php echo $kpb?></option>
                        <option value="md">İndirim <?php echo $kpb?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="cat" class="form-select">
                        <option value="0">Tüm Kat.</option>
                        <?php $sqlx=mysqli_query($conn, "select * from kategoriler where ne='ukategori' and s2=1 order by sira asc"); while($rsx=mysqli_fetch_assoc($sqlx)){?>
                            <option value="<?php echo $rsx["Cat_ID"];?>">+ <?php echo $rsx["Cat_".$_SESSION['lang'].""];?></option>
                            <?php $sqly=mysqli_query($conn, "select * from kategoriler where ne='ualt_kategori' and c1=".$rsx["Cat_ID"]." order by sira asc"); while($rsy=mysqli_fetch_assoc($sqly)){?>
                                <option value="<?php echo $rsy["Cat_ID"];?>">&nbsp;- <?php echo $rsy["Cat_".$_SESSION['lang'].""];?></option>
                            <?php }}?>
                    </select>
                </div>
                <div class="col-md-4" style="<?php if($MSA<>1){echo "display:none;";}?>">
                    <input name="sql" type="text" value="where ne='kayit'" class="form-control">
                </div>
                <div class="col-md-2">
                    <button class="btn btn-primary btn-action" type="submit">Uygula</button>
                </div>
            </div>
        </form>

        <form action="?cmd=towebp" method="post" class="form-section" style="<?php if($MSA != 1 && $module["webp"] != 1){echo "display:none;";} ?>">
            <div class="section-title"><i class="fa-solid fa-image"></i>WebP Dönüştürücü</div>
            <div class="row g-2 align-items-center">
                <div class="col-md-8">
                     <div class="input-group">
                        <span class="input-group-text">Medya Tablosu</span>
                        <input name="sql" list="towebp_sql" type="text" value="where ne='resim'" class="form-control">
                     </div>
                </div>
                <div class="col-md-4">
                    <button class="btn btn-secondary btn-action" type="submit">WebP Çevir</button>
                </div>
                <?php
                    $towp = 0; 
                    // SQL hatası vermemesi için basit kontrol
                    if(isset($conn)){
                        $sqlm = mysqli_query($conn, "SELECT count(id) as sayi FROM medya where ne='resim' and t1 NOT LIKE '%.webp'"); 
                        $rsm = mysqli_fetch_assoc($sqlm);
                        $towp = $rsm['sayi'];
                    }
                ?>
                <div class="col-12 mt-2">
                    <small class="text-muted"><i class="fa fa-info-circle"></i> Dönüştürülmeyi bekleyen: <b><?php echo $towp?></b> görsel.</small>
                </div>
            </div>
        </form>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    jQuery(function() {
        // Kampanya placeholder değişimi
        jQuery('#sts').change(function(){
            var val = jQuery('option:selected', this).val();
            var ph = "Oran";
            if(val=='pu') ph = 'Artış %';
            else if(val=='pd') ph = 'İndirim %';
            else if(val=='mu') ph = 'Artış <?php echo $kpb?>';
            else if(val=='md') ph = 'İndirim <?php echo $kpb?>';
            jQuery('#valc1').attr('placeholder', ph);
        });

        // Terminalden metin kopyalama (Çift tıklama ile)
        jQuery('.log-line').dblclick(function(){
            var text = jQuery(this).text();
            navigator.clipboard.writeText(text);
            // İsteğe bağlı görsel bildirim eklenebilir
        });
    });
</script>

</body>
</html>