<?php
$dbhost = $V3Server;
$dbuser = $V3User;
$dbpass = $V3Pass;
$dbname = $V3Db;
$tables = '*';
backup_tables($dbhost, $dbuser, $dbpass, $dbname, $tables);
function backup_tables($host, $user, $pass, $dbname, $tables = '*') {
    $link = mysqli_connect($host, $user, $pass, $dbname);
    if (mysqli_connect_errno()) {
        die("MySQL balants baarsz: " . mysqli_connect_error());
    }
    mysqli_query($link, "SET NAMES 'utf8'");
    // Tablolar belirle
    if ($tables == '*') {
        $tables = [];
        $result = mysqli_query($link, 'SHOW TABLES');
        while ($row = mysqli_fetch_row($result)) {
            $tables[] = $row[0];
        }
    } else {
        $tables = is_array($tables) ? $tables : explode(',', $tables);
    }
    $return = '';
    // Her tabloyu ileyelim
    foreach ($tables as $table) {
        $result = mysqli_query($link, "SELECT * FROM `$table`");
        $num_fields = mysqli_num_fields($result);
        // Tabloyu silme ve yeniden oluturma SQL komutlar
        $row2 = mysqli_fetch_row(mysqli_query($link, "SHOW CREATE TABLE `$table`"));
        $return .= "DROP TABLE IF EXISTS `$table`;\n";
        $return .= $row2[1] . ";\n\n";
        // Tablo ierii
        while ($row = mysqli_fetch_row($result)) {
            $return .= "INSERT INTO `$table` VALUES(";
            for ($j = 0; $j < $num_fields; $j++) {
                $row[$j] = isset($row[$j]) ? mysqli_real_escape_string($link, $row[$j]) : "NULL";
                $return .= '"' . $row[$j] . '"';
                if ($j < ($num_fields - 1)) $return .= ', ';
            }
            $return .= ");\n";
        }
        $return .= "\n\n";
    }
    // Dosyay kaydet
    $fileName = $dbname . '_backup_' . date("dmY") . '.sql';
    $filePath = '../../../deppo/backup/' . $fileName;
    if (!is_dir('../../../deppo/backup/')) {
        mkdir('../../../deppo/backup/', 0777, true); // Klasr olutur
    }
    if (file_put_contents($filePath, $return)) {
        echo "Yedekleme baarl: $filePath";
    } else {
        echo "Dosya yazma ilemi baarsz.";
    }
    mysqli_close($link);
}
?>