<?php
require_once 'Google_Client.php';
require_once 'Google_AnalyticsService.php';
// Google Client setup
$client = new Google_Client();
$client->setApplicationName('Google Analytics API PHP');
$client->setAuthConfig('credentials.json');
$client->setScopes(['https://www.googleapis.com/auth/analytics.readonly']);
// Google Analytics API client' oluturun
$analytics = new Google_AnalyticsService($client);
// View ID'yi belirtin
$VIEW_ID = '310519023';
// Gnlk Ziyaret Verilerini Al
function getDailyVisits($analytics, $VIEW_ID) {
    $results = $analytics->data_ga->get(
        'ga:' . $VIEW_ID,
        '7daysAgo', 'today',
        'ga:sessions'
    );
    return $results->getRows();
}
// Haftalk Ziyaret Verilerini Al
function getWeeklyVisits($analytics, $VIEW_ID) {
    $results = $analytics->data_ga->get(
        'ga:' . $VIEW_ID,
        '30daysAgo', 'today',
        'ga:sessions',
        ['dimensions' => 'ga:week']
    );
    return $results->getRows();
}
// Aylk Ziyaret Verilerini Al
function getMonthlyVisits($analytics, $VIEW_ID) {
    $results = $analytics->data_ga->get(
        'ga:' . $VIEW_ID,
        '90daysAgo', 'today',
        'ga:sessions',
        ['dimensions' => 'ga:month']
    );
    return $results->getRows();
}
// Trafik Kaynaklarn Al
function getTrafficSources($analytics, $VIEW_ID) {
    $results = $analytics->data_ga->get(
        'ga:' . $VIEW_ID,
        '30daysAgo', 'today',
        'ga:sessions',
        ['dimensions' => 'ga:source']
    );
    return $results->getRows();
}
$dailyVisits = getDailyVisits($analytics, $VIEW_ID);
$weeklyVisits = getWeeklyVisits($analytics, $VIEW_ID);
$monthlyVisits = getMonthlyVisits($analytics, $VIEW_ID);
$trafficSources = getTrafficSources($analytics, $VIEW_ID);
// Google Charts iin verileri dzenleyin
$dailyData = [['Date', 'Visits']];
foreach ($dailyVisits as $row) {
    $dailyData[] = [$row[0], (int)$row[1]];
}
$weeklyData = [['Week', 'Visits']];
foreach ($weeklyVisits as $row) {
    $weeklyData[] = [$row[0], (int)$row[1]];
}
$monthlyData = [['Month', 'Visits']];
foreach ($monthlyVisits as $row) {
    $monthlyData[] = [$row[0], (int)$row[1]];
}
$trafficSourcesData = [['Source', 'Visits']];
foreach ($trafficSources as $row) {
    $trafficSourcesData[] = [$row[0], (int)$row[1]];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Google Analytics Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <style>
        body {
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row mb-4">
            <div class="col-md-4">
                <div id="daily_chart" style="height: 300px;"></div>
            </div>
            <div class="col-md-4">
                <div id="weekly_chart" style="height: 300px;"></div>
            </div>
            <div class="col-md-4">
                <div id="monthly_chart" style="height: 300px;"></div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div id="traffic_sources_chart" style="height: 400px;"></div>
            </div>
        </div>
    </div>
    <script>
        google.charts.load('current', {'packages':['corechart']});
        google.charts.setOnLoadCallback(drawCharts);
        function drawCharts() {
            drawDailyChart(<?php echo json_encode($dailyData); ?>);
            drawWeeklyChart(<?php echo json_encode($weeklyData); ?>);
            drawMonthlyChart(<?php echo json_encode($monthlyData); ?>);
            drawTrafficSourcesChart(<?php echo json_encode($trafficSourcesData); ?>);
        }
        function drawDailyChart(data) {
            const chartData = google.visualization.arrayToDataTable(data);
            const options = {
                title: 'Daily Visits',
                legend: { position: 'bottom' },
            };
            const chart = new google.visualization.LineChart(document.getElementById('daily_chart'));
            chart.draw(chartData, options);
        }
        function drawWeeklyChart(data) {
            const chartData = google.visualization.arrayToDataTable(data);
            const options = {
                title: 'Weekly Visits',
                legend: { position: 'bottom' },
            };
            const chart = new google.visualization.ColumnChart(document.getElementById('weekly_chart'));
            chart.draw(chartData, options);
        }
        function drawMonthlyChart(data) {
            const chartData = google.visualization.arrayToDataTable(data);
            const options = {
                title: 'Monthly Visits',
                legend: { position: 'bottom' },
            };
            const chart = new google.visualization.BarChart(document.getElementById('monthly_chart'));
            chart.draw(chartData, options);
        }
        function drawTrafficSourcesChart(data) {
            const chartData = google.visualization.arrayToDataTable(data);
            const options = {
                title: 'Traffic Sources',
                pieHole: 0.4,
            };
            const chart = new google.visualization.PieChart(document.getElementById('traffic_sources_chart'));
            chart.draw(chartData, options);
        }
    </script>
</body>
</html>