﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
    xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"
    xmlns:ccts="urn:un:unece:uncefact:documentation:2"
    xmlns:clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001"
    xmlns:clm5639="urn:un:unece:uncefact:codelist:specification:5639:1988"
    xmlns:clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001"
    xmlns:clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003"
    xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:link="http://www.xbrl.org/2003/linkbase"
    xmlns:n1="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2"
    xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2"
    xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2"
    xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance"
    xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:lcl="http://www.efatura.gov.tr/local"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    exclude-result-prefixes="cac cbc ccts clm54217 clm5639 clm66411 clmIANAMIMEMediaType fn link n1 qdt udt xbrldi xbrli xdt xlink xs xsd xsi lcl">
    <xsl:character-map name="a">
        <xsl:output-character character="&#38;" string="&amp;" />
        <xsl:output-character character="&#34;" string="&quot;" />
        <xsl:output-character character="&#60;" string="&lt;" />
        <xsl:output-character character="&#62;" string="&gt;"/>
        <xsl:output-character character="&#39;" string="&apos;"/>
        <xsl:output-character character="&#128;" string=""/>
        <xsl:output-character character="&#129;" string=""/>
        <xsl:output-character character="&#130;" string=""/>
        <xsl:output-character character="&#131;" string=""/>
        <xsl:output-character character="&#132;" string=""/>
        <xsl:output-character character="&#133;" string=""/>
        <xsl:output-character character="&#134;" string=""/>
        <xsl:output-character character="&#135;" string=""/>
        <xsl:output-character character="&#136;" string=""/>
        <xsl:output-character character="&#137;" string=""/>
        <xsl:output-character character="&#138;" string=""/>
        <xsl:output-character character="&#139;" string=""/>
        <xsl:output-character character="&#140;" string=""/>
        <xsl:output-character character="&#141;" string=""/>
        <xsl:output-character character="&#142;" string=""/>
        <xsl:output-character character="&#143;" string=""/>
        <xsl:output-character character="&#144;" string=""/>
        <xsl:output-character character="&#145;" string=""/>
        <xsl:output-character character="&#146;" string=""/>
        <xsl:output-character character="&#147;" string=""/>
        <xsl:output-character character="&#148;" string=""/>
        <xsl:output-character character="&#149;" string=""/>
        <xsl:output-character character="&#150;" string=""/>
        <xsl:output-character character="&#151;" string=""/>
        <xsl:output-character character="&#152;" string=""/>
        <xsl:output-character character="&#153;" string=""/>
        <xsl:output-character character="&#154;" string=""/>
        <xsl:output-character character="&#155;" string=""/>
        <xsl:output-character character="&#156;" string=""/>
        <xsl:output-character character="&#157;" string=""/>
        <xsl:output-character character="&#158;" string=""/>
        <xsl:output-character character="&#159;" string=""/>
    </xsl:character-map>
    <xsl:decimal-format name="european" decimal-separator="," grouping-separator="." NaN="" />
    <xsl:output version="4.0" method="html" indent="yes" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd" use-character-maps="a"/>
    <xsl:param name="SV_OutputFormat" select="'HTML'" />
    <xsl:variable name="XML" select="/" />
    <xsl:variable name="iskontoCount" select = "count(n1:Invoice/cac:InvoiceLine/cac:AllowanceCharge)" />
    <xsl:variable name="irsaliyeCount" select = "count(n1:Invoice/cac:DespatchDocumentReference)" />
    <xsl:variable name="iadeCount" select = "count(n1:Invoice/cac:BillingReference)" />
    <xsl:variable name="earchiveCheckCount" select = "count(n1:Invoice/cac:AdditionalDocumentReference[cbc:DocumentTypeCode = 'SendingType'])" />
    <xsl:template match="/">
        <html>
            <head>
                <title />
                <style type="text/css">
                    body {
                        background-color: #FFFFFF;
                        font-family: 'Tahoma', "Times New Roman", Times, serif;
                        font-size: 11px;
                        color: #666666;
                    }
                    h1, h2 {
                        padding-bottom: 3px;
                        padding-top: 3px;
                        margin-bottom: 5px;
                        text-transform: uppercase;
                        font-family: Arial, Helvetica, sans-serif;
                    }
                    h1 {
                        font-size: 1.4em;
                        text-transform:none;
                    }
                    h2 {
                        font-size: 1em;
                        color: brown;
                    }
                    h3 {
                        font-size: 1em;
                        color: #333333;
                        text-align: justify;
                        margin: 0;
                        padding: 0;
                    }
                    h4 {
                        font-size: 1.1em;
                        font-style: bold;
                        font-family: Arial, Helvetica, sans-serif;
                        color: #000000;
                        margin: 0;
                        padding: 0;
                    }
                    hr {
                        height:2px;
                        color: #000000;
                        background-color: #000000;
                        border-bottom: 1px solid #000000;
                    }
                    p, ul, ol {
                        margin-top: 1.5em;
                    }
                    ul, ol {
                        margin-left: 3em;
                    }
                    blockquote {
                        margin-left: 3em;
                        margin-right: 3em;
                        font-style: italic;
                    }
                    a {
                        text-decoration: none;
                        color: #70A300;
                    }
                    a:hover {
                        border: none;
                        color: #70A300;
                    }
                    #despatchTable {
                        border-collapse:collapse;
                        font-size:11px;
                        float:right;
                        border-color:gray;
                    }
                    #ettnTable {
                        border-collapse:collapse;
                        font-size:11px;
                        border-color:gray;
                    }
                    #customerPartyTable {
                        border-width: 0px;
                        border-spacing:;
                        border-style: inset;
                        border-color: gray;
                        border-collapse: collapse;
                        background-color:
                    }
                    #customerIDTable {
                        border-width: 2px;
                        border-spacing:;
                        border-style: inset;
                        border-color: gray;
                        border-collapse: collapse;
                        background-color:
                    }
                    #customerIDTableTd {
                        border-width: 2px;
                        border-spacing:;
                        border-style: inset;
                        border-color: gray;
                        border-collapse: collapse;
                        background-color:
                    }
                    #lineTable {
                        border-width:2px;
                        border-spacing:;
                        border-style: inset;
                        border-color: black;
                        border-collapse: collapse;
                        background-color:;
                    }
                    #lineTableTd {
                        border-width: 1px;
                        padding: 1px;
                        border-style: inset;
                        border-color: black;
                        background-color: white;
                    }
                    #lineTableTr {
                        border-width: 1px;
                        padding: 0px;
                        border-style: inset;
                        border-color: black;
                        background-color: white;
                        -moz-border-radius:;
                    }
                    #lineTableDummyTd {
                        border-width: 1px;
                        border-color:white;
                        padding: 1px;
                        border-style: inset;
                        border-color: black;
                        background-color: white;
                    }
                    #lineTableBudgetTd {
                        border-width: 2px;
                        border-spacing:0px;
                        padding: 1px;
                        border-style: inset;
                        border-color: black;
                        background-color: white;
                        -moz-border-radius:;
                    }
                    #notesTable {
                        border-width: 2px;
                        border-spacing:;
                        border-style: inset;
                        border-color: black;
                        border-collapse: collapse;
                        background-color:
                    }
                    #notesTableTd {
                        border-width: 0px;
                        border-spacing:;
                        border-style: inset;
                        border-color: black;
                        border-collapse: collapse;
                        background-color:
                    }
                    table {
                        border-spacing:0px;
                    }
                    #budgetContainerTable {
                        border-width: 0px;
                        border-spacing: 0px;
                        border-style: inset;
                        border-color: black;
                        border-collapse: collapse;
                        background-color:;
                    }
                    td {
                        border-color:gray;
                    }</style>
                <title>E-Fatura</title>
            </head>
            <body style="margin-left=0.6in; margin-right=0.6in; margin-top=0.79in; margin-bottom=0.79in">
                <xsl:for-each select="$XML">
                    <table border="0" cellspacing="0px" width="800" cellpadding="0px">
                        <tr width="900" height="180" border="0">
                            <td >



                                <table align="center" border="0" width="100%">
                                    <tbody>
                                        <hr />
                                        <tr align="left">
                                            <xsl:for-each select="n1:Invoice">
                                                <xsl:for-each select="cac:AccountingSupplierParty">
                                                    <xsl:for-each select="cac:Party">
                                                        <td align="left">
                                                            <xsl:if test="cac:PartyName">
                                                                <xsl:value-of select="cac:PartyName/cbc:Name" />
                                                                <br />
                                                            </xsl:if>
                                                            <xsl:for-each select="cac:Person">
                                                                <xsl:for-each select="cbc:Title">
                                                                    <xsl:apply-templates />
                                                                    <span>
                                                                        <xsl:text>&#160;</xsl:text>
                                                                    </span>
                                                                </xsl:for-each>
                                                                <xsl:for-each select="cbc:FirstName">
                                                                    <xsl:apply-templates />
                                                                    <span>
                                                                        <xsl:text>&#160;</xsl:text>
                                                                    </span>
                                                                </xsl:for-each>
                                                                <xsl:for-each select="cbc:MiddleName">
                                                                    <xsl:apply-templates />
                                                                    <span>
                                                                        <xsl:text>&#160;</xsl:text>
                                                                    </span>
                                                                </xsl:for-each>
                                                                <xsl:for-each select="cbc:FamilyName">
                                                                    <xsl:apply-templates />
                                                                    <span>
                                                                        <xsl:text>&#160;</xsl:text>
                                                                    </span>
                                                                </xsl:for-each>
                                                                <xsl:for-each select="cbc:NameSuffix">
                                                                    <xsl:apply-templates />
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </td>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </tr>
                                        <tr align="left">
                                            <xsl:for-each select="n1:Invoice">
                                                <xsl:for-each select="cac:AccountingSupplierParty">
                                                    <xsl:for-each select="cac:Party">
                                                        <td align="left">
                                                            <xsl:for-each select="cac:PostalAddress">
                                                                <xsl:for-each select="cbc:StreetName">
                                                                    <xsl:if test="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:StreetName!=''">
                                                                        <xsl:apply-templates />
                                                                        <span>
                                                                            <xsl:text>&#160;</xsl:text>
                                                                        </span>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                                <xsl:for-each select="cbc:BuildingName">
                                                                    <xsl:apply-templates />
                                                                </xsl:for-each>
                                                                <xsl:if test="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:BuildingNumber!=''">
                                                                    <span>
                                                                        <xsl:text>No:</xsl:text>
                                                                    </span>
                                                                    <xsl:for-each select="cbc:BuildingNumber">
                                                                        <xsl:apply-templates />
                                                                    </xsl:for-each>
                                                                    <span>
                                                                        <xsl:text>&#160;</xsl:text>
                                                                    </span>
                                                                </xsl:if>
                                                                <br />
                                                                <xsl:for-each select="cbc:PostalZone">
                                                                    <xsl:apply-templates />
                                                                    <span>
                                                                        <xsl:text>&#160;</xsl:text>
                                                                    </span>
                                                                </xsl:for-each>
                                                                <xsl:for-each select="cbc:CitySubdivisionName">
                                                                    <xsl:if test="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:CitySubdivisionName!=''">
                                                                        <xsl:apply-templates />
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                                <span>
                                                                    <xsl:text>/ </xsl:text>
                                                                </span>
                                                                <xsl:for-each select="cbc:CityName">
                                                                    <xsl:if test="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:CityName!=''">
                                                                        <xsl:apply-templates />
                                                                        <span>
                                                                            <xsl:text>&#160;</xsl:text>
                                                                        </span>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </td>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </tr>
                                        <xsl:if test="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telephone or //n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telefax">
                                            <tr align="left">
                                                <xsl:for-each select="n1:Invoice">
                                                    <xsl:for-each select="cac:AccountingSupplierParty">
                                                        <xsl:for-each select="cac:Party">
                                                            <td align="left">
                                                                <xsl:for-each select="cac:Contact">
                                                                    <xsl:if test="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telephone!=''">
                                                                        <span>
                                                                            <xsl:text>Tel: </xsl:text>
                                                                        </span>
                                                                        <xsl:for-each select="cbc:Telephone">
                                                                            <xsl:apply-templates />
                                                                        </xsl:for-each>
                                                                    </xsl:if>
                                                                    <xsl:if test="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:Telefax!=''">
                                                                        <span>
                                                                            <xsl:text> Fax: </xsl:text>
                                                                        </span>
                                                                        <xsl:for-each select="cbc:Telefax">
                                                                            <xsl:apply-templates />
                                                                        </xsl:for-each>
                                                                    </xsl:if>
                                                                    <span>
                                                                        <xsl:text>&#160;</xsl:text>
                                                                    </span>
                                                                </xsl:for-each>
                                                            </td>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </tr>
                                        </xsl:if>
                                        <xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cbc:WebsiteURI">
                                            <xsl:if test="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cbc:WebsiteURI!=''">
                                                <tr align="left">
                                                    <td>
                                                        <xsl:text>Web Sitesi: </xsl:text>
                                                        <xsl:value-of select="." />
                                                    </td>
                                                </tr>
                                            </xsl:if>
                                        </xsl:for-each>
                                        <xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:ElectronicMail">
                                            <xsl:if test="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:ElectronicMail!=''">
                                                <tr align="left">
                                                    <td>
                                                        <xsl:text>E-Posta: </xsl:text>
                                                        <xsl:value-of select="." />
                                                    </td>
                                                </tr>
                                            </xsl:if>
                                        </xsl:for-each>
                                        <tr align="left">
                                            <xsl:for-each select="n1:Invoice">
                                                <xsl:for-each select="cac:AccountingSupplierParty">
                                                    <xsl:for-each select="cac:Party">
                                                        <td align="left">
                                                            <span>
                                                                <xsl:text>Vergi Dairesi: </xsl:text>
                                                            </span>
                                                            <xsl:for-each select="cac:PartyTaxScheme">
                                                                <xsl:for-each select="cac:TaxScheme">
                                                                    <xsl:for-each select="cbc:Name">
                                                                        <xsl:apply-templates />
                                                                    </xsl:for-each>
                                                                </xsl:for-each>
                                                                <span>
                                                                    <xsl:text>&#160; </xsl:text>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </tr>
                                        <xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification">
                                            <tr align="left">
                                                <td>
                                                    <xsl:value-of select="cbc:ID/@schemeID" />
                                                    <xsl:text>: </xsl:text>
                                                    <xsl:value-of select="cbc:ID" />
                                                </td>
                                            </tr>
                                        </xsl:for-each>
                                    </tbody>54
                                </table>
                                <hr />


                            </td>

                            <td width="25%" align="center" valign="middle">


                                <img style="width:91px;" align="middle" alt="Gib Logo" src="data:image/jpeg;base64,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" />


                                <h1 align="center">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>E-Fatura</xsl:text>
                                    </span>
                                </h1>


                                <div class="imgBox" valign="middle" >
                                    <img style="width:150px; position:absolute; margin-left:-50px;" src="data:image/png;base64,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"/>
                                </div>

                            </td>
                            <td width="300" align="center" valign="middle">
                                <img style="width:220px;" align="right" alt="Company Logo" src="data:image/png;base64,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"/><br/>
                            </td>


                        </tr>
                        <tr width="900" height="180" border="1">
                            <td width="300">

                                <table id="customerPartyTable" align="left" border="0" height="50%">
                                    <tbody>
                                        <tr style="height:71px; ">
                                            <td>
                                                <hr />
                                                <table align="center" border="0">
                                                    <tbody>
                                                        <tr>
                                                            <xsl:for-each select="n1:Invoice/cac:AccountingCustomerParty/cac:Party">
                                                                <td style="width:469px; " align="left">
                                                                    <span style="font-weight:bold; ">
                                                                        <xsl:text>SAYIN</xsl:text>
                                                                    </span>
                                                                </td>
                                                            </xsl:for-each>
                                                        </tr>
                                                        <tr>
                                                            <xsl:choose>
                                                                <xsl:when test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='TAXFREE']">
                                                                    <xsl:for-each select="n1:Invoice/cac:BuyerCustomerParty/cac:Party">
                                                                        <xsl:call-template name="Party_Title">
                                                                            <xsl:with-param name="PartyType">TAXFREE</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </xsl:for-each>
                                                                </xsl:when>
                                                                <xsl:when test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='EXPORT']">
                                                                    <xsl:for-each select="n1:Invoice/cac:BuyerCustomerParty/cac:Party">
                                                                        <xsl:call-template name="Party_Title">
                                                                            <xsl:with-param name="PartyType">EXPORT</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </xsl:for-each>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <xsl:for-each select="n1:Invoice/cac:AccountingCustomerParty/cac:Party">
                                                                        <xsl:call-template name="Party_Title">
                                                                            <xsl:with-param name="PartyType">OTHER</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </xsl:for-each>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </tr>
                                                        <xsl:choose>
                                                            <xsl:when test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='TAXFREE']">
                                                                <xsl:for-each select="n1:Invoice/cac:BuyerCustomerParty/cac:Party">
                                                                    <tr>
                                                                        <xsl:call-template name="Party_Adress">
                                                                            <xsl:with-param name="PartyType">TAXFREE</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </tr>
                                                                    <xsl:call-template name="Party_Other">
                                                                        <xsl:with-param name="PartyType">TAXFREE</xsl:with-param>
                                                                    </xsl:call-template>
                                                                </xsl:for-each>
                                                            </xsl:when>
                                                            <xsl:when test="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='EXPORT']">
                                                                <xsl:for-each select="n1:Invoice/cac:BuyerCustomerParty/cac:Party">
                                                                    <tr>
                                                                        <xsl:call-template name="Party_Adress">
                                                                            <xsl:with-param name="PartyType">EXPORT</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </tr>
                                                                    <xsl:call-template name="Party_Other">
                                                                        <xsl:with-param name="PartyType">EXPORT</xsl:with-param>
                                                                    </xsl:call-template>
                                                                </xsl:for-each>
                                                            </xsl:when>
                                                            <xsl:otherwise>
                                                                <xsl:for-each select="n1:Invoice/cac:AccountingCustomerParty/cac:Party">
                                                                    <tr>
                                                                        <xsl:call-template name="Party_Adress">
                                                                            <xsl:with-param name="PartyType">OTHER</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </tr>
                                                                    <xsl:call-template name="Party_Other">
                                                                        <xsl:with-param name="PartyType">OTHER</xsl:with-param>
                                                                    </xsl:call-template>
                                                                </xsl:for-each>
                                                            </xsl:otherwise>
                                                        </xsl:choose>
                                                    </tbody>
                                                </table>
                                                <hr />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>




                            </td>

                            <td width="25%" align="center" valign="middle">

                            </td>
                            <td width="300">

                                <table border="1" height="13" id="despatchTable">
                                    <tbody>
                                        <tr>
                                            <td style="width:105px;" align="left">
                                                <span style="font-weight:bold; ">
                                                    <xsl:text>Özelleştirme No:</xsl:text>
                                                </span>
                                            </td>
                                            <td style="width:110px;" align="left">
                                                <xsl:for-each select="n1:Invoice">
                                                    <xsl:for-each select="cbc:CustomizationID">
                                                        <xsl:apply-templates />
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </td>
                                        </tr>
                                        <tr style="height:13px; ">
                                            <td align="left">
                                                <span style="font-weight:bold; ">
                                                    <xsl:text>Senaryo:</xsl:text>
                                                </span>
                                            </td>
                                            <td align="left">
                                                <xsl:for-each select="n1:Invoice">
                                                    <xsl:for-each select="cbc:ProfileID">
                                                        <xsl:apply-templates />
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </td>
                                        </tr>
                                        <tr style="height:13px; ">
                                            <td align="left">
                                                <span style="font-weight:bold; ">
                                                    <xsl:text>Fatura Tipi:</xsl:text>
                                                </span>
                                            </td>
                                            <td align="left">
                                                <xsl:for-each select="n1:Invoice">
                                                    <xsl:for-each select="cbc:InvoiceTypeCode">
                                                        <xsl:apply-templates />
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </td>
                                        </tr>
                                        <tr style="height:13px; ">
                                            <td align="left">
                                                <span style="font-weight:bold; ">
                                                    <xsl:text>Fatura No:</xsl:text>
                                                </span>
                                            </td>
                                            <td align="left">
                                                <xsl:for-each select="n1:Invoice">
                                                    <xsl:for-each select="cbc:ID">
                                                        <xsl:apply-templates />
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </td>
                                        </tr>



                                        <tr style="height:13px; ">
                                            <td align="left">
                                                <span style="font-weight:bold; ">
                                                    <xsl:if test="$earchiveCheckCount &gt; 0">
                                                Düzenleme Tarihi:
                                                    </xsl:if>
                                                    <xsl:if test="$earchiveCheckCount = 0">
                                                Fatura Tarihi:
                                                    </xsl:if>

                                                </span>
                                            </td>
                                            <td align="left">
                                                <xsl:for-each select="n1:Invoice">
                                                    <xsl:for-each select="cbc:IssueDate">
                                                        <xsl:value-of select="substring(.,9,2)"
                                                />-<xsl:value-of select="substring(.,6,2)"
                                                />-<xsl:value-of select="substring(.,1,4)"/>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </td>
                                        </tr>


                                        <xsl:if test="//n1:Invoice/cac:AdditionalDocumentReference/cbc:DocumentType = 'KAGIT' and  //n1:Invoice/cac:AdditionalDocumentReference/cbc:DocumentTypeCode = 'SendingType'">

                                            <tr style="height:13px; ">
                                                <td align="left">

                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>Düzenleme Zamanı:</xsl:text>
                                                    </span>


                                                </td>
                                                <td align="left">

                                                    <xsl:for-each select="n1:Invoice">
                                                        <xsl:for-each select="cbc:IssueTime">
                                                            <xsl:value-of select="substring(.,1,2)" />:<xsl:value-of select="substring(.,4,2)" />:<xsl:value-of select="substring(.,7,2)" />
                                                        </xsl:for-each>
                                                    </xsl:for-each>

                                                </td>


                                            </tr>

                                        </xsl:if>
                                        <xsl:if test="//n1:Invoice/cac:AdditionalDocumentReference/cbc:DocumentType = 'ELEKTRONIK' and  //n1:Invoice/cac:AdditionalDocumentReference/cbc:DocumentTypeCode = 'SendingType'">

                                            <tr style="height:13px; ">
                                                <td align="left">

                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>Düzenleme Zamanı:</xsl:text>
                                                    </span>


                                                </td>
                                                <td align="left">

                                                    <xsl:for-each select="n1:Invoice">
                                                        <xsl:for-each select="cbc:IssueTime">
                                                            <xsl:value-of select="substring(.,1,2)" />:<xsl:value-of select="substring(.,4,2)" />:<xsl:value-of select="substring(.,7,2)" />
                                                        </xsl:for-each>
                                                    </xsl:for-each>

                                                </td>


                                            </tr>






                                        </xsl:if>
                                        <xsl:for-each select="n1:Invoice/cac:DespatchDocumentReference[position() &lt;2]">

                                            <tr style="height:13px; ">
                                                <td align="left">
                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>İrsaliye No-Tarih:</xsl:text>
                                                    </span>
                                                    <span>
                                                        <xsl:text>&#160;</xsl:text>

                                                        <xsl:if test="$irsaliyeCount &gt; 1">
                                                            <xsl:text>(</xsl:text>
                                                            <xsl:value-of select="$irsaliyeCount" />
                                                            <xsl:text>) </xsl:text>
                                                        </xsl:if>
                                                    </span>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="cbc:ID" />-
                                                    <xsl:for-each select="cbc:IssueDate">
                                                        <xsl:value-of select="substring(.,9,2)" />.<xsl:value-of select="substring(.,6,2)" />.<xsl:value-of select="substring(.,1,4)" />
                                                    </xsl:for-each>
                                                </td>
                                            </tr>

                                        </xsl:for-each>

                                        <!--    <xsl:for-each select="n1:Invoice/cac:BillingReference[position() &lt;2]">

                                            <tr style="height:13px">
                                                <td align="left">
                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>İade Fatura No - Tarih:</xsl:text>
                                                    </span>

                                                    <span>
                                                        <xsl:text>&#160;</xsl:text>

                                                        <xsl:if test="$iadeCount &gt; 1">
                                                            <xsl:text>(</xsl:text>
                                                            <xsl:value-of select="$iadeCount" />
                                                            <xsl:text>) </xsl:text>
                                                        </xsl:if>
                                                    </span>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="cac:InvoiceDocumentReference/cbc:ID" />-
                                                    <xsl:for-each select="cac:InvoiceDocumentReference/cbc:IssueDate">
                                                        <xsl:value-of select="substring(.,9,2)" />.<xsl:value-of select="substring(.,6,2)" />.<xsl:value-of select="substring(.,1,4)" />
                                                    </xsl:for-each>
                                                </td>
                                            </tr>
                                        </xsl:for-each>-->



                                        <xsl:if test="//n1:Invoice/cac:OrderReference">
                                            <tr style="height:13px">
                                                <td align="left">
                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>Sipariş No:</xsl:text>
                                                    </span>
                                                </td>
                                                <td align="left">
                                                    <xsl:for-each select="n1:Invoice/cac:OrderReference">
                                                        <xsl:for-each select="cbc:ID">
                                                            <xsl:apply-templates />
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </td>
                                            </tr>
                                        </xsl:if>
                                        <xsl:if test="//n1:Invoice/cac:OrderReference/cbc:IssueDate">
                                            <tr style="height:13px">
                                                <td align="left">
                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>Sipariş Tarihi:</xsl:text>
                                                    </span>
                                                </td>
                                                <td align="left">
                                                    <xsl:for-each select="n1:Invoice/cac:OrderReference">
                                                        <xsl:for-each select="cbc:IssueDate">
                                                            <xsl:value-of select="substring(.,9,2)" />-<xsl:value-of select="substring(.,6,2)" />-<xsl:value-of select="substring(.,1,4)" />
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </td>
                                            </tr>
                                        </xsl:if>
                                        <xsl:for-each select="n1:Invoice/cac:TaxRepresentativeParty/cac:PartyIdentification/cbc:ID[@schemeID='ARACIKURUMVKN']">
                                            <tr>
                                                <td style="width:105px;" align="left">
                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>Aracı Kurum VKN:</xsl:text>
                                                    </span>
                                                </td>
                                                <td style="width:110px;" align="left">
                                                    <xsl:value-of select="."/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="width:105px;" align="left">
                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>Aracı Kurum Unvan:</xsl:text>
                                                    </span>
                                                </td>
                                                <td style="width:110px;" align="left">
                                                    <xsl:value-of select="../../cac:PartyName/cbc:Name"/>
                                                </td>
                                            </tr>
                                        </xsl:for-each>


                                    </tbody>
                                </table>

                            </td>

                        </tr>
                        <tr align="left">
                            <table id="ettnTable">
                                <tr style="height:13px;">
                                    <td align="left" valign="top">
                                        <span style="font-weight:bold; ">
                                            <xsl:text>ETTN:</xsl:text>
                                        </span>
                                    </td>
                                    <td align="left" width="240px">
                                        <xsl:for-each select="n1:Invoice">
                                            <xsl:for-each select="cbc:UUID">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </td>
                                </tr>
                            </table>
                        </tr>


                        <xsl:if test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID] ='7750409379'">
                            <tr>
                                <td>
                                    <br/>
                                </td>
                            </tr>


                            <tr>
                                <td>
                                    <table border="1">



                                        <tbody>
                                            <tr>
                                                <td style="width:105px; " align="left">
                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>Sağlık Fatura Tipi:</xsl:text>
                                                    </span>
                                                </td>
                                                <td align="left">
                                                    <xsl:for-each select="n1:Invoice">
                                                        <xsl:for-each select="cbc:AccountingCost">
                                                            <xsl:apply-templates/>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </td>
                                            </tr>
                                            <tr style="height:13px; ">
                                                <td align="left">
                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>Mükellef Kodu:</xsl:text>
                                                    </span>
                                                </td>
                                                <td align="left">
                                                    <xsl:for-each select="n1:Invoice">
                                                        <xsl:for-each select="cac:AdditionalDocumentReference[cbc:DocumentTypeCode='MUKELLEF_KODU']/cbc:DocumentType">
                                                            <xsl:apply-templates/>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </td>
                                            </tr>
                                            <tr style="height:13px; ">
                                                <td align="left">
                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>Mükellef Adı:</xsl:text>
                                                    </span>
                                                </td>
                                                <td align="left">
                                                    <xsl:for-each select="n1:Invoice">
                                                        <xsl:for-each select="cac:AdditionalDocumentReference[cbc:DocumentTypeCode='MUKELLEF_ADI']/cbc:DocumentType">
                                                            <xsl:apply-templates/>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </td>
                                            </tr>
                                            <tr style="height:13px; ">
                                                <td align="left">
                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>Dosya No:</xsl:text>
                                                    </span>
                                                </td>
                                                <td align="left">
                                                    <xsl:for-each select="n1:Invoice">
                                                        <xsl:for-each select="cac:AdditionalDocumentReference[cbc:DocumentTypeCode='DOSYA_NO']/cbc:DocumentType">
                                                            <xsl:apply-templates/>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </td>
                                            </tr>
                                            <tr style="height:13px; ">
                                                <td align="left">
                                                    <span style="font-weight:bold; ">
                                                        <xsl:text>Dönem:</xsl:text>
                                                    </span>
                                                </td>
                                                <td align="left">
                                                    <xsl:for-each select="n1:Invoice">
                                                        <xsl:for-each select="cac:InvoicePeriod/cbc:StartDate">

                                                            <xsl:apply-templates/>
                                                        </xsl:for-each>
                                                        <span>
                                                            <xsl:text> / </xsl:text>
                                                        </span>
                                                        <xsl:for-each select="cac:InvoicePeriod/cbc:EndDate">

                                                            <xsl:apply-templates/>
                                                        </xsl:for-each>
                                                    </xsl:for-each>

                                                </td>
                                            </tr>

                                        </tbody>
                                    </table>
                                </td>
                            </tr>




                            <tr>
                                <td>
                                    <br/>
                                </td>
                            </tr>


                        </xsl:if>






                    </table>
                    <div id="lineTableAligner">
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
                    <table border="1" id="lineTable" width="800">
                        <tbody>
                            <tr id="lineTableTr">
                                <td id="lineTableTd" style="width:3%">
                                    <span style="font-weight:bold; " align="center">
                                        <xsl:text>Sıra No</xsl:text>
                                    </span>
                                </td>
                                <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:Item/cac:SellersItemIdentification">
                                    <td id="lineTableTd" style="width:3%">
                                        <span style="font-weight:bold; " align="center">
                                            <xsl:text>Stok Kodu</xsl:text>
                                        </span>
                                    </td>
                                </xsl:if>
                                <td id="lineTableTd" style="width:20%" align="center">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>Malzeme/Hizmet Açıklaması</xsl:text>
                                    </span>
                                </td>
                                <td id="lineTableTd" style="width:7.4%" align="center">
                                    <span style="font-weight:bold;">
                                        <xsl:text>Miktar</xsl:text>
                                    </span>
                                </td>
                                <td id="lineTableTd" style="width:9%" align="center">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>Birim Fiyat</xsl:text>
                                    </span>
                                </td>
                                <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:AllowanceCharge/cbc:MultiplierFactorNumeric &gt;0">
                                    <td id="lineTableTd" style="width:7%" align="center">
                                        <span style="font-weight:bold; ">
                                            <xsl:text>İskonto Oranı&#160;%</xsl:text>
                                        </span>
                                    </td>
                                </xsl:if>
                                <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:AllowanceCharge/cbc:Amount &gt;0">
                                    <td id="lineTableTd" style="width:9%" align="center">
                                        <span style="font-weight:bold; ">
                                            <xsl:text>İskonto Tutarı&#160;&#160;</xsl:text>
                                        </span>
                                    </td>
                                </xsl:if>
                                <td id="lineTableTd" style="width:7%" align="center">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>KDV Oranı</xsl:text>
                                    </span>
                                </td>
                                <td id="lineTableTd" style="width:10%" align="center">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>KDV Tutarı</xsl:text>
                                    </span>
                                </td>
                                <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode!='0015'">
                                    <td id="lineTableTd" style="width:17%; " align="center">
                                        <span style="font-weight:bold; ">
                                            <xsl:text>Diğer Vergiler</xsl:text>
                                        </span>
                                    </td>
                                </xsl:if>
                                <td id="lineTableTd" style="width:10.6%" align="center">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>Mal Hizmet Tutarı</xsl:text>
                                    </span>
                                </td>
                                <xsl:if test="//n1:Invoice/cbc:ProfileID='IHRACAT'">
                                    <td class="lineTableTd" style="width:10.6%" align="center">
                                        <span style="font-weight:bold;">
                                            <xsl:text>Teslim Şartı</xsl:text>
                                        </span>
                                    </td>
                                    <td class="lineTableTd" style="width:10.6%" align="center">
                                        <span style="font-weight:bold;">
                                            <xsl:text>Eşya Kap Cinsi</xsl:text>
                                        </span>
                                    </td>
                                    <td class="lineTableTd" style="width:10.6%" align="center">
                                        <span style="font-weight:bold;">
                                            <xsl:text>Kap No</xsl:text>
                                        </span>
                                    </td>
                                    <td class="lineTableTd" style="width:10.6%" align="center">
                                        <span style="font-weight:bold;">
                                            <xsl:text>Kap Adet</xsl:text>
                                        </span>
                                    </td>
                                    <td class="lineTableTd" style="width:10.6%" align="center">
                                        <span style="font-weight:bold;">
                                            <xsl:text>Teslim/Bedel Ödeme Yeri</xsl:text>
                                        </span>
                                    </td>
                                    <td class="lineTableTd" style="width:10.6%" align="center">
                                        <span style="font-weight:bold;">
                                            <xsl:text>Gönderilme Şekli</xsl:text>
                                        </span>
                                    </td>
                                    <td class="lineTableTd" style="width:10.6%" align="center">
                                        <span style="font-weight:bold;">
                                            <xsl:text>GTİP</xsl:text>
                                        </span>
                                    </td>
                                </xsl:if>
                            </tr>
                            <xsl:if test="count(//n1:Invoice/cac:InvoiceLine) &gt;= 6">
                                <xsl:for-each select="//n1:Invoice/cac:InvoiceLine">
                                    <xsl:apply-templates select="." />
                                </xsl:for-each>
                            </xsl:if>
                            <xsl:if test="count(//n1:Invoice/cac:InvoiceLine) &lt; 6">
                                <xsl:choose>
                                    <xsl:when test="//n1:Invoice/cac:InvoiceLine[1]">
                                        <xsl:apply-templates select="//n1:Invoice/cac:InvoiceLine[1]" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="//n1:Invoice" />
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="//n1:Invoice/cac:InvoiceLine[2]">
                                        <xsl:apply-templates select="//n1:Invoice/cac:InvoiceLine[2]" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="//n1:Invoice" />
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="//n1:Invoice/cac:InvoiceLine[3]">
                                        <xsl:apply-templates select="//n1:Invoice/cac:InvoiceLine[3]" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="//n1:Invoice" />
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="//n1:Invoice/cac:InvoiceLine[4]">
                                        <xsl:apply-templates select="//n1:Invoice/cac:InvoiceLine[4]" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="//n1:Invoice" />
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="//n1:Invoice/cac:InvoiceLine[5]">
                                        <xsl:apply-templates select="//n1:Invoice/cac:InvoiceLine[5]" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="//n1:Invoice" />
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="//n1:Invoice/cac:InvoiceLine[6]">
                                        <xsl:apply-templates select="//n1:Invoice/cac:InvoiceLine[6]" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="//n1:Invoice" />
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="//n1:Invoice/cac:InvoiceLine[7]">
                                        <xsl:apply-templates select="//n1:Invoice/cac:InvoiceLine[7]" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="//n1:Invoice" />
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="//n1:Invoice/cac:InvoiceLine[8]">
                                        <xsl:apply-templates select="//n1:Invoice/cac:InvoiceLine[8]" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="//n1:Invoice" />
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="//n1:Invoice/cac:InvoiceLine[9]">
                                        <xsl:apply-templates select="//n1:Invoice/cac:InvoiceLine[9]" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="//n1:Invoice" />
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="//n1:Invoice/cac:InvoiceLine[10]">
                                        <xsl:apply-templates select="//n1:Invoice/cac:InvoiceLine[10]" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="//n1:Invoice" />
                                    </xsl:otherwise>
                                </xsl:choose>

                            </xsl:if>
                        </tbody>
                    </table>
                </xsl:for-each>
                <table id="budgetContainerTable" width="800px">
                    <tr id="budgetContainerTr" align="right">
                        <td id="budgetContainerDummyTd" />
                        <td id="lineTableBudgetTd" align="right" width="200px">
                            <span style="font-weight:bold; ">
                                <xsl:text>Mal Hizmet Toplam Tutarı</xsl:text>
                            </span>
                        </td>
                        <td id="lineTableBudgetTd" style="width:81px; " align="right">
                            <span>
                                <xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount, '###.##0,00', 'european')" />
                                <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID">
                                    <xsl:text>
                                    </xsl:text>
                                    <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID = 'TRY'">
                                        <xsl:text>TL</xsl:text>
                                    </xsl:if>
                                    <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRY'">
                                        <xsl:value-of select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID" />
                                    </xsl:if>
                                </xsl:if>
                            </span>
                        </td>
                    </tr>


                    <xsl:if test="//n1:Invoice/cac:Delivery/cac:Shipment/cbc:InsuranceValueAmount">
                        <tr id="budgetContainerTr" align="right">
                            <td id="budgetContainerDummyTd" />
                            <td id="lineTableBudgetTd" width="200px" align="right">
                                <span style="font-weight:bold; ">
                                    <xsl:text>Sigorta Tutarı</xsl:text>
                                </span>
                            </td>
                            <td id="lineTableBudgetTd" style="width:81px; " align="right">
                                <span>
                                    <xsl:value-of select="format-number(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:InsuranceValueAmount, '###.##0,00', 'european')" />
                                    <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID">
                                        <xsl:text>
                                        </xsl:text>
                                        <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID = 'TRY'">
                                            <xsl:text>TL</xsl:text>
                                        </xsl:if>
                                        <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRY'">
                                            <xsl:value-of select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID" />
                                        </xsl:if>
                                    </xsl:if>
                                </span>
                            </td>
                        </tr>
                    </xsl:if>


                    <xsl:if test="//n1:Invoice/cac:Delivery/cac:Shipment/cbc:DeclaredForCarriageValueAmount">
                        <tr id="budgetContainerTr" align="right">
                            <td id="budgetContainerDummyTd" />
                            <td id="lineTableBudgetTd" width="200px" align="right">
                                <span style="font-weight:bold; ">
                                    <xsl:text>Navlun Tutarı</xsl:text>
                                </span>
                            </td>
                            <td id="lineTableBudgetTd" style="width:81px; " align="right">
                                <span>
                                    <xsl:value-of select="format-number(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:DeclaredForCarriageValueAmount, '###.##0,00', 'european')" />
                                    <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID">
                                        <xsl:text>
                                        </xsl:text>
                                        <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID = 'TRY'">
                                            <xsl:text>TL</xsl:text>
                                        </xsl:if>
                                        <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRY'">
                                            <xsl:value-of select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID" />
                                        </xsl:if>
                                    </xsl:if>
                                </span>
                            </td>
                        </tr>
                    </xsl:if>


                    <tr id="budgetContainerTr" align="right">
                        <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount &gt;0">
                            <td id="budgetContainerDummyTd" />
                            <td id="lineTableBudgetTd" align="right" width="200px">
                                <xsl:if test="//n1:Invoice/cac:AllowanceCharge/cbc:ChargeIndicator">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>Toplam İndirim İskonto</xsl:text>
                                    </span>
                                </xsl:if>


                            </td>
                            <td id="lineTableBudgetTd" style="width:81px; " align="right">
                                <span>
                                    <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount &gt;0">
                                        <xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount, '###.##0,00', 'european')" />
                                        <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount">
                                            <xsl:text>
                                            </xsl:text>
                                            <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID = 'TRY'">
                                                <xsl:text>TL</xsl:text>
                                            </xsl:if>
                                            <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID != 'TRY'">
                                                <xsl:value-of select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID" />
                                            </xsl:if>
                                        </xsl:if>
                                    </xsl:if>
                                </span>
                            </td>
                        </xsl:if>
                    </tr>



                    <tr id="budgetContainerTr" align="right">
                        <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount &gt;0">
                            <td id="budgetContainerDummyTd" />
                            <td id="lineTableBudgetTd" align="right" width="200px">
                                <xsl:if test="//n1:Invoice/cac:AllowanceCharge/cbc:ChargeIndicator">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>Toplam Arttırım İskonto</xsl:text>
                                    </span>
                                </xsl:if>


                            </td>
                            <td id="lineTableBudgetTd" style="width:81px; " align="right">
                                <span>
                                    <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount &gt;0">
                                        <xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount, '###.##0,00', 'european')" />
                                        <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount">
                                            <xsl:text>
                                            </xsl:text>
                                            <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount/@currencyID = 'TRY'">
                                                <xsl:text>TL</xsl:text>
                                            </xsl:if>
                                            <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount/@currencyID != 'TRY'">
                                                <xsl:value-of select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount/@currencyID" />
                                            </xsl:if>
                                        </xsl:if>
                                    </xsl:if>
                                </span>
                            </td>
                        </xsl:if>
                    </tr>
                    <xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
                        <tr id="budgetContainerTr" align="right">
                            <td id="budgetContainerDummyTd" />
                            <td id="lineTableBudgetTd" width="211px" align="right">
                                <span style="font-weight:bold; ">
                                    <xsl:text>Hesaplanan </xsl:text>
                                    <xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:Name" />
                                    <xsl:text>(%</xsl:text>
                                    <xsl:value-of select="cbc:Percent" />
                                    <xsl:text>)</xsl:text>
                                </span>
                            </td>
                            <td id="lineTableBudgetTd" style="width:82px; " align="right">
                                <xsl:for-each select="cac:TaxCategory/cac:TaxScheme">
                                    <xsl:text>
                                    </xsl:text>
                                    <xsl:value-of select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')" />
                                    <xsl:if test="../../cbc:TaxAmount/@currencyID">
                                        <xsl:text>
                                        </xsl:text>
                                        <xsl:if test="../../cbc:TaxAmount/@currencyID = 'TRY'">
                                            <xsl:text>TL</xsl:text>
                                        </xsl:if>
                                        <xsl:if test="../../cbc:TaxAmount/@currencyID != 'TRY'">
                                            <xsl:value-of select="../../cbc:TaxAmount/@currencyID" />
                                        </xsl:if>
                                    </xsl:if>
                                </xsl:for-each>
                            </td>
                        </tr>
                    </xsl:for-each>
                    <xsl:if test = "n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
                        <tr id="budgetContainerTr" align="right">
                            <td id="budgetContainerDummyTd"/>
                            <td id="lineTableBudgetTd" width="211px" align="right">
                                <span style="font-weight:bold; ">
                                    <xsl:text>Tevkifata Tabi İşlem Tutarı</xsl:text>
                                </span>
                            </td>
                            <td id="lineTableBudgetTd" style="width:82px; " align="right">
                                <xsl:if test = "n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
                                    <xsl:value-of
                                        select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
                                </xsl:if>
                                <xsl:if test = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=&apos;9015&apos;">
                                    <xsl:value-of
                                        select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
                                </xsl:if>
                                <xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode = 'TRL' or n1:Invoice/cbc:DocumentCurrencyCode = 'TRY'">
                                    <xsl:text>&#160;TL</xsl:text>
                                </xsl:if>
                                <xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode != 'TRL' and n1:Invoice/cbc:DocumentCurrencyCode != 'TRY'">
                                    <xsl:value-of select="n1:Invoice/cbc:DocumentCurrencyCode"/>
                                </xsl:if>
                            </td>
                        </tr>
                        <xsl:if test = "n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
                            <tr id="budgetContainerTr" align="right">
                                <td id="budgetContainerDummyTd"/>
                                <td id="lineTableBudgetTd" width="211px" align="right">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>Tevkifata Tabi İşlem Tutarı</xsl:text>
                                    </span>
                                </td>
                                <td id="lineTableBudgetTd" style="width:82px; " align="right">
                                    <xsl:if test = "n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]">
                                        <xsl:value-of
                                        select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
                                    </xsl:if>
                                    <xsl:if test = "//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=&apos;9015&apos;">
                                        <xsl:value-of
                                        select="format-number(sum(n1:Invoice/cac:InvoiceLine[cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=9015]/cbc:LineExtensionAmount), '###.##0,00', 'european')"/>
                                    </xsl:if>
                                    <xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode = 'TRL' or n1:Invoice/cbc:DocumentCurrencyCode = 'TRY'">
                                        <xsl:text>&#160;TL</xsl:text>
                                    </xsl:if>
                                    <xsl:if test="n1:Invoice/cbc:DocumentCurrencyCode != 'TRL' and n1:Invoice/cbc:DocumentCurrencyCode != 'TRY'">
                                        <xsl:value-of select="n1:Invoice/cbc:DocumentCurrencyCode"/>
                                    </xsl:if>
                                </td>
                            </tr>
                        </xsl:if>
                    </xsl:if>
                    <tr id="budgetContainerTr" align="right">
                        <td id="budgetContainerDummyTd" />
                        <td id="lineTableBudgetTd" width="200px" align="right">
                            <span style="font-weight:bold; ">
                                <xsl:text>Vergiler Dahil Toplam Tutar</xsl:text>
                            </span>
                        </td>
                        <td id="lineTableBudgetTd" style="width:82px; " align="right">
                            <xsl:for-each select="n1:Invoice">
                                <xsl:for-each select="cac:LegalMonetaryTotal">
                                    <xsl:for-each select="cbc:TaxInclusiveAmount">
                                        <xsl:value-of select="format-number(., '###.##0,00', 'european')" />
                                        <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID">
                                            <xsl:text>
                                            </xsl:text>
                                            <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID = 'TRY'">
                                                <xsl:text>TL</xsl:text>
                                            </xsl:if>
                                            <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID != 'TRY'">
                                                <xsl:value-of select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID" />
                                            </xsl:if>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </xsl:for-each>
                        </td>
                    </tr>
                    <tr id="budgetContainerTr" align="right">
                        <td id="budgetContainerDummyTd" />
                        <td id="lineTableBudgetTd" width="200px" align="right">
                            <span style="font-weight:bold; ">
                                <xsl:text>Ödenecek Tutar</xsl:text>
                            </span>
                        </td>
                        <td id="lineTableBudgetTd" style="width:82px; " align="right">
                            <xsl:for-each select="n1:Invoice">
                                <xsl:for-each select="cac:LegalMonetaryTotal">
                                    <xsl:for-each select="cbc:PayableAmount">
                                        <xsl:value-of select="format-number(., '###.##0,00', 'european')" />
                                        <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID">
                                            <xsl:text>
                                            </xsl:text>
                                            <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID = 'TRY'">
                                                <xsl:text>TL</xsl:text>
                                            </xsl:if>
                                            <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID != 'TRY'">
                                                <xsl:value-of select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID" />
                                            </xsl:if>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </xsl:for-each>
                        </td>
                    </tr>
                    <xsl:if test="//n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate">
                        <tr id="budgetContainerTr" align="right">
                            <td id="budgetContainerDummyTd" />
                            <td id="lineTableBudgetTd" width="200px" align="right">
                                <span style="font-weight:bold; ">
                                    <xsl:text>Döviz Kuru</xsl:text>
                                </span>
                            </td>
                            <td id="lineTableBudgetTd" style="width:82px; " align="right">
                                <xsl:for-each select="n1:Invoice">
                                    <xsl:for-each select="cac:PricingExchangeRate">
                                        <xsl:for-each select="cbc:CalculationRate">
                                            <xsl:value-of select="format-number(., '###.0,0000', 'european')" />
                                            <xsl:if test="//n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate">
                                                <xsl:text>
                                                </xsl:text>

                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </td>
                        </tr>
                    </xsl:if>
                    <xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID != 'TRY'">
                        <tr align="right">
                            <td />
                            <td id="lineTableBudgetTd" align="right" width="200px">
                                <span style="font-weight:bold; ">
                                    <xsl:text>Mal Hizmet Toplam Tutarı(TL)</xsl:text>
                                </span>
                            </td>
                            <td id="lineTableBudgetTd" style="width:81px; " align="right">
                                <span>
                                    <xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')" />
                                    <xsl:text> TL</xsl:text>
                                </span>
                            </td>
                        </tr>
                        <tr id="budgetContainerTr" align="right">
                            <td />
                            <td id="lineTableBudgetTd" width="200px" align="right">
                                <span style="font-weight:bold; ">
                                    <xsl:text>Vergiler Dahil Toplam Tutar(TL)</xsl:text>
                                </span>
                            </td>
                            <td id="lineTableBudgetTd" style="width:82px; " align="right">
                                <xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')" />
                                <xsl:text> TL</xsl:text>
                            </td>
                        </tr>
                        <tr align="right">
                            <td />
                            <td id="lineTableBudgetTd" width="200px" align="right">
                                <span style="font-weight:bold; ">
                                    <xsl:text>Ödenecek Tutar(TL)</xsl:text>
                                </span>
                            </td>
                            <td id="lineTableBudgetTd" style="width:82px; " align="right">
                                <xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')" />
                                <xsl:text> TL</xsl:text>
                            </td>
                        </tr>
                    </xsl:if>

                </table>
                <br />
                <xsl:if test="//n1:Invoice/cac:BillingReference/cac:InvoiceDocumentReference/cbc:DocumentTypeCode[text()='İADE' or text()='IADE']">
                    <table id="lineTable" width="800">
                        <thead>
                            <tr>
                                <td align="left">
                                    <span style="font-weight:bold; " align="center">&#160;&#160;&#160;&#160;&#160;İadeye Konu Olan Faturalar</span>
                                </td>
                            </tr>
                        </thead>
                        <tbody>
                            <tr align="left" class="lineTableTr">
                                <td class="lineTableTd">
                                    <span style="font-weight:bold; " align="center">&#160;&#160;&#160;&#160;&#160;Fatura No</span>
                                </td>
                                <td class="lineTableTd">
                                    <span style="font-weight:bold; " align="center">&#160;&#160;&#160;&#160;&#160;Tarih</span>
                                </td>
                            </tr>
                            <xsl:for-each select="//n1:Invoice/cac:BillingReference/cac:InvoiceDocumentReference/cbc:DocumentTypeCode[text()='İADE' or text()='IADE']">
                                <tr align="left" class="lineTableTr">
                                    <td class="lineTableTd">&#160;&#160;&#160;&#160;&#160;
                                        <xsl:value-of select="../cbc:ID"/>
                                    </td>
                                    <td class="lineTableTd">&#160;&#160;&#160;&#160;&#160;
                                        <xsl:for-each select="../cbc:IssueDate">
                                            <xsl:apply-templates select="."/>
                                        </xsl:for-each>
                                    </td>
                                </tr>
                            </xsl:for-each>
                        </tbody>
                    </table>
                </xsl:if>
                <br/>
                <xsl:if test="//n1:Invoice/cac:BillingReference/cac:AdditionalDocumentReference/cbc:DocumentTypeCode='OKCBF'">
                    <table border="1" id="lineTable" width="800">
                        <thead>
                            <tr>
                                <th colspan="6">ÖKC Bilgileri</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr id="okcbfHeadTr" style="font-weight:bold;">
                                <td style="width:20%">
                                    <xsl:text>Fiş Numarası</xsl:text>
                                </td>
                                <td style="width:10%" align="center">
                                    <xsl:text>Fiş Tarihi</xsl:text>
                                </td>
                                <td style="width:10%" align="center">
                                    <xsl:text>Fiş Saati</xsl:text>
                                </td>
                                <td style="width:40%" align="center">
                                    <xsl:text>Fiş Tipi</xsl:text>
                                </td>
                                <td style="width:10%" align="center">
                                    <xsl:text>Z Rapor No</xsl:text>
                                </td>
                                <td style="width:10%" align="center">
                                    <xsl:text>ÖKC Seri No</xsl:text>
                                </td>
                            </tr>
                        </tbody>
                        <xsl:for-each select="//n1:Invoice/cac:BillingReference/cac:AdditionalDocumentReference/cbc:DocumentTypeCode[text()='OKCBF']">
                            <tr>
                                <td style="width:20%">
                                    <xsl:value-of select="../cbc:ID"/>
                                </td>
                                <td style="width:10%" align="center">
                                    <xsl:value-of select="../cbc:IssueDate"/>
                                </td>
                                <td style="width:10%" align="center">
                                    <xsl:value-of select="substring(../cac:ValidityPeriod/cbc:StartTime,1,5)"/>
                                </td>
                                <td style="width:40%" align="center">
                                    <xsl:choose>
                                        <xsl:when test="../cbc:DocumentDescription='AVANS'">
                                            <xsl:text>Ön Tahsilat(Avans) Bilgi Fişi</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="../cbc:DocumentDescription='YEMEK_FIS'">
                                            <xsl:text>Yemek Fişi/Kartı ile Yapılan Tahsilat Bilgi Fişi</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="../cbc:DocumentDescription='E-FATURA'">
                                            <xsl:text>E-Fatura Bilgi Fişi</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="../cbc:DocumentDescription='E-FATURA_IRSALIYE'">
                                            <xsl:text>İrsaliye Yerine Geçen E-Fatura Bilgi Fişi</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="../cbc:DocumentDescription='E-ARSIV'">
                                            <xsl:text>E-Arşiv Bilgi Fişi</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="../cbc:DocumentDescription='E-ARSIV_IRSALIYE'">
                                            <xsl:text>İrsaliye Yerine Geçen E-Arşiv Bilgi Fişi</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="../cbc:DocumentDescription='FATURA'">
                                            <xsl:text>Faturalı Satış Bilgi Fişi</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="../cbc:DocumentDescription='OTOPARK'">
                                            <xsl:text>Otopark Giriş Bilgi Fişi</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="../cbc:DocumentDescription='FATURA_TAHSILAT'">
                                            <xsl:text>Fatura Tahsilat Bilgi Fişi</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="../cbc:DocumentDescription='FATURA_TAHSILAT_KOMISYONLU'">
                                            <xsl:text>Komisyonlu Fatura Tahsilat Bilgi Fişi</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text> </xsl:text>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </td>
                                <td style="width:10%" align="center">
                                    <xsl:value-of select="../cac:Attachment/cac:ExternalReference/cbc:URI"/>
                                </td>
                                <td style="width:10%" align="center">
                                    <xsl:value-of select="../cac:IssuerParty/cbc:EndpointID"/>
                                </td>
                            </tr>
                        </xsl:for-each>
                    </table>
                    <br/>
                </xsl:if>
                <table id="notesTable" width="800" height="100">
                    <tbody>
                        <tr align="left">
                            <td id="notesTableTd">
                                <xsl:for-each select="//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
                                    <xsl:if test="(cbc:Percent=0 and cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode=&apos;0015&apos;) or (//n1:Invoice/cbc:InvoiceTypeCode='ISTISNA' or 'IHRACKAYITLI')">
                                        <b>Vergi İstisna Muafiyet Sebebi: </b>
                                        <xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReason" />
                                        <br />
                                    </xsl:if>
                                </xsl:for-each>

                                <xsl:for-each select="//n1:Invoice/cac:AllowanceCharge">
                                    <xsl:if test="cbc:AllowanceChargeReason!= ''">

                                        <b>
                                            <xsl:value-of select="cbc:AllowanceChargeReason" />
                                        </b> :&#160;

                                        <xsl:value-of select="cbc:Amount" />
                                        <xsl:if test="cbc:Amount/@currencyID = 'TRY'">
                                            <xsl:text>TL</xsl:text>
                                        </xsl:if>
                                        <xsl:if test="cbc:Amount/@currencyID != 'TRY'">
                                            <xsl:value-of select="cbc:Amount/@currencyID" />
                                        </xsl:if>

                                        <br />

                                    </xsl:if>
                                </xsl:for-each>

                                <xsl:for-each select="//n1:Invoice/cac:WithholdingTaxTotal">
                                    <xsl:if test="//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:Name">
                                        <b>Tevkifat  Sebebi: </b>
                                        <xsl:value-of select="//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode" />
                                        -
                                        <xsl:value-of select="//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:Name" />
                                        <br />
                                    </xsl:if>
                                </xsl:for-each>
                                <br />
                                <b>Yalnız: </b>
                                <xsl:for-each select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount">
                                    <xsl:call-template name="dovizi_oku">
                                        <xsl:with-param name="doviz" select="@currencyID" />
                                    </xsl:call-template>
                                </xsl:for-each>
                                <br />
                                <xsl:if test="$irsaliyeCount &gt; 1">
                                    <b> İrsaliyeler :  </b>
                                    <xsl:for-each select="//n1:Invoice/cac:DespatchDocumentReference[position() &gt; 1]">

                                        <xsl:value-of select="cbc:ID" />-
                                        <xsl:for-each select="cbc:IssueDate">
                                            <xsl:value-of select="substring(.,9,2)" />/<xsl:value-of select="substring(.,6,2)" />/<xsl:value-of select="substring(.,1,4)" />
                                        </xsl:for-each>
                                        <xsl:text>,&#160;&#160;</xsl:text>
                                    </xsl:for-each>
                                    <br />
                                </xsl:if>



                                <xsl:if test="//n1:Invoice/cbc:Note">

                                    <br/>
                                    <xsl:for-each select="//n1:Invoice/cbc:Note">
                                        <b>Not : </b>
                                        <xsl:value-of select="."/>
                                        <br/>
                                    </xsl:for-each>

                                </xsl:if>

                                <br/>                                                               
                                <xsl:if test="//n1:Invoice/cac:PaymentMeans/cbc:PaymentDueDate">
                                    <b> Ödeme Tarihi: </b>
                                    <xsl:value-of select="//n1:Invoice/cac:PaymentMeans/cbc:PaymentDueDate" />
                                    <br />
                                </xsl:if>
                                <xsl:if test="//n1:Invoice/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:PaymentNote">
                                    <b> Hesap Açıklaması: </b>
                                    <xsl:value-of select="//n1:Invoice/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:PaymentNote" />
                                    <br />
                                </xsl:if>
                                <xsl:if test="//n1:Invoice/cac:PaymentTerms/cbc:Note">
                                    <b> Ödeme Koşulu: </b>
                                    <xsl:value-of select="//n1:Invoice/cac:PaymentTerms/cbc:Note" />
                                    <br />
                                </xsl:if>
                                <xsl:if test="//n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE']='TAXFREE' and //n1:Invoice/cac:TaxRepresentativeParty/cac:PartyTaxScheme/cbc:ExemptionReasonCode">
                                    <br/>
                                    <b>&#160;&#160;&#160;&#160;&#160; VAT OFF - NO CASH REFUND </b>
                                </xsl:if>

                                <xsl:if test="//n1:Invoice/cac:Delivery/cac:CarrierParty/cac:PartyName/cbc:Name">
                                    <b> Gönderiyi Taşıyan Unvan : </b>
                                    <xsl:value-of select="//n1:Invoice/cac:Delivery/cac:CarrierParty/cac:PartyName/cbc:Name" />
                                    <br />
                                </xsl:if>
                                <xsl:if test="//n1:Invoice/cac:Delivery/cac:CarrierParty/cac:PartyIdentification/cbc:ID">
                                    <b> Gönderiyi Taşıyan VKN/TCKN : </b>
                                    <xsl:value-of select="//n1:Invoice/cac:Delivery/cac:CarrierParty/cac:PartyIdentification/cbc:ID" />
                                    <br />
                                </xsl:if>
                                <xsl:if test="//n1:Invoice/cac:Delivery/cac:Despatch/cbc:ActualDespatchDate">
                                    <b> Gönderim Tarihi : </b>
                                    <xsl:value-of select="//n1:Invoice/cac:Delivery/cac:Despatch/cbc:ActualDespatchDate" />
                                    <br />
                                </xsl:if>
                                <xsl:if test="//n1:Invoice/cac:AdditionalDocumentReference/cbc:DocumentType = 'ELEKTRONIK' ">
                                    <span style="font-weight:bold;color:blue; ">
                                        <xsl:text>e-Arşiv izni kapsamında elektronik ortamda iletilmiştir.</xsl:text>
                                        <br />
                                    </span>
                                </xsl:if>

                                <xsl:if test="//n1:Invoice/cac:Delivery  and //n1:Invoice/cbc:ProfileID!='IHRACAT'">
                                    <span style="font-weight:bold;color:blue; ">
                                        <xsl:text>Bu satış internet üzerinden yapılmıştır.</xsl:text>
                                    </span>
                                    <br />
                                </xsl:if>

                                <xsl:if test="count(//n1:Invoice/cac:DespatchDocumentReference)=0">
                                    <span style="font-weight:bold;color:blue; ">
                                        <xsl:text>İrsaliye yerine geçer.</xsl:text>
                                    </span>
                                    <br />
                                </xsl:if>


                            </td>
                        </tr>
                    </tbody>
                </table>    




                <table width="800px" border="2">                
                        <tr>                           
                            <th>Banka Adı</th>
                            <th>Şube Adı</th>   
                            <th>IBAN</th>
                            <th>Para Birimi</th>
                        </tr>
                    <xsl:for-each select="n1:Invoice/cac:PaymentMeans">
                    <tr align="center" >
                        <td>
                            <xsl:value-of select="cac:PayeeFinancialAccount/cac:FinancialInstitutionBranch/cac:FinancialInstitution/cbc:Name" />
                        </td>
                        <td>
                            <xsl:value-of select="cac:PayeeFinancialAccount/cac:FinancialInstitutionBranch/cbc:Name"/>
                        </td>
                        <td>
                            <xsl:value-of select="cac:PayeeFinancialAccount/cbc:ID" />
                        </td>
                        <td>
                            <xsl:value-of select="cac:PayeeFinancialAccount/cbc:CurrencyCode" />
                        </td>
                    </tr>
                    </xsl:for-each>                         
                </table>                                        




                <xsl:if test="//n1:Invoice/cac:AdditionalDocumentReference/cbc:DocumentType = 'INTERNET' and  //n1:Invoice/cac:AdditionalDocumentReference/cbc:DocumentTypeCode = 'EArchiveType'">
                    <br />
                    <br />
                    <br />
                    <br />
                    <br />
                    <table border="1" align="left" id="lineTable" width="800">
                        <tbody>
                            <tr align="left">
                                <td>
                                    <b>
                                        <xsl:text>İade Bölümü</xsl:text>
                                    </b>
                                </td>
                            </tr>
                            <tr align="left" id="lineTableTr">
                                <td id="lineTableTd" style="width:20%" align="center">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>Malzeme/Hizmet Açıklaması</xsl:text>
                                    </span>
                                </td>
                                <td id="lineTableTd" style="width:7.4%" align="center">
                                    <span style="font-weight:bold;">
                                        <xsl:text>Miktar</xsl:text>
                                    </span>
                                </td>
                                <td id="lineTableTd" style="width:9%" align="center">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>Birim Fiyat</xsl:text>
                                    </span>
                                </td>

                                <td id="lineTableTd" style="width:7%" align="center">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>KDV Oranı</xsl:text>
                                    </span>
                                </td>
                                <td id="lineTableTd" style="width:10%" align="center">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>KDV Tutarı</xsl:text>
                                    </span>
                                </td>

                                <td id="lineTableTd" style="width:10.6%" align="center">
                                    <span style="font-weight:bold; ">
                                        <xsl:text>Mal Hizmet Tutarı</xsl:text>
                                    </span>
                                </td>
                            </tr>
                            <tr align="left">
                                <td>
                                    <br />
                                </td>
                                <br />
                                <td>
                                    <br />
                                </td>
                                <br />
                                <td/>
                                <br />
                                <td/>
                                <br />
                                <td/>
                                <td>
                                    <br />
                                </td>
                            </tr>
                            <tr align="left">
                                <td>
                                    <br />
                                </td>
                                <br />
                                <td>
                                    <br />
                                </td>
                                <br />
                                <td/>
                                <br />
                                <td/>
                                <br />
                                <td/>
                                <td>
                                    <br />
                                </td>
                            </tr>
                            <tr align="left">
                                <td>
                                    <br />
                                </td>
                                <br />
                                <td>
                                    <br />
                                </td>
                                <br />
                                <td/>
                                <br />
                                <td/>
                                <br />
                                <td/>
                                <td>
                                    <br />
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <br />
                    <br />
                    <br />
                    <br />
                    <br />
                    <br />
                    <br />
                    <b>
                        <xsl:text>Firma/Şahıs Unvanı :</xsl:text>
                    </b>
                    <br />
                    <b>
                        <xsl:text>Vkn/Tckno :</xsl:text>
                    </b>
                    <br />
                    <b>
                        <xsl:text>İmza Kaşe</xsl:text>
                    </b>
                    <br />

                </xsl:if>



            </body>
        </html>
    </xsl:template>

    <xsl:template name="dovizi_oku">
        <xsl:param name="doviz" />
        <xsl:variable name="okunacak" select="." />
        <xsl:variable name="noktadan_sonra" select="round(($okunacak - floor($okunacak)) * 100)" />
        <xsl:call-template name="sayi_oku" >
            <xsl:with-param name="okunacak"  select="." />
        </xsl:call-template>
        <xsl:if test="$doviz">
            <xsl:choose>
                <xsl:when test="$doviz =  'TRL' or $doviz =  'TRY'">
                    <xsl:value-of select="' Türk Lirası'" />
                    <xsl:if test="$noktadan_sonra &gt; 0">
                        <xsl:value-of select="' '" />
                        <xsl:call-template name="sayi_oku" >
                            <xsl:with-param name="okunacak"  select="$noktadan_sonra" />
                        </xsl:call-template>
                        <xsl:value-of select="' Kuruş'" />
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>&#160;</xsl:text>
                    <xsl:value-of select="$doviz" />
                    <xsl:if test="$noktadan_sonra &gt; 0">
                        <xsl:value-of select="' '" />
                        <xsl:call-template name="sayi_oku" >
                            <xsl:with-param name="okunacak"  select="$noktadan_sonra" />
                        </xsl:call-template>

                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>

        </xsl:if>
    </xsl:template>
    <xsl:template name="sayi_oku">
        <xsl:param name="okunacak" />
        <xsl:variable name="tam_sayi" select="floor($okunacak)" />
        <xsl:variable name="birler"   select="floor($okunacak) mod 10" />
        <xsl:variable name="onlar"    select="floor(floor($tam_sayi mod 100) div 10)" />
        <xsl:variable name="yuzler"   select="floor(floor($tam_sayi mod 1000) div 100)" />
        <xsl:variable name="binler"   select="floor(floor($tam_sayi mod 1000000) div 1000)" />
        <xsl:variable name="milyonlar"   select="floor(floor($tam_sayi mod 1000000000) div 1000000)" />
        <xsl:variable name="milyarlar"   select="floor(floor($tam_sayi mod 1000000000000) div 1000000000)" />

        <xsl:if test="$milyarlar &gt; 0">
            <xsl:call-template name="sayi_oku_3hane" >
                <xsl:with-param name="sayi"  select="$milyarlar" />
            </xsl:call-template> Milyar
        </xsl:if>
        <xsl:if test="$milyonlar &gt; 0">
            <xsl:call-template name="sayi_oku_3hane" >
                <xsl:with-param name="sayi"  select="$milyonlar" />
            </xsl:call-template> Milyon
        </xsl:if>
        <xsl:if test="$binler &gt; 0">
            <xsl:if test="$binler = 1">Bin </xsl:if>
            <xsl:if test="$binler > 1">
                <xsl:call-template name="sayi_oku_3hane" >
                    <xsl:with-param name="sayi"  select="$binler" />
                </xsl:call-template> Bin
            </xsl:if>
        </xsl:if>

        <xsl:call-template name="yuzler_oku" >
            <xsl:with-param name="sayi"  select="$yuzler" />
        </xsl:call-template>
        <xsl:call-template name="onlar_oku" >
            <xsl:with-param name="sayi"  select="$onlar" />
        </xsl:call-template>
        <xsl:call-template name="birler_oku" >
            <xsl:with-param name="sayi"  select="$birler" />
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="sayi_oku_3hane">
        <xsl:param name="sayi" />
        <xsl:variable name="tam_sayi" select="floor($sayi)" />
        <xsl:variable name="birler"   select="floor($sayi) mod 10" />
        <xsl:variable name="onlar"    select="floor(floor($tam_sayi mod 100) div 10)" />
        <xsl:variable name="yuzler"   select="floor(floor($tam_sayi mod 1000) div 100)" />
        <xsl:call-template name="yuzler_oku" >
            <xsl:with-param name="sayi"  select="$yuzler" />
        </xsl:call-template>
        <xsl:call-template name="onlar_oku" >
            <xsl:with-param name="sayi"  select="$onlar" />
        </xsl:call-template>
        <xsl:call-template name="birler_oku" >
            <xsl:with-param name="sayi"  select="$birler" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="birler_oku">
        <xsl:param name="sayi" />
        <xsl:choose>
            <xsl:when test="$sayi =  1">Bir </xsl:when>
            <xsl:when test="$sayi =  2">İki </xsl:when>
            <xsl:when test="$sayi =  3">Üç </xsl:when>
            <xsl:when test="$sayi =  4">Dört </xsl:when>
            <xsl:when test="$sayi =  5">Beş </xsl:when>
            <xsl:when test="$sayi =  6">Altı </xsl:when>
            <xsl:when test="$sayi =  7">Yedi </xsl:when>
            <xsl:when test="$sayi =  8">Sekiz </xsl:when>
            <xsl:when test="$sayi =  9">Dokuz </xsl:when>
            <xsl:otherwise> </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="onlar_oku">
        <xsl:param name="sayi" />
        <xsl:choose>
            <xsl:when test="$sayi =  1">On </xsl:when>
            <xsl:when test="$sayi =  2">Yirmi </xsl:when>
            <xsl:when test="$sayi =  3">Otuz </xsl:when>
            <xsl:when test="$sayi =  4">Kırk </xsl:when>
            <xsl:when test="$sayi =  5">Elli </xsl:when>
            <xsl:when test="$sayi =  6">Altmış </xsl:when>
            <xsl:when test="$sayi =  7">Yetmiş </xsl:when>
            <xsl:when test="$sayi =  8">Seksen </xsl:when>
            <xsl:when test="$sayi =  9">Doksan </xsl:when>
            <xsl:otherwise/>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="yuzler_oku">
        <xsl:param name="sayi" />
        <xsl:choose>
            <xsl:when test="$sayi =  1">Yüz </xsl:when>
            <xsl:when test="$sayi =  2">İki Yüz </xsl:when>
            <xsl:when test="$sayi =  3">Üç Yüz </xsl:when>
            <xsl:when test="$sayi =  4">Dört Yüz </xsl:when>
            <xsl:when test="$sayi =  5">Beş Yüz </xsl:when>
            <xsl:when test="$sayi =  6">Altı Yüz </xsl:when>
            <xsl:when test="$sayi =  7">Yedi Yüz </xsl:when>
            <xsl:when test="$sayi =  8">Sekiz Yüz </xsl:when>
            <xsl:when test="$sayi =  9">Dokuz Yüz </xsl:when>
            <xsl:otherwise/>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="binler_oku">
        <xsl:param name="sayi" />
        <xsl:choose>
            <xsl:when test="$sayi =  1">Bin </xsl:when>
            <xsl:when test="$sayi =  2">İki Bin </xsl:when>
            <xsl:when test="$sayi =  3">Üç Bin </xsl:when>
            <xsl:when test="$sayi =  4">Dört Bin </xsl:when>
            <xsl:when test="$sayi =  5">Beş Bin </xsl:when>
            <xsl:when test="$sayi =  6">Altı Bin </xsl:when>
            <xsl:when test="$sayi =  7">Yedi Bin </xsl:when>
            <xsl:when test="$sayi =  8">Sekiz Bin </xsl:when>
            <xsl:when test="$sayi =  9">Dokuz Bin </xsl:when>
            <xsl:otherwise/>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="onbinler_oku">
        <xsl:param name="sayi" />
        <xsl:if test="$sayi &gt; 0">
            <xsl:call-template name="onlar_oku" >
                <xsl:with-param name="sayi"  select="$sayi" />
            </xsl:call-template>Bin
        </xsl:if>
    </xsl:template>

    <xsl:template name="parcala">
        <xsl:param name="csv"/>
        <xsl:param name="isaret"/>
        <xsl:variable  name="first-item" select="normalize-space(substring-before( concat( $csv, '|'), '|'))"/>
        <xsl:if test="$csv">
            <xsl:if test="normalize-space(substring-after(concat($first-item, ''), $isaret))">
                <xsl:value-of disable-output-escaping="yes" select="normalize-space(substring-after(concat($first-item, ''), $isaret))"/>
            </xsl:if>
            <xsl:call-template name="parcala">
                <xsl:with-param name="csv" select="substring-after($csv,'|')"/>
                <xsl:with-param name="isaret" select="$isaret"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template match="dateFormatter">
        <xsl:value-of select="substring(.,9,2)" />-<xsl:value-of select="substring(.,6,2)" />-<xsl:value-of select="substring(.,1,4)" />
    </xsl:template>
    <xsl:template match="//n1:Invoice/cac:InvoiceLine">
        <tr id="lineTableTr">
            <td id="lineTableTd">
                <span>
                    <xsl:text>&#160;</xsl:text>
                    <xsl:value-of select="./cbc:ID" />
                </span>
            </td>


            <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:Item/cac:SellersItemIdentification">
                <td id="lineTableTd">
                    <span>
                        <xsl:text>&#160;</xsl:text>
                        <xsl:value-of select="./cac:Item/cac:SellersItemIdentification/cbc:ID" />
                    </span>
                </td>
            </xsl:if>


            <td id="lineTableTd">
                <span>
                    <xsl:text>&#160;</xsl:text>
                    <xsl:value-of select="./cac:Item/cbc:Name" />
                </span>
            </td>

            <td id="lineTableTd" align="right">
                <span>
                    <xsl:text>&#160;</xsl:text>
                    <xsl:value-of select="format-number(./cbc:InvoicedQuantity, '###.###,####', 'european')" />
                    <xsl:if test="./cbc:InvoicedQuantity/@unitCode">
                        <xsl:for-each select="./cbc:InvoicedQuantity">
                            <xsl:text>
                            </xsl:text>
                            <xsl:choose>
                                <xsl:when test="@unitCode  = '26'">
                                    <span>
                                        <xsl:text>Ton</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'TNE'">
                                    <span>
                                        <xsl:text>Ton</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'BX'">
                                    <span>
                                        <xsl:text>Kutu</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'LTR'">
                                    <span>
                                        <xsl:text>LT</xsl:text>
                                    </span>
                                </xsl:when>

                                <xsl:when test="@unitCode  = 'C62'">
                                    <span>
                                        <xsl:text>Adet</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KGM'">
                                    <span>
                                        <xsl:text>KG</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KJO'">
                                    <span>
                                        <xsl:text>kJ</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'GRM'">
                                    <span>
                                        <xsl:text>G</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'MGM'">
                                    <span>
                                        <xsl:text>MG</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'NT'">
                                    <span>
                                        <xsl:text>Net Ton</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'GT'">
                                    <span>
                                        <xsl:text>GT</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'MTR'">
                                    <span>
                                        <xsl:text>M</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'MMT'">
                                    <span>
                                        <xsl:text>MM</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KTM'">
                                    <span>
                                        <xsl:text>KM</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'MLT'">
                                    <span>
                                        <xsl:text>ML</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'MMQ'">
                                    <span>
                                        <xsl:text>MM3</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'CLT'">
                                    <span>
                                        <xsl:text>CL</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'CMK'">
                                    <span>
                                        <xsl:text>CM2</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'CMQ'">
                                    <span>
                                        <xsl:text>CM3</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'CMT'">
                                    <span>
                                        <xsl:text>CM</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'MTK'">
                                    <span>
                                        <xsl:text>M2</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'MTQ'">
                                    <span>
                                        <xsl:text>M3</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'DAY'">
                                    <span>
                                        <xsl:text>Gün</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'MON'">
                                    <span>
                                        <xsl:text>Ay</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'ANN'">
                                    <span>
                                        <xsl:text>Yıl</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'HUR'">
                                    <span>
                                        <xsl:text>Saat</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'D61'">
                                    <span>
                                        <xsl:text>Dakika</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'D62'">
                                    <span>
                                        <xsl:text>Saniye</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'PA'">
                                    <span>
                                        <xsl:text>Paket</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'R9'">
                                    <span>
                                        <xsl:text>1000 m3</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KWH'">
                                    <span>
                                        <xsl:text>KWH</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'GMS'">
                                    <span>
                                        <xsl:text>Gümüs</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'CTM'">
                                    <span>
                                        <xsl:text>Karat</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'ANN'">
                                    <span>
                                        <xsl:text>Yıl</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'HUR'">
                                    <span>
                                        <xsl:text>Saat</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'MIN'">
                                    <span>
                                        <xsl:text>Dakika</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'SEC'">
                                    <span>
                                        <xsl:text>Saniye</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'LPA'">
                                    <span>
                                        <xsl:text>saf alkol lt</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'BG'">
                                    <span>
                                        <xsl:text>Torba</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'PR'">
                                    <span>
                                        <xsl:text>Adet-Çift</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'DZN'">
                                    <span>
                                        <xsl:text>Düzine</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'SET'">
                                    <span>
                                        <xsl:text>Set</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'NPL'">
                                    <span>
                                        <xsl:text>Koli</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'FTK'">
                                    <span>
                                        <xsl:text>Ayak kare</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'FOT'">
                                    <span>
                                        <xsl:text>Ayak</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'AFF'">
                                    <span>
                                        <xsl:text>AFİF birim fiyatı</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'AKQ'">
                                    <span>
                                        <xsl:text>ATV Birim Fiyatı</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'AYR'">
                                    <span>
                                        <xsl:text>Altın ayarı</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'B32'">
                                    <span>
                                        <xsl:text>KG-METRE kare</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'BAS'">
                                    <span>
                                        <xsl:text>Bas</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'CCT'">
                                    <span>
                                        <xsl:text>Ton başı taşıma</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'D30'">
                                    <span>
                                        <xsl:text>Brüt Kalori değeri</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'D40'">
                                    <span>
                                        <xsl:text>Bin Litre</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'CEN'">
                                    <span>
                                        <xsl:text>Yüz adet</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'T3'">
                                    <span>
                                        <xsl:text>Bin adet</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'OTB'">
                                    <span>
                                        <xsl:text>OTV birim fiyatı</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'OMV'">
                                    <span>
                                        <xsl:text>OTV Maktu Vergi</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'D97'">
                                    <span>
                                        <xsl:text>Palet</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'MLT'">
                                    <span>
                                        <xsl:text>Mililitre</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'MGM'">
                                    <span>
                                        <xsl:text>Miligram</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'GRM'">
                                    <span>
                                        <xsl:text>Gram</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KGM'">
                                    <span>
                                        <xsl:text>Kilogram</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'GFI'">
                                    <span>
                                        <xsl:text>Fıssıle İzotop Gramı</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KUR'">
                                    <span>
                                        <xsl:text>Uranyum Kilogramı</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KSH'">
                                    <span>
                                        <xsl:text>Sodyum Hidroksit Kilogramı</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KSD'">
                                    <span>
                                        <xsl:text>%90 Kuru Ürün Kilogramı</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KPR'">
                                    <span>
                                        <xsl:text>Kilogram-Çift</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KPH'">
                                    <span>
                                        <xsl:text>Kg Potasyum Oksid</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KFO'">
                                    <span>
                                        <xsl:text>Difosfor Pentaoksit Kilogramı</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'K62'">
                                    <span>
                                        <xsl:text>Kilogram-Adet</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'K58'">
                                    <span>
                                        <xsl:text>Kurutulmuş Net Ağırlıklı Kilogramı</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'K20'">
                                    <span>
                                        <xsl:text>Kilogram Potasyum Oksit</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'LO'">
                                    <span>
                                        <xsl:text>Lot</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KMA'">
                                    <span>
                                        <xsl:text>METİL AMİNLERİN KİLOGRAMI</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KNI'">
                                    <span>
                                        <xsl:text>AZOTUN KİLOGRAMI</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'D32'">
                                    <span>
                                        <xsl:text>TERAWATT SAAT</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'GWH'">
                                    <span>
                                        <xsl:text>MEGAWATT SAAT </xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'KWT'">
                                    <span>
                                        <xsl:text>KİLOWATT </xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'DMK'">
                                    <span>
                                        <xsl:text>DESİMETRE KARE</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:when test="@unitCode  = 'SM3'">
                                    <span>
                                        <xsl:text>STANDART METREKÜP</xsl:text>
                                    </span>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:for-each>
                    </xsl:if>
                </span>
            </td>
            <td id="lineTableTd" align="right">
                <span>
                    <xsl:text>&#160;</xsl:text>
                    <xsl:value-of
                        select="format-number(./cac:Price/cbc:PriceAmount, '###.##0,########', 'european')"/>
                    <xsl:if test="./cac:Price/cbc:PriceAmount/@currencyID">
                        <xsl:text> </xsl:text>
                        <xsl:if test="./cac:Price/cbc:PriceAmount/@currencyID = &quot;TRL&quot; or ./cac:Price/cbc:PriceAmount/@currencyID = &quot;TRY&quot;">
                            <xsl:text>TL</xsl:text>
                        </xsl:if>
                        <xsl:if test="./cac:Price/cbc:PriceAmount/@currencyID != &quot;TRL&quot; and ./cac:Price/cbc:PriceAmount/@currencyID != &quot;TRY&quot;">
                            <xsl:value-of select="./cac:Price/cbc:PriceAmount/@currencyID"/>
                        </xsl:if>
                    </xsl:if>
                </span>
            </td>
            <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:AllowanceCharge/cbc:MultiplierFactorNumeric &gt;0">
                <xsl:if test = "$iskontoCount &gt; 2">
                    <td id="lineTableTd" align="right"  width="75">
                        <xsl:text>&#160;</xsl:text>
                        <xsl:for-each select="./cac:AllowanceCharge/cbc:MultiplierFactorNumeric">
                            <xsl:variable name = "position" select = "position()"/>


                            <xsl:value-of select= "format-number(. * 100, '###.##0,00', 'european')"/>

                            <xsl:if test="$iskontoCount &gt; $position">
                                <xsl:text> +</xsl:text>
                            </xsl:if>

                        </xsl:for-each>

                    </td>
                </xsl:if>

                <xsl:if test = "$iskontoCount &lt; 2">
                    <td id="lineTableTd" align="right">
                        <xsl:text>&#160;</xsl:text>
                        <xsl:for-each select="./cac:AllowanceCharge/cbc:MultiplierFactorNumeric">
                            <xsl:variable name = "position" select = "position()"/>


                            <xsl:value-of select= "format-number(. * 100, '###.##0,00', 'european')"/>

                            <xsl:if test="$iskontoCount &gt; $position">
                                <xsl:text> +</xsl:text>
                            </xsl:if>

                        </xsl:for-each>

                    </td>
                </xsl:if>

                <xsl:if test = "$iskontoCount = 2">
                    <td id="lineTableTd" align="right"  width="100">
                        <xsl:text>&#160;</xsl:text>
                        <xsl:for-each select="./cac:AllowanceCharge/cbc:MultiplierFactorNumeric">
                            <xsl:variable name = "position" select = "position()"/>


                            <xsl:value-of select= "format-number(. * 100, '###.##0,00', 'european')"/>

                            <xsl:if test="$iskontoCount &gt; $position">
                                <xsl:text> +</xsl:text>
                            </xsl:if>

                        </xsl:for-each>

                    </td>
                </xsl:if>
            </xsl:if>
            <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:AllowanceCharge/cbc:Amount &gt;0">
                <td align="right">
                    <xsl:for-each select="./cac:AllowanceCharge">
                        <xsl:if test=".">
                            <xsl:value-of select="format-number(./cbc:Amount, '###.##0,00', 'european')"/>
                        </xsl:if>
                        <xsl:if test="./cbc:Amount/@currencyID">
                            <xsl:if test="./cbc:Amount/@currencyID = 'TRY'">
                                <xsl:text> TL</xsl:text>
                            </xsl:if>
                            <xsl:if test="./cbc:Amount/@currencyID != 'TRY'">
                                <xsl:value-of select="./cbc:Amount/@currencyID"/>
                            </xsl:if>
                        </xsl:if>
                        <xsl:variable name = "position" select = "position()"/>
                        <xsl:if test="$iskontoCount &gt; $position">
                            <xsl:text> +</xsl:text>
                        </xsl:if>

                    </xsl:for-each>
                </td>



            </xsl:if>

            <td id="lineTableTd" align="right">
                <span>
                    <xsl:text>&#160;</xsl:text>
                    <xsl:for-each select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
                        <xsl:if test="cbc:TaxTypeCode='0015' ">
                            <xsl:text>
                            </xsl:text>
                            <xsl:if test="../../cbc:Percent">
                                <xsl:text> %</xsl:text>
                                <xsl:value-of select="format-number(../../cbc:Percent, '###.##0,00', 'european')" />
                            </xsl:if>
                        </xsl:if>
                    </xsl:for-each>
                </span>
            </td>
            <td id="lineTableTd" align="right">
                <span>
                    <xsl:text>&#160;</xsl:text>
                    <xsl:for-each select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
                        <xsl:if test="cbc:TaxTypeCode='0015' ">
                            <xsl:text>
                            </xsl:text>
                            <xsl:value-of select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')" />
                            <xsl:if test="../../cbc:TaxAmount/@currencyID">
                                <xsl:text>
                                </xsl:text>
                                <xsl:if test="../../cbc:TaxAmount/@currencyID = 'TRY'">
                                    <xsl:text>TL</xsl:text>
                                </xsl:if>
                                <xsl:if test="../../cbc:TaxAmount/@currencyID != 'TRY'">
                                    <xsl:value-of select="../../cbc:TaxAmount/@currencyID" />
                                </xsl:if>
                            </xsl:if>
                        </xsl:if>
                    </xsl:for-each>
                </span>
            </td>
            <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode!='0015'">
                <td id="lineTableTd" style="font-size: xx-small" align="right">
                    <span>
                        <xsl:text>&#160;</xsl:text>
                        <xsl:for-each select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
                            <xsl:if test="cbc:TaxTypeCode!='0015' ">
                                <xsl:text>
                                </xsl:text>
                                <xsl:value-of select="cbc:Name" />
                                <xsl:if test="../../cbc:Percent">
                                    <xsl:text> (%</xsl:text>
                                    <xsl:value-of select="format-number(../../cbc:Percent, '###.##0,00', 'european')" />
                                    <xsl:text>)=</xsl:text>
                                </xsl:if>
                                <xsl:value-of select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')" />
                                <xsl:if test="../../cbc:TaxAmount/@currencyID">
                                    <xsl:text>
                                    </xsl:text>
                                    <xsl:if test="../../cbc:TaxAmount/@currencyID = 'TRY'">
                                        <xsl:text>TL</xsl:text>
                                    </xsl:if>
                                    <xsl:if test="../../cbc:TaxAmount/@currencyID != 'TRY'">
                                        <xsl:value-of select="../../cbc:TaxAmount/@currencyID" />
                                    </xsl:if>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                        <xsl:for-each
                        select="./cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
                            <xsl:text>KDV TEVKİFAT </xsl:text>
                            <xsl:if test="../../cbc:Percent">
                                <xsl:text> (%</xsl:text>
                                <xsl:value-of
                                    select="format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
                                <xsl:text>)=</xsl:text>
                            </xsl:if>
                            <xsl:value-of
                                select="format-number(../../cbc:TaxAmount, '###.##0,00', 'european')"/>
                            <xsl:if test="../../cbc:TaxAmount/@currencyID">
                                <xsl:text> </xsl:text>
                                <xsl:if test="../../cbc:TaxAmount/@currencyID = 'TRL' or ../../cbc:TaxAmount/@currencyID = 'TRY'">
                                    <xsl:text>TL</xsl:text>
                                    <xsl:text>&#10;</xsl:text>
                                </xsl:if>
                                <xsl:if test="../../cbc:TaxAmount/@currencyID != 'TRL' and ../../cbc:TaxAmount/@currencyID != 'TRY'">
                                    <xsl:value-of select="../../cbc:TaxAmount/@currencyID"/>
                                    <xsl:text>&#10;</xsl:text>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </span>
                </td>
            </xsl:if>
            <td id="lineTableTd" align="right">
                <span>
                    <xsl:text>&#160;</xsl:text>
                    <xsl:value-of select="format-number(./cbc:LineExtensionAmount, '###.##0,00', 'european')" />
                    <xsl:if test="./cbc:LineExtensionAmount/@currencyID">
                        <xsl:text>
                        </xsl:text>
                        <xsl:if test="./cbc:LineExtensionAmount/@currencyID = 'TRY' ">
                            <xsl:text>TL</xsl:text>
                        </xsl:if>
                        <xsl:if test="./cbc:LineExtensionAmount/@currencyID != 'TRY' ">
                            <xsl:value-of select="./cbc:LineExtensionAmount/@currencyID" />
                        </xsl:if>
                    </xsl:if>
                </span>
            </td>
            <xsl:if test="//n1:Invoice/cbc:ProfileID='IHRACAT'">
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                    <xsl:for-each select="cac:Delivery/cac:DeliveryTerms/cbc:ID[@schemeID='INCOTERMS']">
                        <xsl:text>&#160;</xsl:text>
                        <xsl:apply-templates/>
                    </xsl:for-each>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                    <xsl:for-each select="cac:Delivery/cac:Shipment/cac:TransportHandlingUnit/cac:ActualPackage/cbc:PackagingTypeCode">
                        <xsl:text>&#160;</xsl:text>
                        <xsl:call-template name="Packaging">
                            <xsl:with-param name="PackagingType">
                                <xsl:value-of select="."/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:for-each>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                    <xsl:for-each select="cac:Delivery/cac:Shipment/cac:TransportHandlingUnit/cac:ActualPackage/cbc:ID">
                        <xsl:text>&#160;</xsl:text>
                        <xsl:apply-templates/>
                    </xsl:for-each>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                    <xsl:for-each select="cac:Delivery/cac:Shipment/cac:TransportHandlingUnit/cac:ActualPackage/cbc:Quantity">
                        <xsl:text>&#160;</xsl:text>
                        <xsl:apply-templates/>
                    </xsl:for-each>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                    <xsl:for-each select="cac:Delivery/cac:DeliveryAddress">
                        <xsl:text>&#160;</xsl:text>
                        <xsl:apply-templates/>
                    </xsl:for-each>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                    <xsl:for-each select="cac:Delivery/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode">
                        <xsl:text>&#160;</xsl:text>
                        <xsl:call-template name="TransportMode">
                            <xsl:with-param name="TransportModeType">
                                <xsl:value-of select="."/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:for-each>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                    <xsl:for-each select="cac:Delivery/cac:Shipment/cac:GoodsItem/cbc:RequiredCustomsID">
                        <xsl:text>&#160;</xsl:text>
                        <xsl:apply-templates/>
                    </xsl:for-each>
                </td>
            </xsl:if>

        </tr>
    </xsl:template>
    <xsl:template match="//n1:Invoice">
        <tr id="lineTableTr">
            <td id="lineTableTd">
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </td>
            <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:Item/cac:SellersItemIdentification">
                <td id="lineTableTd">
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </td>
            </xsl:if>
            <td id="lineTableTd">
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </td>
            <td id="lineTableTd" align="right">
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </td>
            <td id="lineTableTd" align="right">
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </td>
            <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:AllowanceCharge/cbc:MultiplierFactorNumeric &gt;0">
                <td id="lineTableTd" align="right">
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </td>
            </xsl:if>
            <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:AllowanceCharge/cbc:Amount &gt;0">
                <td id="lineTableTd" align="right">
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </td>
            </xsl:if>
            <td id="lineTableTd" align="right">
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </td>
            <td id="lineTableTd" align="right">
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </td>
            <xsl:if test="//n1:Invoice/cac:InvoiceLine/cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode!='0015'">
                <td id="lineTableTd" align="right">
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </td>
            </xsl:if>
            <td id="lineTableTd" align="right">
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </td>
            <xsl:if test="//n1:Invoice/cbc:ProfileID='IHRACAT'">
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                </td>
                <td class="lineTableTd" align="right">
                    <xsl:text>&#160;</xsl:text>
                </td>
            </xsl:if>
        </tr>
    </xsl:template>
    <xsl:template name="Party_Title" >
        <xsl:param name="PartyType" />
        <td style="width:469px; " align="left">
            <xsl:if test="cac:PartyName">
                <xsl:value-of select="cac:PartyName/cbc:Name"/>
                <br/>
            </xsl:if>
            <xsl:for-each select="cac:Person">
                <xsl:for-each select="cbc:Title">
                    <xsl:apply-templates/>
                    <xsl:text>&#160;</xsl:text>
                </xsl:for-each>
                <xsl:for-each select="cbc:FirstName">
                    <xsl:apply-templates/>
                    <xsl:text>&#160;</xsl:text>
                </xsl:for-each>
                <xsl:for-each select="cbc:MiddleName">
                    <xsl:apply-templates/>
                    <xsl:text>&#160; </xsl:text>
                </xsl:for-each>
                <xsl:for-each select="cbc:FamilyName">
                    <xsl:apply-templates/>
                    <xsl:text>&#160;</xsl:text>
                </xsl:for-each>
                <xsl:for-each select="cbc:NameSuffix">
                    <xsl:apply-templates/>
                </xsl:for-each>
                <xsl:if test="$PartyType='TAXFREE'">
                    <br/>
                    <xsl:text>Pasaport No: </xsl:text>
                    <xsl:value-of select="cac:IdentityDocumentReference/cbc:ID"/>
                    <br/>
                    <xsl:text>Ülkesi: </xsl:text>
                    <xsl:for-each select="cbc:NationalityID">
                        <xsl:call-template name="Country">
                            <xsl:with-param name="CountryType">
                                <xsl:value-of select="."/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:for-each>
                </xsl:if>
            </xsl:for-each>
        </td>
    </xsl:template>
    <xsl:template name="Party_Adress" >
        <xsl:param name="PartyType" />
        <td style="width:469px; " align="left">
            <xsl:for-each select="cac:PostalAddress">
                <xsl:for-each select="cbc:StreetName">
                    <xsl:apply-templates/>
                    <xsl:text>&#160;</xsl:text>
                </xsl:for-each>
                <xsl:for-each select="cbc:BuildingName">
                    <xsl:apply-templates/>
                </xsl:for-each>
                <xsl:for-each select="cbc:BuildingNumber">
                    <xsl:text> No:</xsl:text>
                    <xsl:apply-templates/>
                    <xsl:text>&#160;</xsl:text>
                </xsl:for-each>
                <br/>
                <xsl:for-each select="cbc:Room">
                    <xsl:text>Kapı No:</xsl:text>
                    <xsl:apply-templates/>
                    <xsl:text>&#160;</xsl:text>
                </xsl:for-each>
                <br/>
                <xsl:for-each select="cbc:PostalZone">
                    <xsl:apply-templates/>
                    <xsl:text>&#160;</xsl:text>
                </xsl:for-each>
                <xsl:for-each select="cbc:CitySubdivisionName">
                    <xsl:apply-templates/>
                    <xsl:text>/ </xsl:text>
                </xsl:for-each>
                <xsl:for-each select="cbc:CityName">
                    <xsl:apply-templates/>
                    <xsl:text>&#160;</xsl:text>
                </xsl:for-each>
                <xsl:if test="$PartyType!='OTHER'">
                    <br/>
                    <xsl:value-of select="cac:Country/cbc:Name"/>
                    <br/>
                </xsl:if>
            </xsl:for-each>
        </td>
    </xsl:template>
    <xsl:template name="TransportMode">
        <xsl:param name="TransportModeType" />
        <xsl:choose>
            <xsl:when test="$TransportModeType=1">Denizyolu</xsl:when>
            <xsl:when test="$TransportModeType=2">Demiryolu</xsl:when>
            <xsl:when test="$TransportModeType=3">Karayolu</xsl:when>
            <xsl:when test="$TransportModeType=4">Havayolu</xsl:when>
            <xsl:when test="$TransportModeType=5">Posta</xsl:when>
            <xsl:when test="$TransportModeType=6">Çok araçlı</xsl:when>
            <xsl:when test="$TransportModeType=7">Sabit taşıma tesisleri</xsl:when>
            <xsl:when test="$TransportModeType=8">İç su taşımacılığı</xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$TransportModeType"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="Packaging">
        <xsl:param name="PackagingType" />
        <xsl:choose>
            <xsl:when test="$PackagingType='1A'">Drum, steel</xsl:when>
            <xsl:when test="$PackagingType='1B'">Drum, aluminium</xsl:when>
            <xsl:when test="$PackagingType='1D'">Drum, plywood</xsl:when>
            <xsl:when test="$PackagingType='1F'">Container, flexible</xsl:when>
            <xsl:when test="$PackagingType='1G'">Drum, fibre</xsl:when>
            <xsl:when test="$PackagingType='1W'">Drum, wooden</xsl:when>
            <xsl:when test="$PackagingType='2C'">Barrel, wooden</xsl:when>
            <xsl:when test="$PackagingType='3A'">Jerrican, steel</xsl:when>
            <xsl:when test="$PackagingType='3H'">Jerrican, plastic</xsl:when>
            <xsl:when test="$PackagingType='43'">Bag, super bulk</xsl:when>
            <xsl:when test="$PackagingType='44'">Bag, polybag</xsl:when>
            <xsl:when test="$PackagingType='4A'">Box, steel</xsl:when>
            <xsl:when test="$PackagingType='4B'">Box, aluminium</xsl:when>
            <xsl:when test="$PackagingType='4C'">Box, natural wood</xsl:when>
            <xsl:when test="$PackagingType='4D'">Box, plywood</xsl:when>
            <xsl:when test="$PackagingType='4F'">Box, reconstituted wood</xsl:when>
            <xsl:when test="$PackagingType='4G'">Box, fibreboard</xsl:when>
            <xsl:when test="$PackagingType='4H'">Box, plastic</xsl:when>
            <xsl:when test="$PackagingType='5H'">Bag, woven plastic</xsl:when>
            <xsl:when test="$PackagingType='5L'">Bag, textile</xsl:when>
            <xsl:when test="$PackagingType='5M'">Bag, paper</xsl:when>
            <xsl:when test="$PackagingType='6H'">Composite packaging, plastic receptacle</xsl:when>
            <xsl:when test="$PackagingType='6P'">Composite packaging, glass receptacle</xsl:when>
            <xsl:when test="$PackagingType='7A'">Case, car</xsl:when>
            <xsl:when test="$PackagingType='7B'">Case, wooden</xsl:when>
            <xsl:when test="$PackagingType='8A'">Pallet, wooden</xsl:when>
            <xsl:when test="$PackagingType='8B'">Crate, wooden</xsl:when>
            <xsl:when test="$PackagingType='8C'">Bundle, wooden</xsl:when>
            <xsl:when test="$PackagingType='AA'">Intermediate bulk container, rigid plastic</xsl:when>
            <xsl:when test="$PackagingType='AB'">Receptacle, fibre</xsl:when>
            <xsl:when test="$PackagingType='AC'">Receptacle, paper</xsl:when>
            <xsl:when test="$PackagingType='AD'">Receptacle, wooden</xsl:when>
            <xsl:when test="$PackagingType='AE'">Aerosol</xsl:when>
            <xsl:when test="$PackagingType='AF'">Pallet, modular, collars 80cms * 60cms</xsl:when>
            <xsl:when test="$PackagingType='AG'">Pallet, shrinkwrapped</xsl:when>
            <xsl:when test="$PackagingType='AH'">Pallet, 100cms * 110cms</xsl:when>
            <xsl:when test="$PackagingType='AI'">Clamshell</xsl:when>
            <xsl:when test="$PackagingType='AJ'">Cone</xsl:when>
            <xsl:when test="$PackagingType='AL'">Ball</xsl:when>
            <xsl:when test="$PackagingType='AM'">Ampoule, non-protected</xsl:when>
            <xsl:when test="$PackagingType='AP'">Ampoule, protected</xsl:when>
            <xsl:when test="$PackagingType='AT'">Atomizer</xsl:when>
            <xsl:when test="$PackagingType='AV'">Capsule</xsl:when>
            <xsl:when test="$PackagingType='B4'">Belt</xsl:when>
            <xsl:when test="$PackagingType='BA'">Barrel</xsl:when>
            <xsl:when test="$PackagingType='BB'">Bobbin</xsl:when>
            <xsl:when test="$PackagingType='BC'">Bottlecrate / bottlerack</xsl:when>
            <xsl:when test="$PackagingType='BD'">Board</xsl:when>
            <xsl:when test="$PackagingType='BE'">Bundle</xsl:when>
            <xsl:when test="$PackagingType='BF'">Balloon, non-protected</xsl:when>
            <xsl:when test="$PackagingType='BG'">Bag</xsl:when>
            <xsl:when test="$PackagingType='BH'">Bunch</xsl:when>
            <xsl:when test="$PackagingType='BI'">Bin</xsl:when>
            <xsl:when test="$PackagingType='BJ'">Bucket</xsl:when>
            <xsl:when test="$PackagingType='BK'">Basket</xsl:when>
            <xsl:when test="$PackagingType='BL'">Bale, compressed</xsl:when>
            <xsl:when test="$PackagingType='BM'">Basin</xsl:when>
            <xsl:when test="$PackagingType='BN'">Bale, non-compressed</xsl:when>
            <xsl:when test="$PackagingType='BO'">Bottle, non-protected, cylindrical</xsl:when>
            <xsl:when test="$PackagingType='BP'">Balloon, protected</xsl:when>
            <xsl:when test="$PackagingType='BQ'">Bottle, protected cylindrical</xsl:when>
            <xsl:when test="$PackagingType='BR'">Bar</xsl:when>
            <xsl:when test="$PackagingType='BS'">Bottle, non-protected, bulbous</xsl:when>
            <xsl:when test="$PackagingType='BT'">Bolt</xsl:when>
            <xsl:when test="$PackagingType='BU'">Butt</xsl:when>
            <xsl:when test="$PackagingType='BV'">Bottle, protected bulbous</xsl:when>
            <xsl:when test="$PackagingType='BW'">Box, for liquids</xsl:when>
            <xsl:when test="$PackagingType='BX'">Box</xsl:when>
            <xsl:when test="$PackagingType='BY'">Board, in bundle/bunch/truss</xsl:when>
            <xsl:when test="$PackagingType='BZ'">Bars, in bundle/bunch/truss</xsl:when>
            <xsl:when test="$PackagingType='CA'">Can, rectangular</xsl:when>
            <xsl:when test="$PackagingType='CB'">Crate, beer</xsl:when>
            <xsl:when test="$PackagingType='CC'">Churn</xsl:when>
            <xsl:when test="$PackagingType='CD'">Can, with handle and spout</xsl:when>
            <xsl:when test="$PackagingType='CE'">Creel</xsl:when>
            <xsl:when test="$PackagingType='CF'">Coffer</xsl:when>
            <xsl:when test="$PackagingType='CG'">Cage</xsl:when>
            <xsl:when test="$PackagingType='CH'">Chest</xsl:when>
            <xsl:when test="$PackagingType='CI'">Canister</xsl:when>
            <xsl:when test="$PackagingType='CJ'">Coffin</xsl:when>
            <xsl:when test="$PackagingType='CK'">Cask</xsl:when>
            <xsl:when test="$PackagingType='CL'">Coil</xsl:when>
            <xsl:when test="$PackagingType='CM'">Card</xsl:when>
            <xsl:when test="$PackagingType='CN'">Container, not otherwise specified as transport equipment</xsl:when>
            <xsl:when test="$PackagingType='CO'">Carboy, non-protected</xsl:when>
            <xsl:when test="$PackagingType='CP'">Carboy, protected</xsl:when>
            <xsl:when test="$PackagingType='CQ'">Cartridge</xsl:when>
            <xsl:when test="$PackagingType='CR'">Crate</xsl:when>
            <xsl:when test="$PackagingType='CS'">Case</xsl:when>
            <xsl:when test="$PackagingType='CT'">Carton</xsl:when>
            <xsl:when test="$PackagingType='CU'">Cup</xsl:when>
            <xsl:when test="$PackagingType='CV'">Cover</xsl:when>
            <xsl:when test="$PackagingType='CW'">Cage, roll</xsl:when>
            <xsl:when test="$PackagingType='CX'">Can, cylindrical</xsl:when>
            <xsl:when test="$PackagingType='CY'">Cylinder</xsl:when>
            <xsl:when test="$PackagingType='CZ'">Canvas</xsl:when>
            <xsl:when test="$PackagingType='DA'">Crate, multiple layer, plastic</xsl:when>
            <xsl:when test="$PackagingType='DB'">Crate, multiple layer, wooden</xsl:when>
            <xsl:when test="$PackagingType='DC'">Crate, multiple layer, cardboard</xsl:when>
            <xsl:when test="$PackagingType='DG'">Cage, Commonwealth Handling Equipment Pool (CHEP)</xsl:when>
            <xsl:when test="$PackagingType='DH'">Box, Commonwealth Handling Equipment Pool (CHEP), Eurobox</xsl:when>
            <xsl:when test="$PackagingType='DI'">Drum, iron</xsl:when>
            <xsl:when test="$PackagingType='DJ'">Demijohn, non-protected</xsl:when>
            <xsl:when test="$PackagingType='DK'">Crate, bulk, cardboard</xsl:when>
            <xsl:when test="$PackagingType='DL'">Crate, bulk, plastic</xsl:when>
            <xsl:when test="$PackagingType='DM'">Crate, bulk, wooden</xsl:when>
            <xsl:when test="$PackagingType='DN'">Dispenser</xsl:when>
            <xsl:when test="$PackagingType='DP'">Demijohn, protected</xsl:when>
            <xsl:when test="$PackagingType='DR'">Drum</xsl:when>
            <xsl:when test="$PackagingType='DS'">Tray, one layer no cover, plastic</xsl:when>
            <xsl:when test="$PackagingType='DT'">Tray, one layer no cover, wooden</xsl:when>
            <xsl:when test="$PackagingType='DU'">Tray, one layer no cover, polystyrene</xsl:when>
            <xsl:when test="$PackagingType='DV'">Tray, one layer no cover, cardboard</xsl:when>
            <xsl:when test="$PackagingType='DW'">Tray, two layers no cover, plastic tray</xsl:when>
            <xsl:when test="$PackagingType='DX'">Tray, two layers no cover, wooden</xsl:when>
            <xsl:when test="$PackagingType='DY'">Tray, two layers no cover, cardboard</xsl:when>
            <xsl:when test="$PackagingType='EC'">Bag, plastic</xsl:when>
            <xsl:when test="$PackagingType='ED'">Case, with pallet base</xsl:when>
            <xsl:when test="$PackagingType='EE'">Case, with pallet base, wooden</xsl:when>
            <xsl:when test="$PackagingType='EF'">Case, with pallet base, cardboard</xsl:when>
            <xsl:when test="$PackagingType='EG'">Case, with pallet base, plastic</xsl:when>
            <xsl:when test="$PackagingType='EH'">Case, with pallet base, metal</xsl:when>
            <xsl:when test="$PackagingType='EI'">Case, isothermic</xsl:when>
            <xsl:when test="$PackagingType='EN'">Envelope</xsl:when>
            <xsl:when test="$PackagingType='FB'">Flexibag</xsl:when>
            <xsl:when test="$PackagingType='FC'">Crate, fruit</xsl:when>
            <xsl:when test="$PackagingType='FD'">Crate, framed</xsl:when>
            <xsl:when test="$PackagingType='FE'">Flexitank</xsl:when>
            <xsl:when test="$PackagingType='FI'">Firkin</xsl:when>
            <xsl:when test="$PackagingType='FL'">Flask</xsl:when>
            <xsl:when test="$PackagingType='FO'">Footlocker</xsl:when>
            <xsl:when test="$PackagingType='FP'">Filmpack</xsl:when>
            <xsl:when test="$PackagingType='FR'">Frame</xsl:when>
            <xsl:when test="$PackagingType='FT'">Foodtainer</xsl:when>
            <xsl:when test="$PackagingType='FW'">Cart, flatbed</xsl:when>
            <xsl:when test="$PackagingType='FX'">Bag, flexible container</xsl:when>
            <xsl:when test="$PackagingType='GB'">Bottle, gas</xsl:when>
            <xsl:when test="$PackagingType='GI'">Girder</xsl:when>
            <xsl:when test="$PackagingType='GL'">Container, gallon</xsl:when>
            <xsl:when test="$PackagingType='GR'">Receptacle, glass</xsl:when>
            <xsl:when test="$PackagingType='GU'">Tray, containing horizontally stacked flat items</xsl:when>
            <xsl:when test="$PackagingType='GY'">Bag, gunny</xsl:when>
            <xsl:when test="$PackagingType='GZ'">Girders, in bundle/bunch/truss</xsl:when>
            <xsl:when test="$PackagingType='HA'">Basket, with handle, plastic</xsl:when>
            <xsl:when test="$PackagingType='HB'">Basket, with handle, wooden</xsl:when>
            <xsl:when test="$PackagingType='HC'">Basket, with handle, cardboard</xsl:when>
            <xsl:when test="$PackagingType='HG'">Hogshead</xsl:when>
            <xsl:when test="$PackagingType='HN'">Hanger</xsl:when>
            <xsl:when test="$PackagingType='HR'">Hamper</xsl:when>
            <xsl:when test="$PackagingType='IA'">Package, display, wooden</xsl:when>
            <xsl:when test="$PackagingType='IB'">Package, display, cardboard</xsl:when>
            <xsl:when test="$PackagingType='IC'">Package, display, plastic</xsl:when>
            <xsl:when test="$PackagingType='ID'">Package, display, metal</xsl:when>
            <xsl:when test="$PackagingType='IE'">Package, show</xsl:when>
            <xsl:when test="$PackagingType='IF'">Package, flow</xsl:when>
            <xsl:when test="$PackagingType='IG'">Package, paper wrapped</xsl:when>
            <xsl:when test="$PackagingType='IH'">Drum, plastic</xsl:when>
            <xsl:when test="$PackagingType='IK'">Package, cardboard, with bottle grip-holes</xsl:when>
            <xsl:when test="$PackagingType='IL'">Tray, rigid, lidded stackable (CEN TS 14482:2002)</xsl:when>
            <xsl:when test="$PackagingType='IN'">Ingot</xsl:when>
            <xsl:when test="$PackagingType='IZ'">Ingots, in bundle/bunch/truss</xsl:when>
            <xsl:when test="$PackagingType='JB'">Bag, jumbo</xsl:when>
            <xsl:when test="$PackagingType='JC'">Jerrican, rectangular</xsl:when>
            <xsl:when test="$PackagingType='JG'">Jug</xsl:when>
            <xsl:when test="$PackagingType='JR'">Jar</xsl:when>
            <xsl:when test="$PackagingType='JT'">Jutebag</xsl:when>
            <xsl:when test="$PackagingType='JY'">Jerrican, cylindrical</xsl:when>
            <xsl:when test="$PackagingType='KG'">Keg</xsl:when>
            <xsl:when test="$PackagingType='KI'">Kit</xsl:when>
            <xsl:when test="$PackagingType='LE'">Luggage</xsl:when>
            <xsl:when test="$PackagingType='LG'">Log</xsl:when>
            <xsl:when test="$PackagingType='LT'">Lot</xsl:when>
            <xsl:when test="$PackagingType='LU'">Lug</xsl:when>
            <xsl:when test="$PackagingType='LV'">Liftvan</xsl:when>
            <xsl:when test="$PackagingType='LZ'">Logs, in bundle/bunch/truss</xsl:when>
            <xsl:when test="$PackagingType='MA'">Crate, metal</xsl:when>
            <xsl:when test="$PackagingType='MB'">Bag, multiply</xsl:when>
            <xsl:when test="$PackagingType='MC'">Crate, milk</xsl:when>
            <xsl:when test="$PackagingType='ME'">Container, metal</xsl:when>
            <xsl:when test="$PackagingType='MR'">Receptacle, metal</xsl:when>
            <xsl:when test="$PackagingType='MS'">Sack, multi-wall</xsl:when>
            <xsl:when test="$PackagingType='MT'">Mat</xsl:when>
            <xsl:when test="$PackagingType='MW'">Receptacle, plastic wrapped</xsl:when>
            <xsl:when test="$PackagingType='MX'">Matchbox</xsl:when>
            <xsl:when test="$PackagingType='NA'">Not available</xsl:when>
            <xsl:when test="$PackagingType='NE'">Unpacked or unpackaged</xsl:when>
            <xsl:when test="$PackagingType='NF'">Unpacked or unpackaged, single unit</xsl:when>
            <xsl:when test="$PackagingType='NG'">Unpacked or unpackaged, multiple units</xsl:when>
            <xsl:when test="$PackagingType='NS'">Nest</xsl:when>
            <xsl:when test="$PackagingType='NT'">Net</xsl:when>
            <xsl:when test="$PackagingType='NU'">Net, tube, plastic</xsl:when>
            <xsl:when test="$PackagingType='NV'">Net, tube, textile</xsl:when>
            <xsl:when test="$PackagingType='OA'">Pallet, CHEP 40 cm x 60 cm</xsl:when>
            <xsl:when test="$PackagingType='OB'">Pallet, CHEP 80 cm x 120 cm</xsl:when>
            <xsl:when test="$PackagingType='OC'">Pallet, CHEP 100 cm x 120 cm</xsl:when>
            <xsl:when test="$PackagingType='OD'">Pallet, AS 4068-1993</xsl:when>
            <xsl:when test="$PackagingType='OE'">Pallet, ISO T11</xsl:when>
            <xsl:when test="$PackagingType='OF'">Platform, unspecified weight or dimension</xsl:when>
            <xsl:when test="$PackagingType='OK'">Block</xsl:when>
            <xsl:when test="$PackagingType='OT'">Octabin</xsl:when>
            <xsl:when test="$PackagingType='OU'">Container, outer</xsl:when>
            <xsl:when test="$PackagingType='P2'">Pan</xsl:when>
            <xsl:when test="$PackagingType='PA'">Packet</xsl:when>
            <xsl:when test="$PackagingType='PB'">Pallet, box Combined open-ended box and pallet</xsl:when>
            <xsl:when test="$PackagingType='PC'">Parcel</xsl:when>
            <xsl:when test="$PackagingType='PD'">Pallet, modular, collars 80cms * 100cms</xsl:when>
            <xsl:when test="$PackagingType='PE'">Pallet, modular, collars 80cms * 120cms</xsl:when>
            <xsl:when test="$PackagingType='PF'">Pen</xsl:when>
            <xsl:when test="$PackagingType='PG'">Plate</xsl:when>
            <xsl:when test="$PackagingType='PH'">Pitcher</xsl:when>
            <xsl:when test="$PackagingType='PI'">Pipe</xsl:when>
            <xsl:when test="$PackagingType='PJ'">Punnet</xsl:when>
            <xsl:when test="$PackagingType='PK'">Package</xsl:when>
            <xsl:when test="$PackagingType='PL'">Pail</xsl:when>
            <xsl:when test="$PackagingType='PN'">Plank</xsl:when>
            <xsl:when test="$PackagingType='PO'">Pouch</xsl:when>
            <xsl:when test="$PackagingType='PP'">Piece</xsl:when>
            <xsl:when test="$PackagingType='PR'">Receptacle, plastic</xsl:when>
            <xsl:when test="$PackagingType='PT'">Pot</xsl:when>
            <xsl:when test="$PackagingType='PU'">Tray</xsl:when>
            <xsl:when test="$PackagingType='PV'">Pipes, in bundle/bunch/truss</xsl:when>
            <xsl:when test="$PackagingType='PX'">Pallet</xsl:when>
            <xsl:when test="$PackagingType='PY'">Plates, in bundle/bunch/truss</xsl:when>
            <xsl:when test="$PackagingType='PZ'">Planks, in bundle/bunch/truss</xsl:when>
            <xsl:when test="$PackagingType='QA'">Drum, steel, non-removable head</xsl:when>
            <xsl:when test="$PackagingType='QB'">Drum, steel, removable head</xsl:when>
            <xsl:when test="$PackagingType='QC'">Drum, aluminium, non-removable head</xsl:when>
            <xsl:when test="$PackagingType='QD'">Drum, aluminium, removable head</xsl:when>
            <xsl:when test="$PackagingType='QF'">Drum, plastic, non-removable head</xsl:when>
            <xsl:when test="$PackagingType='QG'">Drum, plastic, removable head</xsl:when>
            <xsl:when test="$PackagingType='QH'">Barrel, wooden, bung type</xsl:when>
            <xsl:when test="$PackagingType='QJ'">Barrel, wooden, removable head</xsl:when>
            <xsl:when test="$PackagingType='QK'">Jerrican, steel, non-removable head</xsl:when>
            <xsl:when test="$PackagingType='QL'">Jerrican, steel, removable head</xsl:when>
            <xsl:when test="$PackagingType='QM'">Jerrican, plastic, non-removable head</xsl:when>
            <xsl:when test="$PackagingType='QN'">Jerrican, plastic, removable head</xsl:when>
            <xsl:when test="$PackagingType='QP'">Box, wooden, natural wood, ordinary</xsl:when>
            <xsl:when test="$PackagingType='QQ'">Box, wooden, natural wood, with sift proof walls</xsl:when>
            <xsl:when test="$PackagingType='QR'">Box, plastic, expanded</xsl:when>
            <xsl:when test="$PackagingType='QS'">Box, plastic, solid</xsl:when>
            <xsl:when test="$PackagingType='RD'">Rod</xsl:when>
            <xsl:when test="$PackagingType='RG'">Ring</xsl:when>
            <xsl:when test="$PackagingType='RJ'">Rack, clothing hanger</xsl:when>
            <xsl:when test="$PackagingType='RK'">Rack</xsl:when>
            <xsl:when test="$PackagingType='RL'">Reel</xsl:when>
            <xsl:when test="$PackagingType='RO'">Roll</xsl:when>
            <xsl:when test="$PackagingType='RT'">Rednet</xsl:when>
            <xsl:when test="$PackagingType='RZ'">Rods, in bundle/bunch/truss</xsl:when>
            <xsl:when test="$PackagingType='SA'">Sack</xsl:when>
            <xsl:when test="$PackagingType='SB'">Slab</xsl:when>
            <xsl:when test="$PackagingType='SC'">Crate, shallow</xsl:when>
            <xsl:when test="$PackagingType='SD'">Spindle</xsl:when>
            <xsl:when test="$PackagingType='SE'">Sea-chest</xsl:when>
            <xsl:when test="$PackagingType='SH'">Sachet</xsl:when>
            <xsl:when test="$PackagingType='SI'">Skid</xsl:when>
            <xsl:when test="$PackagingType='SK'">Case, skeleton</xsl:when>
            <xsl:when test="$PackagingType='SL'">Slipsheet</xsl:when>
            <xsl:when test="$PackagingType='SM'">Sheetmetal</xsl:when>
            <xsl:when test="$PackagingType='SO'">Spool</xsl:when>
            <xsl:when test="$PackagingType='SP'">Sheet, plastic wrapping</xsl:when>
            <xsl:when test="$PackagingType='SS'">Case, steel</xsl:when>
            <xsl:when test="$PackagingType='ST'">Sheet</xsl:when>
            <xsl:when test="$PackagingType='SU'">Suitcase</xsl:when>
            <xsl:when test="$PackagingType='SV'">Envelope, steel</xsl:when>
            <xsl:when test="$PackagingType='SW'">Shrinkwrapped</xsl:when>
            <xsl:when test="$PackagingType='SX'">Set</xsl:when>
            <xsl:when test="$PackagingType='SY'">Sleeve</xsl:when>
            <xsl:when test="$PackagingType='SZ'">Sheets, in bundle/bunch/truss</xsl:when>
            <xsl:when test="$PackagingType='T1'">Tablet</xsl:when>
            <xsl:when test="$PackagingType='TB'">Tub</xsl:when>
            <xsl:when test="$PackagingType='TC'">Tea-chest</xsl:when>
            <xsl:when test="$PackagingType='TD'">Tube, collapsible</xsl:when>
            <xsl:when test="$PackagingType='TE'">Tyre</xsl:when>
            <xsl:when test="$PackagingType='TG'">Tank container, generic</xsl:when>
            <xsl:when test="$PackagingType='TI'">Tierce</xsl:when>
            <xsl:when test="$PackagingType='TK'">Tank, rectangular</xsl:when>
            <xsl:when test="$PackagingType='TL'">Tub, with lid</xsl:when>
            <xsl:when test="$PackagingType='TN'">Tin</xsl:when>
            <xsl:when test="$PackagingType='TO'">Tun</xsl:when>
            <xsl:when test="$PackagingType='TR'">Trunk</xsl:when>
            <xsl:when test="$PackagingType='TS'">Truss</xsl:when>
            <xsl:when test="$PackagingType='TT'">Bag, tote</xsl:when>
            <xsl:when test="$PackagingType='TU'">Tube</xsl:when>
            <xsl:when test="$PackagingType='TV'">Tube, with nozzle</xsl:when>
            <xsl:when test="$PackagingType='TW'">Pallet, triwall</xsl:when>
            <xsl:when test="$PackagingType='TY'">Tank, cylindrical</xsl:when>
            <xsl:when test="$PackagingType='TZ'">Tubes, in bundle/bunch/truss</xsl:when>
            <xsl:when test="$PackagingType='UC'">Uncaged</xsl:when>
            <xsl:when test="$PackagingType='UN'">Unit</xsl:when>
            <xsl:when test="$PackagingType='VA'">Vat</xsl:when>
            <xsl:when test="$PackagingType='VG'">Bulk, gas (at 1031 mbar and 15Â°C)</xsl:when>
            <xsl:when test="$PackagingType='VI'">Vial</xsl:when>
            <xsl:when test="$PackagingType='VK'">Vanpack</xsl:when>
            <xsl:when test="$PackagingType='VL'">Bulk, liquid</xsl:when>
            <xsl:when test="$PackagingType='VO'">Bulk, solid, large particles (Â“nodulesÂ”)</xsl:when>
            <xsl:when test="$PackagingType='VP'">Vacuum-packed</xsl:when>
            <xsl:when test="$PackagingType='VQ'">Bulk, liquefied gas (at abnormal temperature/pressure)</xsl:when>
            <xsl:when test="$PackagingType='VN'">Vehicle</xsl:when>
            <xsl:when test="$PackagingType='VR'">Bulk, solid, granular particles (Â“grainsÂ”)</xsl:when>
            <xsl:when test="$PackagingType='VS'">Bulk, scrap metal</xsl:when>
            <xsl:when test="$PackagingType='VY'">Bulk, solid, fine particles (Â“powdersÂ”)</xsl:when>
            <xsl:when test="$PackagingType='WA'">Intermediate bulk container</xsl:when>
            <xsl:when test="$PackagingType='WB'">Wickerbottle</xsl:when>
            <xsl:when test="$PackagingType='WC'">Intermediate bulk container, steel</xsl:when>
            <xsl:when test="$PackagingType='WD'">Intermediate bulk container, aluminium</xsl:when>
            <xsl:when test="$PackagingType='WF'">Intermediate bulk container, metal</xsl:when>
            <xsl:when test="$PackagingType='WG'">Intermediate bulk container, steel, pressurised > 10 kpa</xsl:when>
            <xsl:when test="$PackagingType='WH'">Intermediate bulk container, aluminium, pressurised > 10 kpa</xsl:when>
            <xsl:when test="$PackagingType='WJ'">Intermediate bulk container, metal, pressure 10 kpa</xsl:when>
            <xsl:when test="$PackagingType='WK'">Intermediate bulk container, steel, liquid</xsl:when>
            <xsl:when test="$PackagingType='WL'">Intermediate bulk container, aluminium, liquid</xsl:when>
            <xsl:when test="$PackagingType='WM'">Intermediate bulk container, metal, liquid</xsl:when>
            <xsl:when test="$PackagingType='WN'">Intermediate bulk container, woven plastic, without coat/liner</xsl:when>
            <xsl:when test="$PackagingType='WP'">Intermediate bulk container, woven plastic, coated</xsl:when>
            <xsl:when test="$PackagingType='WQ'">Intermediate bulk container, woven plastic, with liner</xsl:when>
            <xsl:when test="$PackagingType='WR'">Intermediate bulk container, woven plastic, coated and liner</xsl:when>
            <xsl:when test="$PackagingType='WS'">Intermediate bulk container, plastic film</xsl:when>
            <xsl:when test="$PackagingType='WT'">Intermediate bulk container, textile with out coat/liner</xsl:when>
            <xsl:when test="$PackagingType='WU'">Intermediate bulk container, natural wood, with inner liner</xsl:when>
            <xsl:when test="$PackagingType='WV'">Intermediate bulk container, textile, coated</xsl:when>
            <xsl:when test="$PackagingType='WW'">Intermediate bulk container, textile, with liner</xsl:when>
            <xsl:when test="$PackagingType='WX'">Intermediate bulk container, textile, coated and liner</xsl:when>
            <xsl:when test="$PackagingType='WY'">Intermediate bulk container, plywood, with inner liner</xsl:when>
            <xsl:when test="$PackagingType='WZ'">Intermediate bulk container, reconstituted wood, with inner liner</xsl:when>
            <xsl:when test="$PackagingType='XA'">Bag, woven plastic, without inner coat/liner</xsl:when>
            <xsl:when test="$PackagingType='XB'">Bag, woven plastic, sift proof</xsl:when>
            <xsl:when test="$PackagingType='XC'">Bag, woven plastic, water resistant</xsl:when>
            <xsl:when test="$PackagingType='XD'">Bag, plastics film</xsl:when>
            <xsl:when test="$PackagingType='XF'">Bag, textile, without inner coat/liner</xsl:when>
            <xsl:when test="$PackagingType='XG'">Bag, textile, sift proof</xsl:when>
            <xsl:when test="$PackagingType='XH'">Bag, textile, water resistant</xsl:when>
            <xsl:when test="$PackagingType='XJ'">Bag, paper, multi-wall</xsl:when>
            <xsl:when test="$PackagingType='XK'">Bag, paper, multi-wall, water resistant</xsl:when>
            <xsl:when test="$PackagingType='YA'">Composite packaging, plastic receptacle in steel drum</xsl:when>
            <xsl:when test="$PackagingType='YB'">Composite packaging, plastic receptacle in steel crate box</xsl:when>
            <xsl:when test="$PackagingType='YC'">Composite packaging, plastic receptacle in aluminium drum</xsl:when>
            <xsl:when test="$PackagingType='YD'">Composite packaging, plastic receptacle in aluminium crate</xsl:when>
            <xsl:when test="$PackagingType='YF'">Composite packaging, plastic receptacle in wooden box</xsl:when>
            <xsl:when test="$PackagingType='YG'">Composite packaging, plastic receptacle in plywood drum</xsl:when>
            <xsl:when test="$PackagingType='YH'">Composite packaging, plastic receptacle in plywood box</xsl:when>
            <xsl:when test="$PackagingType='YJ'">Composite packaging, plastic receptacle in fibre drum</xsl:when>
            <xsl:when test="$PackagingType='YK'">Composite packaging, plastic receptacle in fibreboard box</xsl:when>
            <xsl:when test="$PackagingType='YL'">Composite packaging, plastic receptacle in plastic drum</xsl:when>
            <xsl:when test="$PackagingType='YM'">Composite packaging, plastic receptacle in solid plastic box</xsl:when>
            <xsl:when test="$PackagingType='YN'">Composite packaging, glass receptacle in steel drum</xsl:when>
            <xsl:when test="$PackagingType='YP'">Composite packaging, glass receptacle in steel crate box</xsl:when>
            <xsl:when test="$PackagingType='YQ'">Composite packaging, glass receptacle in aluminium drum</xsl:when>
            <xsl:when test="$PackagingType='YR'">Composite packaging, glass receptacle in aluminium crate</xsl:when>
            <xsl:when test="$PackagingType='YS'">Composite packaging, glass receptacle in wooden box</xsl:when>
            <xsl:when test="$PackagingType='YT'">Composite packaging, glass receptacle in plywood drum</xsl:when>
            <xsl:when test="$PackagingType='YV'">Composite packaging, glass receptacle in wickerwork hamper</xsl:when>
            <xsl:when test="$PackagingType='YW'">Composite packaging, glass receptacle in fibre drum</xsl:when>
            <xsl:when test="$PackagingType='YX'">Composite packaging, glass receptacle in fibreboard box</xsl:when>
            <xsl:when test="$PackagingType='YY'">Composite packaging, glass receptacle in expandable plastic pack</xsl:when>
            <xsl:when test="$PackagingType='YZ'">Composite packaging, glass receptacle in solid plastic pack</xsl:when>
            <xsl:when test="$PackagingType='ZA'">Intermediate bulk container, paper, multi-wall</xsl:when>
            <xsl:when test="$PackagingType='ZB'">Bag, large</xsl:when>
            <xsl:when test="$PackagingType='ZC'">Intermediate bulk container, paper, multi-wall, water resistant</xsl:when>
            <xsl:when test="$PackagingType='ZD'">Intermediate bulk container, rigid plastic, with structural equipment, solids</xsl:when>
            <xsl:when test="$PackagingType='ZF'">Intermediate bulk container, rigid plastic, freestanding, solids</xsl:when>
            <xsl:when test="$PackagingType='ZG'">Intermediate bulk container, rigid plastic, with structural equipment, pressurised</xsl:when>
            <xsl:when test="$PackagingType='ZH'">Intermediate bulk container, rigid plastic, freestanding, pressurised</xsl:when>
            <xsl:when test="$PackagingType='ZJ'">Intermediate bulk container, rigid plastic, with structural equipment, liquids</xsl:when>
            <xsl:when test="$PackagingType='ZK'">Intermediate bulk container, rigid plastic, freestanding, liquids</xsl:when>
            <xsl:when test="$PackagingType='ZL'">Intermediate bulk container, composite, rigid plastic, solids</xsl:when>
            <xsl:when test="$PackagingType='ZM'">Intermediate bulk container, composite, flexible plastic, solids</xsl:when>
            <xsl:when test="$PackagingType='ZN'">Intermediate bulk container, composite, rigid plastic, pressurised</xsl:when>
            <xsl:when test="$PackagingType='ZP'">Intermediate bulk container, composite, flexible plastic, pressurised</xsl:when>
            <xsl:when test="$PackagingType='ZQ'">Intermediate bulk container, composite, rigid plastic, liquids</xsl:when>
            <xsl:when test="$PackagingType='ZR'">Intermediate bulk container, composite, flexible plastic, liquids</xsl:when>
            <xsl:when test="$PackagingType='ZS'">Intermediate bulk container, composite</xsl:when>
            <xsl:when test="$PackagingType='ZT'">Intermediate bulk container, fibreboard</xsl:when>
            <xsl:when test="$PackagingType='ZU'">Intermediate bulk container, flexible</xsl:when>
            <xsl:when test="$PackagingType='ZV'">Intermediate bulk container, metal, other than steel</xsl:when>
            <xsl:when test="$PackagingType='ZW'">Intermediate bulk container, natural wood</xsl:when>
            <xsl:when test="$PackagingType='ZX'">Intermediate bulk container, plywood</xsl:when>
            <xsl:when test="$PackagingType='ZY'">Intermediate bulk container, reconstituted wood</xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$PackagingType"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="Country">
        <xsl:param name="CountryType" />
        <xsl:choose>
            <xsl:when test="$CountryType='AF'">Afganistan</xsl:when>
            <xsl:when test="$CountryType='DE'">Almanya</xsl:when>
            <xsl:when test="$CountryType='AD'">Andorra</xsl:when>
            <xsl:when test="$CountryType='AO'">Angola</xsl:when>
            <xsl:when test="$CountryType='AG'">Antigua ve Barbuda</xsl:when>
            <xsl:when test="$CountryType='AR'">Arjantin</xsl:when>
            <xsl:when test="$CountryType='AL'">Arnavutluk</xsl:when>
            <xsl:when test="$CountryType='AW'">Aruba</xsl:when>
            <xsl:when test="$CountryType='AU'">Avustralya</xsl:when>
            <xsl:when test="$CountryType='AT'">Avusturya</xsl:when>
            <xsl:when test="$CountryType='AZ'">Azerbaycan</xsl:when>
            <xsl:when test="$CountryType='BS'">Bahamalar</xsl:when>
            <xsl:when test="$CountryType='BH'">Bahreyn</xsl:when>
            <xsl:when test="$CountryType='BD'">Bangladeş</xsl:when>
            <xsl:when test="$CountryType='BB'">Barbados</xsl:when>
            <xsl:when test="$CountryType='EH'">Batı Sahra (MA)</xsl:when>
            <xsl:when test="$CountryType='BE'">Belçika</xsl:when>
            <xsl:when test="$CountryType='BZ'">Belize</xsl:when>
            <xsl:when test="$CountryType='BJ'">Benin</xsl:when>
            <xsl:when test="$CountryType='BM'">Bermuda</xsl:when>
            <xsl:when test="$CountryType='BY'">Beyaz Rusya</xsl:when>
            <xsl:when test="$CountryType='BT'">Bhutan</xsl:when>
            <xsl:when test="$CountryType='AE'">Birleşik Arap Emirlikleri</xsl:when>
            <xsl:when test="$CountryType='US'">Birleşik Devletler</xsl:when>
            <xsl:when test="$CountryType='GB'">Birleşik Krallık</xsl:when>
            <xsl:when test="$CountryType='BO'">Bolivya</xsl:when>
            <xsl:when test="$CountryType='BA'">Bosna-Hersek</xsl:when>
            <xsl:when test="$CountryType='BW'">Botsvana</xsl:when>
            <xsl:when test="$CountryType='BR'">Brezilya</xsl:when>
            <xsl:when test="$CountryType='BN'">Bruney</xsl:when>
            <xsl:when test="$CountryType='BG'">Bulgaristan</xsl:when>
            <xsl:when test="$CountryType='BF'">Burkina Faso</xsl:when>
            <xsl:when test="$CountryType='BI'">Burundi</xsl:when>
            <xsl:when test="$CountryType='TD'">Çad</xsl:when>
            <xsl:when test="$CountryType='KY'">Cayman Adaları</xsl:when>
            <xsl:when test="$CountryType='GI'">Cebelitarık (GB)</xsl:when>
            <xsl:when test="$CountryType='CZ'">Çek Cumhuriyeti</xsl:when>
            <xsl:when test="$CountryType='DZ'">Cezayir</xsl:when>
            <xsl:when test="$CountryType='DJ'">Cibuti</xsl:when>
            <xsl:when test="$CountryType='CN'">Çin</xsl:when>
            <xsl:when test="$CountryType='DK'">Danimarka</xsl:when>
            <xsl:when test="$CountryType='CD'">Demokratik Kongo Cumhuriyeti</xsl:when>
            <xsl:when test="$CountryType='TL'">Doğu Timor</xsl:when>
            <xsl:when test="$CountryType='DO'">Dominik Cumhuriyeti</xsl:when>
            <xsl:when test="$CountryType='DM'">Dominika</xsl:when>
            <xsl:when test="$CountryType='EC'">Ekvador</xsl:when>
            <xsl:when test="$CountryType='GQ'">Ekvator Ginesi</xsl:when>
            <xsl:when test="$CountryType='SV'">El Salvador</xsl:when>
            <xsl:when test="$CountryType='ID'">Endonezya</xsl:when>
            <xsl:when test="$CountryType='ER'">Eritre</xsl:when>
            <xsl:when test="$CountryType='AM'">Ermenistan</xsl:when>
            <xsl:when test="$CountryType='MF'">Ermiş Martin (FR)</xsl:when>
            <xsl:when test="$CountryType='EE'">Estonya</xsl:when>
            <xsl:when test="$CountryType='ET'">Etiyopya</xsl:when>
            <xsl:when test="$CountryType='FK'">Falkland Adaları</xsl:when>
            <xsl:when test="$CountryType='FO'">Faroe Adaları (DK)</xsl:when>
            <xsl:when test="$CountryType='MA'">Fas</xsl:when>
            <xsl:when test="$CountryType='FJ'">Fiji</xsl:when>
            <xsl:when test="$CountryType='CI'">Fildişi Sahili</xsl:when>
            <xsl:when test="$CountryType='PH'">Filipinler</xsl:when>
            <xsl:when test="$CountryType='FI'">Finlandiya</xsl:when>
            <xsl:when test="$CountryType='FR'">Fransa</xsl:when>
            <xsl:when test="$CountryType='GF'">Fransız Guyanası (FR)</xsl:when>
            <xsl:when test="$CountryType='PF'">Fransız Polinezyası (FR)</xsl:when>
            <xsl:when test="$CountryType='GA'">Gabon</xsl:when>
            <xsl:when test="$CountryType='GM'">Gambiya</xsl:when>
            <xsl:when test="$CountryType='GH'">Gana</xsl:when>
            <xsl:when test="$CountryType='GN'">Gine</xsl:when>
            <xsl:when test="$CountryType='GW'">Gine Bissau</xsl:when>
            <xsl:when test="$CountryType='GD'">Grenada</xsl:when>
            <xsl:when test="$CountryType='GL'">Grönland (DK)</xsl:when>
            <xsl:when test="$CountryType='GP'">Guadeloupe (FR)</xsl:when>
            <xsl:when test="$CountryType='GT'">Guatemala</xsl:when>
            <xsl:when test="$CountryType='GG'">Guernsey (GB)</xsl:when>
            <xsl:when test="$CountryType='ZA'">Güney Afrika</xsl:when>
            <xsl:when test="$CountryType='KR'">Güney Kore</xsl:when>
            <xsl:when test="$CountryType='GE'">Gürcistan</xsl:when>
            <xsl:when test="$CountryType='GY'">Guyana</xsl:when>
            <xsl:when test="$CountryType='HT'">Haiti</xsl:when>
            <xsl:when test="$CountryType='IN'">Hindistan</xsl:when>
            <xsl:when test="$CountryType='HR'">Hırvatistan</xsl:when>
            <xsl:when test="$CountryType='NL'">Hollanda</xsl:when>
            <xsl:when test="$CountryType='HN'">Honduras</xsl:when>
            <xsl:when test="$CountryType='HK'">Hong Kong (CN)</xsl:when>
            <xsl:when test="$CountryType='VG'">İngiliz Virjin Adaları</xsl:when>
            <xsl:when test="$CountryType='IQ'">Irak</xsl:when>
            <xsl:when test="$CountryType='IR'">İran</xsl:when>
            <xsl:when test="$CountryType='IE'">İrlanda</xsl:when>
            <xsl:when test="$CountryType='ES'">İspanya</xsl:when>
            <xsl:when test="$CountryType='IL'">İsrail</xsl:when>
            <xsl:when test="$CountryType='SE'">İsveç</xsl:when>
            <xsl:when test="$CountryType='CH'">İsviçre</xsl:when>
            <xsl:when test="$CountryType='IT'">İtalya</xsl:when>
            <xsl:when test="$CountryType='IS'">İzlanda</xsl:when>
            <xsl:when test="$CountryType='JM'">Jamaika</xsl:when>
            <xsl:when test="$CountryType='JP'">Japonya</xsl:when>
            <xsl:when test="$CountryType='JE'">Jersey (GB)</xsl:when>
            <xsl:when test="$CountryType='KH'">Kamboçya</xsl:when>
            <xsl:when test="$CountryType='CM'">Kamerun</xsl:when>
            <xsl:when test="$CountryType='CA'">Kanada</xsl:when>
            <xsl:when test="$CountryType='ME'">Karadağ</xsl:when>
            <xsl:when test="$CountryType='QA'">Katar</xsl:when>
            <xsl:when test="$CountryType='KZ'">Kazakistan</xsl:when>
            <xsl:when test="$CountryType='KE'">Kenya</xsl:when>
            <xsl:when test="$CountryType='CY'">Kıbrıs</xsl:when>
            <xsl:when test="$CountryType='KG'">Kırgızistan</xsl:when>
            <xsl:when test="$CountryType='KI'">Kiribati</xsl:when>
            <xsl:when test="$CountryType='CO'">Kolombiya</xsl:when>
            <xsl:when test="$CountryType='KM'">Komorlar</xsl:when>
            <xsl:when test="$CountryType='CG'">Kongo Cumhuriyeti</xsl:when>
            <xsl:when test="$CountryType='KV'">Kosova (RS)</xsl:when>
            <xsl:when test="$CountryType='CR'">Kosta Rika</xsl:when>
            <xsl:when test="$CountryType='CU'">Küba</xsl:when>
            <xsl:when test="$CountryType='KW'">Kuveyt</xsl:when>
            <xsl:when test="$CountryType='KP'">Kuzey Kore</xsl:when>
            <xsl:when test="$CountryType='LA'">Laos</xsl:when>
            <xsl:when test="$CountryType='LS'">Lesoto</xsl:when>
            <xsl:when test="$CountryType='LV'">Letonya</xsl:when>
            <xsl:when test="$CountryType='LR'">Liberya</xsl:when>
            <xsl:when test="$CountryType='LY'">Libya</xsl:when>
            <xsl:when test="$CountryType='LI'">Lihtenştayn</xsl:when>
            <xsl:when test="$CountryType='LT'">Litvanya</xsl:when>
            <xsl:when test="$CountryType='LB'">Lübnan</xsl:when>
            <xsl:when test="$CountryType='LU'">Lüksemburg</xsl:when>
            <xsl:when test="$CountryType='HU'">Macaristan</xsl:when>
            <xsl:when test="$CountryType='MG'">Madagaskar</xsl:when>
            <xsl:when test="$CountryType='MO'">Makao (CN)</xsl:when>
            <xsl:when test="$CountryType='MK'">Makedonya</xsl:when>
            <xsl:when test="$CountryType='MW'">Malavi</xsl:when>
            <xsl:when test="$CountryType='MV'">Maldivler</xsl:when>
            <xsl:when test="$CountryType='MY'">Malezya</xsl:when>
            <xsl:when test="$CountryType='ML'">Mali</xsl:when>
            <xsl:when test="$CountryType='MT'">Malta</xsl:when>
            <xsl:when test="$CountryType='IM'">Man Adası (GB)</xsl:when>
            <xsl:when test="$CountryType='MH'">Marshall Adaları</xsl:when>
            <xsl:when test="$CountryType='MQ'">Martinique (FR)</xsl:when>
            <xsl:when test="$CountryType='MU'">Mauritius</xsl:when>
            <xsl:when test="$CountryType='YT'">Mayotte (FR)</xsl:when>
            <xsl:when test="$CountryType='MX'">Meksika</xsl:when>
            <xsl:when test="$CountryType='FM'">Mikronezya</xsl:when>
            <xsl:when test="$CountryType='EG'">Mısır</xsl:when>
            <xsl:when test="$CountryType='MN'">Moğolistan</xsl:when>
            <xsl:when test="$CountryType='MD'">Moldova</xsl:when>
            <xsl:when test="$CountryType='MC'">Monako</xsl:when>
            <xsl:when test="$CountryType='MR'">Moritanya</xsl:when>
            <xsl:when test="$CountryType='MZ'">Mozambik</xsl:when>
            <xsl:when test="$CountryType='MM'">Myanmar</xsl:when>
            <xsl:when test="$CountryType='NA'">Namibya</xsl:when>
            <xsl:when test="$CountryType='NR'">Nauru</xsl:when>
            <xsl:when test="$CountryType='NP'">Nepal</xsl:when>
            <xsl:when test="$CountryType='NE'">Nijer</xsl:when>
            <xsl:when test="$CountryType='NG'">Nijerya</xsl:when>
            <xsl:when test="$CountryType='NI'">Nikaragua</xsl:when>
            <xsl:when test="$CountryType='NO'">Norveç</xsl:when>
            <xsl:when test="$CountryType='CF'">Orta Afrika Cumhuriyeti</xsl:when>
            <xsl:when test="$CountryType='UZ'">Özbekistan</xsl:when>
            <xsl:when test="$CountryType='PK'">Pakistan</xsl:when>
            <xsl:when test="$CountryType='PW'">Palau</xsl:when>
            <xsl:when test="$CountryType='PA'">Panama</xsl:when>
            <xsl:when test="$CountryType='PG'">Papua Yeni Gine</xsl:when>
            <xsl:when test="$CountryType='PY'">Paraguay</xsl:when>
            <xsl:when test="$CountryType='PE'">Peru</xsl:when>
            <xsl:when test="$CountryType='PL'">Polonya</xsl:when>
            <xsl:when test="$CountryType='PT'">Portekiz</xsl:when>
            <xsl:when test="$CountryType='PR'">Porto Riko (US)</xsl:when>
            <xsl:when test="$CountryType='RE'">Réunion (FR)</xsl:when>
            <xsl:when test="$CountryType='RO'">Romanya</xsl:when>
            <xsl:when test="$CountryType='RW'">Ruanda</xsl:when>
            <xsl:when test="$CountryType='RU'">Rusya</xsl:when>
            <xsl:when test="$CountryType='BL'">Saint Barthélemy (FR)</xsl:when>
            <xsl:when test="$CountryType='KN'">Saint Kitts ve Nevis</xsl:when>
            <xsl:when test="$CountryType='LC'">Saint Lucia</xsl:when>
            <xsl:when test="$CountryType='PM'">Saint Pierre ve Miquelon (FR)</xsl:when>
            <xsl:when test="$CountryType='VC'">Saint Vincent ve Grenadinler</xsl:when>
            <xsl:when test="$CountryType='WS'">Samoa</xsl:when>
            <xsl:when test="$CountryType='SM'">San Marino</xsl:when>
            <xsl:when test="$CountryType='ST'">São Tomé ve Príncipe</xsl:when>
            <xsl:when test="$CountryType='SN'">Senegal</xsl:when>
            <xsl:when test="$CountryType='SC'">Seyşeller</xsl:when>
            <xsl:when test="$CountryType='SL'">Sierra Leone</xsl:when>
            <xsl:when test="$CountryType='CL'">Şili</xsl:when>
            <xsl:when test="$CountryType='SG'">Singapur</xsl:when>
            <xsl:when test="$CountryType='RS'">Sırbistan</xsl:when>
            <xsl:when test="$CountryType='SK'">Slovakya Cumhuriyeti</xsl:when>
            <xsl:when test="$CountryType='SI'">Slovenya</xsl:when>
            <xsl:when test="$CountryType='SB'">Solomon Adaları</xsl:when>
            <xsl:when test="$CountryType='SO'">Somali</xsl:when>
            <xsl:when test="$CountryType='SS'">South Sudan</xsl:when>
            <xsl:when test="$CountryType='SJ'">Spitsbergen (NO)</xsl:when>
            <xsl:when test="$CountryType='LK'">Sri Lanka</xsl:when>
            <xsl:when test="$CountryType='SD'">Sudan</xsl:when>
            <xsl:when test="$CountryType='SR'">Surinam</xsl:when>
            <xsl:when test="$CountryType='SY'">Suriye</xsl:when>
            <xsl:when test="$CountryType='SA'">Suudi Arabistan</xsl:when>
            <xsl:when test="$CountryType='SZ'">Svaziland</xsl:when>
            <xsl:when test="$CountryType='TJ'">Tacikistan</xsl:when>
            <xsl:when test="$CountryType='TZ'">Tanzanya</xsl:when>
            <xsl:when test="$CountryType='TH'">Tayland</xsl:when>
            <xsl:when test="$CountryType='TW'">Tayvan</xsl:when>
            <xsl:when test="$CountryType='TG'">Togo</xsl:when>
            <xsl:when test="$CountryType='TO'">Tonga</xsl:when>
            <xsl:when test="$CountryType='TT'">Trinidad ve Tobago</xsl:when>
            <xsl:when test="$CountryType='TN'">Tunus</xsl:when>
            <xsl:when test="$CountryType='TR'">Türkiye</xsl:when>
            <xsl:when test="$CountryType='TM'">Türkmenistan</xsl:when>
            <xsl:when test="$CountryType='TC'">Turks ve Caicos</xsl:when>
            <xsl:when test="$CountryType='TV'">Tuvalu</xsl:when>
            <xsl:when test="$CountryType='UG'">Uganda</xsl:when>
            <xsl:when test="$CountryType='UA'">Ukrayna</xsl:when>
            <xsl:when test="$CountryType='OM'">Umman</xsl:when>
            <xsl:when test="$CountryType='JO'">Ürdün</xsl:when>
            <xsl:when test="$CountryType='UY'">Uruguay</xsl:when>
            <xsl:when test="$CountryType='VU'">Vanuatu</xsl:when>
            <xsl:when test="$CountryType='VA'">Vatikan</xsl:when>
            <xsl:when test="$CountryType='VE'">Venezuela</xsl:when>
            <xsl:when test="$CountryType='VN'">Vietnam</xsl:when>
            <xsl:when test="$CountryType='WF'">Wallis ve Futuna (FR)</xsl:when>
            <xsl:when test="$CountryType='YE'">Yemen</xsl:when>
            <xsl:when test="$CountryType='NC'">Yeni Kaledonya (FR)</xsl:when>
            <xsl:when test="$CountryType='NZ'">Yeni Zelanda</xsl:when>
            <xsl:when test="$CountryType='CV'">Yeşil Burun Adaları</xsl:when>
            <xsl:when test="$CountryType='GR'">Yunanistan</xsl:when>
            <xsl:when test="$CountryType='ZM'">Zambiya</xsl:when>
            <xsl:when test="$CountryType='ZW'">Zimbabve</xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$CountryType"/>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>
    <xsl:template name='Party_Other'>
        <xsl:param name="PartyType" />
        <xsl:for-each select="cbc:WebsiteURI">
            <tr align="left">
                <td>
                    <xsl:text>Web Sitesi: </xsl:text>
                    <xsl:value-of select="."/>
                </td>
            </tr>
        </xsl:for-each>
        <xsl:for-each select="cac:Contact/cbc:ElectronicMail">
            <tr align="left">
                <td>
                    <xsl:text>E-Posta: </xsl:text>
                    <xsl:value-of select="."/>
                </td>
            </tr>
        </xsl:for-each>
        <xsl:for-each select="cac:Contact">
            <xsl:if test="cbc:Telephone or cbc:Telefax">
                <tr align="left">
                    <td style="width:469px; " align="left">
                        <xsl:for-each select="cbc:Telephone">
                            <xsl:text>Tel: </xsl:text>
                            <xsl:apply-templates/>
                        </xsl:for-each>
                        <xsl:for-each select="cbc:Telefax">
                            <xsl:text> Fax: </xsl:text>
                            <xsl:apply-templates/>
                        </xsl:for-each>
                        <xsl:text>&#160;</xsl:text>
                    </td>
                </tr>
            </xsl:if>
        </xsl:for-each>
        <xsl:if test="$PartyType!='TAXFREE' and $PartyType!='EXPORT'">
            <xsl:for-each select="cac:PartyTaxScheme/cac:TaxScheme/cbc:Name">
                <tr align="left">
                    <td>
                        <xsl:text>Vergi Dairesi: </xsl:text>
                        <xsl:apply-templates/>
                    </td>
                </tr>
            </xsl:for-each>
            <xsl:for-each select="cac:PartyIdentification">
                <tr align="left">
                    <td>
                        <xsl:value-of select="cbc:ID/@schemeID"/>
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="cbc:ID"/>
                    </td>
                </tr>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
