<?php
// Garanti BBVA API Kimlik Bilgileri
$client_id = 'l71305d745b9594fa39ef94e0169f5a489';
$client_secret = '9b1f81256d10422cab5fe09823f1d2c5';
$scope = 'accounts transactions';
$token_url = 'https://apis.garantibbva.com.tr/oauth/token';
$account_info_url = 'https://apis.garantibbva.com.tr/balancesandmovements/accountinformation/account/v1/getaccountinformation';
$transactions_url = 'https://apis.garantibbva.com.tr/balancesandmovements/accounttransactions/account/v1/getaccounttransactions';
// OAuth 2.0 Token Al
function getAccessToken($client_id, $client_secret, $token_url, $scope) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $token_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'grant_type' => 'client_credentials',
        'client_id' => $client_id,
        'client_secret' => $client_secret,
        'scope' => $scope
    ]));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Curl Error: ' . curl_error($ch);
    }
    curl_close($ch);
    $data = json_decode($response, true);
    if (!$data || isset($data['error'])) {
        echo "Token Alma Hatas: " . ($data['error_description'] ?? 'Bilinmeyen hata') . "\n";
    }
    
    return $data['access_token'] ?? null;
}
// Hesap Bilgilerini Getir
function getAccountInfo($access_token, $account_info_url, $consentId, $unitNum, $accountNum, $IBAN) {
    $postData = json_encode([
        'consentId' => $consentId,
        'unitNum' => $unitNum,
        'accountNum' => $accountNum,
        'IBAN' => $IBAN
    ]);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $account_info_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $access_token,
        'Content-Type: application/json',
        'Accept: application/json'
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}
// lem Listesini Getir
function getAccountTransactions($access_token, $transactions_url, $consentId, $unitNum, $accountNum, $IBAN, $startDate, $endDate) {
    $postData = json_encode([
        'consentId' => $consentId,
        'unitNum' => $unitNum,
        'accountNum' => $accountNum,
        'IBAN' => $IBAN,
        'startDate' => $startDate,
        'endDate' => $endDate
    ]);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $transactions_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $access_token,
        'Content-Type: application/json',
        'Accept: application/json'
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}
// Token al ve ilemleri yap
$token = getAccessToken($client_id, $client_secret, $token_url, $scope);
if ($token) {
    $accountInfo = getAccountInfo($token, $account_info_url, '1daac6c2-9fd1-55c6-a926-c3f2247405ab', '295', '6291296', 'TR620006200029500006291296');
    echo "Hesap Bilgileri:\n" . json_encode($accountInfo, JSON_PRETTY_PRINT) . "\n";
    
    $transactions = getAccountTransactions($token, $transactions_url, '1daac6c2-9fd1-55c6-a926-c3f2247405ab', '295', '6291296', 'TR620006200029500006291296', '2024-01-01', '2024-03-15');
    echo "lem Listesi:\n" . json_encode($transactions, JSON_PRETTY_PRINT) . "\n";
} else {
    echo "Token alnamad!";
}
?>