<?php
	header('Content-Type: text/css');
	include("map.php");

	//-----------> Logo Colors Parsing
	list($r, $g, $b) = sscanf("#".$colors[1]."", "#%02x%02x%02x");
	$clr1_rgba = "rgba(".$r.", ".$g.", ".$b.", 0.9)";
	$clr1_hex  = "#".$colors[1]."";

	list($r, $g, $b) = sscanf("#".$colors[2]."", "#%02x%02x%02x");
	$clr2_rgba = "rgba(".$r.", ".$g.", ".$b.", 0.9)";
	$clr2_hex  = "#".$colors[2]."";

	list($r, $g, $b) = sscanf("#".$colors[3]."", "#%02x%02x%02x");
	$clr3_rgba = "rgba(".$r.", ".$g.", ".$b.", 0.9)";
	$clr3_hex  = "#".$colors[3]."";

	//-----------> Role Based Display Logic
	if($MSA<>1){ echo ".msa {display:none !important;}"; }
	if($MA<>1) { echo ".ma {display:none !important;}"; }
	if($SU<>1) { echo ".su {display:none !important;}"; }
	if($E==1)  { echo ".e {display:none !important;}"; }
?>

/* =========================================
   220126 - DASHBOARD & CARDS
   ========================================= */
.bgt.card { border: 0 !important; border-radius: 14px; background: linear-gradient(135deg, #fff, #f7f7f7); box-shadow: 0 8px 22px rgba(0, 0, 0, .06); transition: all .25s ease; }
.bgt.card:hover { transform: translateY(-3px); box-shadow: 0 12px 26px rgba(0, 0, 0, .1); }
.bgt .card-header { border-bottom: 0; background: none; padding: 18px 22px; }
.bgt .card-title { font-size: 20px; font-weight: 700; color: #444; display: flex; align-items: center; gap: 8px; }

/* =========================================
   GENEL KART YAPISI (General Card)
   ========================================= */
.card { border: 0; border-radius: 14px; background: #fff; box-shadow: 0 6px 20px rgba(0, 0, 0, .08); overflow: hidden; margin-bottom: 15px; }
.card-header { padding: 14px 18px; }
.card-header .card-title { font-size: 20px; margin: 0; color: #fff; }
.card-actions { display: flex; align-items: center; gap: 6px; bottom: 15px; }
.card-actions .btn { border-radius: 8px !important; padding: 4px 10px !important; font-size: 12px !important; box-shadow: 0 2px 4px rgba(0, 0, 0, .12); border: 0 !important; transition: all .2s; }
.card-actions .btn:hover { transform: translateY(-2px); box-shadow: 0 6px 14px rgba(0, 0, 0, .18); }
.card-actions select { border-radius: 6px; border: 1px solid #ddd; padding: 2px 4px; background: #fff; font-size: 12px; height: 22px; cursor: pointer; }.card-actions .btn-default { position: relative; background: #fff !important; color: #333 !important; }
.card-actions .dropdown-menu.ddd { display: none; position: absolute; top: 30px; right: 0px; background: #fff; min-width: 150px; padding: 6px 0; border-radius: 10px; box-shadow: 0 8px 20px rgba(0, 0, 0, .15); z-index: 9999; animation: fadeIn .25s ease; left: auto; z-index: 99999; }.card-actions .btn-default:hover .ddd { display: block; }
.card-actions .dropdown-menu.ddd a { padding: 8px 12px; display: block; color: #444; font-size: 13px; text-decoration: none; }
.card-actions .dropdown-menu.ddd a:hover { background: #f5f5f5; }
.card-body { padding: 20px; background: #fafafa; }

/* =========================================
   ANIMATIONS
   ========================================= */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(4px); }
    to   { opacity: 1; transform: translateY(0); }
}

@media(max-width:768px) {
    .card-header {flex-direction: column;align-items: flex-start;gap: 10px;}
    .card-actions { flex-wrap: wrap; gap: 4px; }
}

/* =========================================
   UI ELEMENTS & HELPERS
   ========================================= */
.qmodal .dropdown-menu .dropdown-item { font-size: 13px; }
#tab-logo img { max-width: 100%;}
.input-active .v3-form-control { border-left: 2px solid green !important; }
.input-passive { filter: opacity(0.1);}

/* Loading Overlay */
.loading-overlay { display: flex; justify-content: center; align-items: center; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(255, 255, 255, 0.8); z-index: 9999; flex-direction: column; text-align: center; }
.w1600 .select2-selection {border: 0px; box-shadow: unset;}
.w1600 span.badge { margin-right: 1px; margin-bottom: 1px;}
.upload-btn.drag-over { transform: scale(2.5); }
.select2-search__field { border: 0px !important; }

/* Pulse Animations */
@keyframes shadow-pulse {
    0%   { box-shadow: 0 0 0 0px rgba(0, 0, 0, 0.2); }
    100% { box-shadow: 0 0 0 10px rgba(0, 0, 0, 0); }
}

@keyframes border-pulse {
    0%   { border-color: rgba(255, 0, 0, 1); }
    50%  { border-color: rgba(255, 0, 0, 0); }
    100% { border-color: rgba(255, 0, 0, 1); }
}

.spulse { animation: shadow-pulse 2s infinite; }
.pulse  { animation: border-pulse 2s infinite; }
.pulse1 { animation: border-pulse 1s infinite; }

@keyframes blinker { 30% { opacity: 0; } }

.blink  { animation: blinker 2s linear infinite; }
.blink1 { animation: blinker 1s linear infinite; }

/* Table & Hover Actions */
.hitem { display: none; }
.hover:hover .hitem { display: block; }

.v3-table { width: 100%; }
.v3-table .fa-edit { position: absolute; top: 20px; right: 40px; cursor: pointer; display: none; }.v3-table tr:hover .fa-edit { position: absolute; top: 20px; right: 40px; display: block; }.cke_notifications_area { display: none; }
.gt img { height: 16px; }
.tdhi:hover .hicons { display: block; }
.hicons { position: absolute; right: 0px; top: 5px; display: none; }
body { height: 100vh; overflow: hidden; }
/* =========================================
   FLIP CARD & MISC
   ========================================= */
.cflip { width: 34px; height: 34px; z-index: 1; -webkit-perspective: 1000; perspective: 1000; cursor: pointer; }.flip_card { -webkit-transform-style: preserve-3d; -webkit-transition: all 1.0s linear; transform-style: preserve-3d; transition: all 1.0s linear; }.cflip.active .flip_card { -webkit-transform: rotateY(180deg); transform: rotateY(180deg); }.front { width: 34px; height: 34px; border-radius: 50%; overflow: hidden; background: white; backface-visibility: hidden; -webkit-backface-visibility: hidden; }.front img { min-height: 34px; max-height: 100%; max-width: 100%; }.back { position: absolute; z-index: -1; top: 0px; padding-top: 4px; width: 34px; height: 33px; border: 1px solid #8d8d8d; border-radius: 50% !important; -webkit-transform: rotateY(180deg); transform: rotateY(180deg); }.col_filter { position: absolute; z-index: 999; display: none; width: 100%; list-style: none; left: 0px; background: white; border: 1px solid #ccc; border-radius: 5px; padding: 0px; }.col_filter li { border-bottom: 1px solid #ccc; padding: 2px 5px; }.cols .fa-square-caret-down { position: absolute; margin-top: 5px; right: 0px; }.qbr { border-radius: 24px 24px 0px 0px !important; }.old-fa { position: absolute; left: 5px; top: 45px; font-size: 30px; }.scontent { display: none; }
#background-video { width: 100vw; height: 100vh; object-fit: cover; position: fixed; left: 0; right: 0; top: 0; bottom: 0; z-index: -1; }.v8-col200pxL-left fieldset { width: 200px; float: right; }

/* =========================================
   BACKGROUND LOGIC (PHP)
   ========================================= */
<?php if(substr($crm_background,0,5)=="deppo"){ $themeurl = "../"; }else{ $themeurl = "//cdn.".$cdnurl."/"; }?>
#jswpanel {
    <?php if($crm_background==""){?>
        background: url(<?php echo $themeurl?>themes/svg/pattern.svg); background-repeat: repeat; background-size: auto; background-color: rgb(84, 93, 107);
    <?php }?>

    <?php if(substr($crm_background,-3)=="mp4"){?>
        background: url();
    <?php }?>

    <?php if(substr($crm_background,-3)=="jpg"){?>
        background: url(<?php echo $themeurl?><?php echo $crm_background?>); background-repeat: no-repeat; background-size: cover;
    <?php }?>

    <?php if(substr($crm_background,-3)=="svg"){ $svgs = explode(',',$crm_background);?>
        background-image: url(<?php echo $themeurl?><?php echo $svgs[1]?>); background-repeat: repeat; background-size: auto; background-color: <?php echo $svgs[0]?>;
    <?php }?>

    <?php if(substr($crm_background,-3)=="jpg" or substr($crm_background,-3)=="mp4"){}else{echo "background:".$crm_background.";";}?>
		background-position: center center; background-attachment: fixed;}

/* =========================================
   LAYOUT & SIDEBAR
   ========================================= */
.input-group-prepend { padding: 5px 5px 0px 5px !important; }
html .scroll-to-top { display: none !important; }
body { font-size: 14px; }
body a, body a:focus, body a:hover, body a:active, body a:visited { outline: none !important; }
a, a:hover, a:focus { color: #ccc; }

.header .toggle-sidebar-left { background: transparent; font-size: 24px; color: <?php echo $clr1_hex;?>; }
.sidebar-header .sidebar-toggle { position: absolute; left: 0px; top: 0px; cursor: pointer; }
.sidebar-header .sidebar-toggle i { line-height: 40px; background: #ffffff4f; padding: 10px 22px; }
.sidebar-left { width: 250px; }
html.no-overflowscrolling .nano > .nano-content { left: -5px; }

ul.nav-main > li > a { padding: 10px 20px; font-size: .875rem; }
ul.nav-main > li.nav-active > a { background: transparent !important; }
.page-header h2 { border-bottom: 0px solid #CCC; }
.page-header { box-shadow: unset !important; }

/* =========================================
   ICONS, ALERTS & INFO
   ========================================= */
.v3-circle { background: <?php echo $module["clrwarning"]?>; padding: 5px; font-size: 17px; text-align: center; color: <?php echo $module["bcwarning"]?>; display: inherit; width: 34px; height: 34px; border-radius: 5px; }
.v3-date { display: inherit; width: 34px; height: 34px; }
.v3-date span:nth-child(1) { background: <?php echo $module["clrwarning"]?>; padding: 0px; font-size: 14px; text-align: center; color: <?php echo $module["bcwarning"]?>; display: block; width: 34px; height: 20px; border-radius: 5px 5px 0px 0px; }
.v3-date span:nth-child(2) { background: <?php echo $module["clrcdanger"]?>; padding: 0px; font-size: 12px; text-align: center; color: <?php echo $module["bcdanger"]?>; display: block; width: 34px; height: 20px; }
.sfa { font-family: 'FontAwesome', 'Second Font name'; border: 0px; }
.sna { -webkit-appearance: none; -moz-appearance: none; text-indent: 1px; text-overflow: ''; padding: 3px !important; border: 0px; }
.sfa option, .sna option { text-align: center; }
.form legend { position: relative; background: -webkit-gradient( linear, left top, left bottom, from(#f8f8f836), to(#efecec) ); border: 0px; box-shadow: 0 0 3px rgb(0 0 0 / 15%); color: #4c4242; }
.crm_info { position: relative; background: whitesmoke; }
.info_icon { position: absolute; top: -15px; right: 5px; font-size: 16px; }
.chosen-container-single .chosen-single { padding: 5px 0px 0 5px !important; height: 34px !important; }

/* =========================================
   CURRENCY & EXCHANGE RATES
   ========================================= */
.transactions_table { min-width: max-content; }

#kur .exc_gr:before  { font-size: 85px !important; }
#kur .exc_gbp:before { bottom: 32px !important; font-size: 90px !important; left: 18px !important; }
#kur .exc_eur:before { bottom: 31px !important; font-size: 90px !important; }
#kur .exc_usd:before, #kur .exc_eur:before, #kur .exc_gbp:before, #kur .exc_gr:before { color: #33373c38 !important; }
#kur .exc { text-align: center; background: #f5f5dc; border-radius: 10px; margin-top: 40px; padding: 1px 0px 5px 0px; }
#kur .exc_usd:before { content: "\f155"; font-family: FontAwesome; left: 14px; position: absolute; bottom: 31px; font-size: 84px; color: #ffffff0d; opacity: 0.4; }
#kur .exc_eur:before { content: "\f153"; font-family: FontAwesome; left: 14px; position: absolute; bottom: 26px; font-size: 102px; color: #ffffff0d; opacity: 0.4; }
#kur .exc_gbp:before { content: "\f154"; font-family: FontAwesome; left: 14px; position: absolute; bottom: 26px; font-size: 102px; color: #ffffff0d; opacity: 0.4; }
#kur .exc_gr:before  { content: "\f51e"; font-family: FontAwesome; left: 16px; position: absolute; bottom: 31px; font-size: 94px; color: #ff99001f; opacity: 0.4; }
.wtimes>.v3-col-xs-3:before { content: "\f017"; font-family: FontAwesome; left: 16px; position: absolute; bottom: 31px; font-size: 70px; color: #ff99001f; opacity: 0.8; }
.vclass { filter: drop-shadow(2px 2px 1px <?php echo $module["abwarning"];?>); }
.valert { color: red; clear: both; text-align: left; padding-top: 5px; font-size: 12px; margin-bottom: -7px; }

#control-bar.fixed { z-index: 999; }
#conn { display: none; position: fixed; z-index: 99999; font-size: 14px; top: 0px; left: 0px; width: 100%; text-align: center; padding: 5px; }

/* =========================================
   AUTHENTICATOR & FONTS
   ========================================= */
.authenticator { position: absolute; width: 250px; text-align: center; z-index: 9999999; top: -73px; display: none; border-radius: 10px; right: 83px; }
.auth_qr { display: none; }
.authenticator input { text-align: center; background: #eff3fa !important; border: 1px solid #ccc !important; height: 50px; font-size: 20px !important; font-weight: bold; }
.dark .authenticator input { text-align: center; background: #272727c4 !important; border: 1px solid #ccc !important; height: 50px; font-size: 20px !important; font-weight: bold; }
input::-webkit-outer-spin-button, input::-webkit-inner-spin-button { -webkit-appearance: none; margin: 0; }

.bg-cloud-upload:before { content: "\f0ee"; font-family: FontAwesome; left: 0px; position: absolute; bottom: -70px; font-size: 235px; color: #cccccc33; }

.c0 { color: #bf7053; font-weight: bold; }
.c1 { color: #3a6160; font-weight: bold; }
.c2 { color: #d4a385; font-weight: bold; }
.c3 { color: #afbfb5; font-weight: bold; }
.c4 { color: #bfb9a0; font-weight: bold; }
.c5 { color: #dfa052; font-weight: bold; }

.tagsinput { width: 100% !important; min-height: 70px !important; height: 70px !important; }
div.tagsinput { background: transparent; border: transparent; }

@font-face { font-family: Technology; src: url(assets/font/technology.ttf); }
.digi { font-family: Technology, serif; font-size: 16px; }
.cb { clear: both; }

/* =========================================
   UPLOADS & MEDIA
   ========================================= */
#uploadarea, .medias { min-height: 350px !important; }
#uploadarea { border: 2px dashed #d9d9d9; border-left: 5px solid #fe8100 !important; }
.b1o { border: 1px solid <?php echo $module["clrwarning"]?> !important }
.down:after { font-family: "Font Awesome 5 Free"; content: "\f107"; position: absolute; }
#cke_rte { width: 100%; }
.mcbtn { margin: 4px 8px; }

/* =========================================
   TIMELINE & TABLES
   ========================================= */
.timeline .tm-items > li { margin: 20px 0; min-height: 40px; }
.dropdown-menu .dropdown-item { font-size: 0.9rem; }
.dropdown-menu .dropdown-item input { float: left; margin-right: 5px; margin-top: 3px; }

#menu .v3-badge { position: absolute; right: 20px; margin-right: 20px; margin-top: 2px; color: #33363c; }

table { border-collapse: collapse; border: 0px; overflow: hidden; }
.table { margin-bottom: 0px !important; width: 100%; }
.table th { vertical-align: middle !important; }
.table td { line-height: normal !important; vertical-align: middle !important; }
.table-bordered { border: 0px; }
.table.table-no-more.table-bordered td { border-bottom: 0px solid #dedede; }
.table.table-no-more tr { border-bottom: 0px solid #DDD; }
.v3-table > tbody > tr > td, .v3-table > tbody > tr > th, .v3-table > thead > tr > th { vertical-align: middle !important; position: relative; }

body .card-body { background: #fdfdfdf0 !important; padding: 5px; }
.btr { border-top: 2px solid #fff !important; }
.tm-body { padding: 0px 10px; }

/* =========================================
   DYNAMIC COLORS INJECTION
   ========================================= */
<?php if($clr1_hex<>""){?>
#uploadrea {
    border-left: 5px <?php echo $clr1_hex;?> solid !important;
}
.form fieldset, .fieldset {
    border-left: 5px <?php echo $clr1_hex;?> solid !important;
}
.card-title { color: <?php echo $clr1_hex;?> !important; }
.card-header { border-bottom: 1px solid <?php echo $clr2_hex;?> !important; }
.header { border-bottom: 0px solid <?php echo $clr2_hex;?> !important;}
.card-featured-warning .card-title { color: <?php echo $clr1_hex;?> !important; }
.card-featured-danger .card-title { color: <?php echo $clr1_hex;?> !important; }
.card-featured-success .card-title { color: <?php echo $clr1_hex;?> !important; }
.card-featured-info .card-title { color: <?php echo $clr1_hex;?> !important; }
.card-featured-warning { border-color: <?php echo $clr2_hex;?> !important; }
.card-featured-danger { border-color: <?php echo $clr2_hex;?> !important; }
.card-featured-success { border-color: <?php echo $clr2_hex;?> !important; }
.card-featured-info { border-color: <?php echo $clr2_hex;?> !important; }
<?php }?>

ul.v8-tabs li > a, ul.v8-side-tabs li > a, ul.v8-tabs li > span, ul.v8-side-tabs li > span {
    background: -webkit-gradient(linear, left top, left bottom, from(#fffffff0), to(#eeeeee));
    color: #4c4242;
}
.v8-tabs-content, .card-body, #switchs fieldset { background-color: #fdfdfdf0 !important; }
.userbox { background: #fdfdfdf0; padding: 5px; border-radius: 5px; }
#control-bar, .page-header { background: #ffffffde !important; }
.hovered { background: #ffffffde !important; }
.profile-info span { color: #000; }

.turn { animation: spin 15s linear infinite; }
@keyframes spin { 100% { transform: rotateZ(360deg); } }

.run { animation: run 10s linear infinite; }
@-webkit-keyframes run {
    0%   { left: 20%; }
    50%  { left: 40%; }
    100% { left: 20%; }
}
::placeholder { color: darkgrey !important; }

/* =========================================
   DARK MODE
   ========================================= */
<?php if($_GET["dark"]==""){?>
.dark-mode .profile-info span { color: #fff; }
.dark-mode #control-bar, .dark-mode .page-header { background: #000000de !important; }
.dark-mode .sidebar-left .nano:not(.hovered), .dark-mode .sidebar-header .sidebar-toggle { background: transparent !important; }
.dark-mode .hovered { background: #000000de !important; }
.dark-mode .userbox { background: transparent; padding: 0px; border-radius: 0px; }
.dark-mode .card-title { color: white !important; }
.dark-mode ::placeholder { color: white !important; opacity: 1; }
.dark-mode .addtr ::placeholder { color: #000000c4; opacity: 1; }
.dark-mode .v8-tabs-content, .dark-mode .card-body, .dark-mode .nav-tabs li a, .dark-mode .v8-mini-tabs, .dark-mode .tab-content, .dark-mode .select2-results, .dark-mode select option, .dark-mode #apicontent { background-color: #000000c4 !important; background: #000000c4 !important; color: #d6d6d6 !important; }
.dark-mode .logo-container, .dark-mode .header-right { background-color: transparent !important; background: transparent !important; color: #d6d6d6 !important; }
.dark-mode select option { background: #000000c4 !important; }
.dark-mode label { color: #d6d6d6 !important; }
.dark-mode .input-group-addon { background: transparent; border: 0px; }
.dark-mode .color .input-group-addon { background: white; border: 0px; }
.dark-mode .form-control, .dark-mode .v3-form-control, .dark-mode .notranslate { background-color: transparent !important; background: transparent !important; color: #d6d6d6 !important; }
.dark-mode select, .dark-mode .filter_form input { background-color: transparent !important; background: transparent !important; color: #d6d6d6 !important; }
.dark-mode .addtr .form-control, .dark-mode .addtr .v3-form-control, .dark-mode .addtr .notranslate { color: #313131 !important; }
.dark-mode .card-header, .dark-mode .tm-title, .dark-mode .tm-box, .dark-mode legend, .dark-mode .wcon, .dark-mode .btn-default, .dark-mode .v3-btn-default, .dark-mode #addclient, .dark-mode .logos, .dark-mode #switchs fieldset { background-color: #000000c4 !important; background: #000000c4 !important; color: #d6d6d6 !important; }
.dark-mode table td, .dark-mode table th { border: 0px solid #313131; background-color: #000000c4 !important; background: #000000c4 !important; color: #d6d6d6 !important; }
.dark-mode table .addtr td { border: 0px solid #313131; background-color: #ed9c28 !important; background: #ed9c28 !important; color: #313131 !important; }
.dark-mode table tr:hover { background-color: #000000c4 !important; background: #000000c4 !important; color: #d6d6d6 !important; }
.dark-mode ul.v8-side-tabs li > a, .dark-mode .v8-mini-tabs li > a, .dark-mode ul.v8-tabs li.v8-current > a { background: -webkit-linear-gradient(top, #0d0d0d 0%,#000000c4 50%); color: #d6d6d6 !important; }
.dark-mode .select2-selection__rendered { color: #d6d6d6 !important; }
.dark-mode .notifications > li > a { background: #ed9c28 !important; color: #fff !important; }
.dark-mode .notifications > li .notification-icon i, .dark-mode .amount { color: #fff !important; }
.dark-mode .fa-film { color: #ed9c28 !important; }
.dark-mode #search-list li a { color: #000 !important; }
.dark-mode .v8-tabs-content fieldset, .dark-mode .card-body, .dark-mode .v8-tabs-content { border: 1px solid #313131 !important; }
.dark-mode .filter_form { position: relative; text-align: center; }
.dark-mode #kur .exc { text-align: center; background: #303030; border-radius: 10px; margin-top: 40px; padding: 1px 0px 5px 0px; }
.dark-mode .wtimes .wt { background: #000000c4; padding: 10px; border-radius: 15px; }
.dark-mode .btr { border-top: 2px solid #000 !important; }
.dark-mode .mailbox .content-with-menu-container { background: #000000c4 !important; }
<?php }?>

/* =========================================
   BANK ICONS
   ========================================= */
.banks { background-image: url('//cdn.<?php echo $cdnurl?>/img/bank-icons.png'); }
.mbank14 { background-repeat: no-repeat; background-position: -584px -31px; }    /*Finans Bank*/
.mbank12 { background-repeat: no-repeat; background-position: -249px -129px; }   /*Deniz*/
.mbank16 { background-repeat: no-repeat; background-position: -152px -33px; }    /*Garanti*/
.mbank20 { background-repeat: no-repeat; background-position: -38px -32px; }     /*Kuveyt*/
.mbank27 { background-repeat: no-repeat; background-position: -156px -35px; }    /*Halk Bank*/
.mbank28 { background-repeat: no-repeat; background-position: -478px -35px; }    /*Maximum*/
.mbank32 { background-repeat: no-repeat; background-position: -154px -35px; }    /*Teb*/
.mbank38 { background-repeat: no-repeat; background-position: -160px -134px; }   /*Vakıfbank*/
.mbank39 { background-repeat: no-repeat; background-position: -38px -134px; }    /*Word*/
.mbank40 { background-repeat: no-repeat; background-position: -249px -31px; }    /*Ziraat*/
.mbank41 { background-repeat: no-repeat; background-position: -365px -35px; }    /*Axess*/

.dbank3  { background-repeat: no-repeat; background-position: -190px -608px; background-color: #e9e9e9; } /*Albaraka*/
.dbank12 { background-repeat: no-repeat; background-position: -394px -608px; background-color: #e9e9e9; } /*Deniz*/
.dbank14 { background-repeat: no-repeat; background-position: -195px -485px; background-color: #e9e9e9; } /*Finans Bank*/
.dbank16 { background-repeat: no-repeat; background-position: -193px -370px; background-color: #e9e9e9; } /*Garanti*/
.dbank20 { background-repeat: no-repeat; background-position: 10px -370px;   background-color: #e9e9e9; } /*Kuveyt*/
.dbank27 { background-repeat: no-repeat; background-position: -156px -35px;  background-color: #e9e9e9; } /*Halk Bank*/
.dbank28 { background-repeat: no-repeat; background-position: -580px -370px; background-color: #e9e9e9; } /*Maximum*/
.dbank32 { background-repeat: no-repeat; background-position: 21px -608px;   background-color: #e9e9e9; } /*Teb*/
.dbank39 { background-repeat: no-repeat; background-position: -395px -485px; background-color: #e9e9e9; } /*Word*/
.dbank38 { background-repeat: no-repeat; background-position: -590px -485px; background-color: #e9e9e9; } /*Vakıfbank*/
.dbank40 { background-repeat: no-repeat; background-position: -390px -370px; background-color: #e9e9e9; } /*Ziraat*/
.dbank41 { background-repeat: no-repeat; background-position: 11px -485px;   background-color: #e9e9e9; } /*Axess*/

#gesturepwd { text-align: center; background: transparent !important; }
.hweather { top: 5px; }
.hweather img { margin-top: -40px; }
.wj1 { font-size: 14px; position: absolute; bottom: 0px; width: 100px; }
.wj2 { font-size: 33px; position: absolute; top: 5px; }
.wj2:after { content: "\00b0"; }
.hdate { display: block; font-size: 33px; margin-top: 5px; }
.hdate span { display: block; font-size: 18px; }
.icons { height: 100px; overflow: auto; list-style: none; position: absolute; width: 100%; background: white; padding: 0px; border: 1px solid #ccc; z-index: 999; }
.icons li { padding: 3px; cursor: pointer; }
.icons li:hover { background: bisque; }
#addclient { padding: 10px; border-radius: 0px 0px 10px 10px; }
#addclient input { background: white !important; }
#modalFull { padding: 0px !important; }
.modal { overflow: initial !important; }

/* .modal-backdrop{display:none !important;} */
.modal-backdrop { z-index: 9999; background: rgba(0, 0, 0, 0.8); backdrop-filter: blur(5px); }
.modal-dialog { margin: 0px auto; }
.modal-content { border-radius: 0px 0px 0px 5px; }
.v3-modal-title { width: 100%; text-align: right; font-size: 13px; margin: 0px; }
.modal-header .fa-times { font-size: 23px; transition: transform 0.3s linear; }
.modal-header .fa-times { display: inline-block; transition: transform 0.4s ease; transform: rotate(0deg); }
.modal-header .fa-times:hover { transform: rotate(180deg); }

.modal.left .modal-dialog, .modal.right .modal-dialog { height: 100%; -webkit-transform: translate3d(0%, 0, 0); -ms-transform: translate3d(0%, 0, 0); -o-transform: translate3d(0%, 0, 0); transform: translate3d(0%, 0, 0); }
.modal.left .modal-content, .modal.right .modal-content { height: 100%; }

/* Left Modal */
.modal.left { left: -400px !important; -webkit-transition: opacity 0.3s linear, left 0.3s ease-out !important; -moz-transition: opacity 0.3s linear, left 0.3s ease-out !important; -o-transition: opacity 0.3s linear, left 0.3s ease-out !important; transition: opacity 0.3s linear, left 0.3s ease-out !important; }
.modal.left.fade.show, .modal.left.fade.in { left: 0px !important; }

/* Right Modal */
.modal.right { right: -400px !important; -webkit-transition: opacity 0.3s linear, right 0.3s ease-out !important; -moz-transition: opacity 0.3s linear, right 0.3s ease-out !important; -o-transition: opacity 0.3s linear, right 0.3s ease-out !important; transition: opacity 0.3s linear, right 0.3s ease-out !important; }
.modal.right.fade.show, .modal.right.fade.in { right: 0px !important; }

.multiselect-container > li.active > a > label { color: #33363c; }
.dataTables_length { padding: 10px; }
.dataTables_filter { padding: 10px; }
.dataTables_length select { height: 34px !important; border: 1px solid !important; }
div.dataTables_wrapper div.dataTables_filter input { border: 1px solid !important; height: 34px; }

.cnews .owl-nav { display: block !important; }
.cnews .owl-nav .owl-prev { background: transparent; }
.cnews .owl-nav .owl-prev:hover { background: transparent; }
.cnews .owl-nav .owl-next { background: transparent; }
.cnews .owl-nav .owl-next:hover { background: transparent; }
.cnews .owl-nav .owl-prev { left: -15px; padding: 0px; }
.cnews .owl-nav .owl-next { right: -15px; padding: 0px; }
.cnews .owl-stage-outer { margin-left: 15px; margin-top: -49px; }

.news { max-width: 500px; overflow: hidden; }
.news a { font-size: 13px; color: silver; display: block; width: 100%; }
.pull-left { font-size: 13px; color: silver; margin-top: 1px; margin-right: 4px; }
.pfont { font-family: 'Orbitron', sans-serif !important; }
#lnotifications li { border-bottom: 1px solid #ccc; padding-bottom: 5px; }
.notes li { border-bottom: 1px solid #cccccc2e; padding-bottom: 5px; }
.bgt { background: #ffffff33; }
.card-body .count { font-size: 24px !important; }
input[type=color] { padding: 0px; }
.clist { list-style: none; padding: 5px; background: white; border-left: 1px #ccc solid; bottom: 60px; }
.clist li { padding: 5px; }
.clist li:hover { background: orange; }

/* Scrollbars */
::-webkit-scrollbar { width: 0.5em; height: 0.5em; }
::-webkit-scrollbar-button { background: #ccc; }
::-webkit-scrollbar-track-piece { background: #888; }
::-webkit-scrollbar-thumb { background: #eee; }

label { display: block; }
.bilgi { float: right; margin: 20px; min-height: 100px; list-style: none; }
.bilgi li { width: 250px; margin-bottom: 3px; background-color: #3399cc; color: #fff; padding: 8px; }
.tabs-content { height: auto !important; }
.fa-info { padding: 2px 3px; }
.clnspan { float: right; margin-right: 5px; margin-top: -20px; position: relative; z-index: 2; color: #999; font-size: 14px; opacity: 0.5; }

@font-face { font-family: 'AbakuTLSymSansRegular'; src: url('font/abakutlsymsans.eot'); src: url('font/abakutlsymsans.eot?#iefix') format('embedded-opentype'), url('font/abakutlsymsans.woff') format('woff'), url('font/abakutlsymsans.ttf') format('truetype'), url('font/abakutlsymsans.svg#AbakuTLSymSansRegular') format('svg'); font-weight: normal; font-style: normal; }
tl { font: Arial, Helvetica, sans-serif; }
tl:before { font-family: "AbakuTLSymSansRegular", serif; font-size: 12px; content: "t"; padding-right: 5px; }

.btn-delete-row { padding: 5px; }
.btn-ban-row { padding: 5px; }
.btn-edit-row { padding: 5px; }

/* =========================================
   MESSAGE BOX
   ========================================= */
.message-box { display: none; position: fixed; left: 0px; top: 0px; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); z-index: 999999; }
.message-box.open { display: block; }
.message-box .mb-container { position: absolute; left: 0px; top: 30%; background: rgba(0, 0, 0, 0.9); padding: 20px; width: 100%; }

@media screen and (min-width: 961px) {
    .message-box .mb-container .mb-middle { width: 50%; left: 25%; position: relative; color: #FFF; }
    .message-box .mb-container .mb-middle .mb-title { width: 100%; float: left; padding: 10px 0px 0px; font-size: 31px; font-weight: 400; line-height: 36px; }
    .message-box .mb-container .mb-middle .mb-content p { margin-bottom: 0px; }
}
@media screen and (max-width: 960px) {
    .message-box .mb-container .mb-middle { width: 65%; left: 15%; position: relative; color: #FFF; }
    .message-box .mb-container .mb-middle .mb-title { width: 100%; float: left; padding: 10px 0px 0px; font-size: 13px; font-weight: 400; line-height: 20px; }
    .message-box .mb-container .mb-middle .mb-content p { margin-bottom: 0px; font-size: 11px; }
}

.message-box .mb-container .mb-middle .mb-title .fa, .message-box .mb-container .mb-middle .mb-title .glyphicon { font-size: 38px; float: left; margin-right: 10px; }
.message-box .mb-container .mb-middle .mb-content { width: 100%; float: left; padding: 10px 0px 0px; }
.message-box .mb-container .mb-middle .mb-footer { width: 100%; float: left; padding: 10px 0px; }
.message-box.message-box-warning .mb-container { background: rgba(254, 162, 35, 0.9); }
.message-box.message-box-danger .mb-container { background: rgba(182, 70, 69, 0.9); }
.message-box.message-box-info .mb-container { background: rgba(63, 186, 228, 0.9); }
.message-box.message-box-success .mb-container { background: rgba(149, 183, 93, 0.9); }

#llock, #lunlock, #lban { font-size: 150px; position: absolute; margin-left: 36%; margin-top: -50%; display: none; z-index: 999999; }

@media print { .noprint { display: none !important; } }
li.alert-default { background-color: #7a7b7f !important; }
.dn { display: none; }
.dropdown-menu { padding: 5px; }
.card-header .btn { font-size: 12px; padding: 4px 8px; }
.card-subtitle { display: none; }
.alert { padding: 5px !important; border: 0px; }
.form fieldset, .fieldset { padding: 2px 2px 10px 15px; }
.form fieldset p { font-size: 10px; position: absolute; margin-top: 0px; text-align: right; width: 95%; right: 15px; }
#ctck { position: absolute; top: 0px; right: 0px; }
.wtimes { margin-top: -10px; }
.wtimes .wt { text-align: center; background: #f4f4dc; padding: 10px; border-radius: 15px; }
.wtime { font-size: 20px !important; }
.image .bg-danger.fa { background-color: transparent !important; color: #dc3545 !important; }
.image .bg-warning.fa { background-color: transparent !important; color: #ffc107 !important; }
.notification-menu .title { color: #d2312d; display: block; font-size: 12px; line-height: 1.1rem; padding: 2px 0 0; }
.notifications .notification-menu .content { padding: 0px; }
.notification-menu li { padding: 3px 5px !important; margin: 0px; }
.notification-menu li:hover { background: oldlace; }
#lnotifications li { padding: 3px 0px; min-height: 45px; margin: 0px; }
#lnotifications li:hover { background: oldlace; }
.notifications .notification-menu .content { padding: 5px; }

<?php if($_GET["islem"]<>"" and $_GET["islem"]<>"ayarlar"){?>
.card-body { padding: 0px; }
<?php }?>

.tooltip { left: -41% !important; }
tbody tr:hover { box-shadow: 3px 3px 3px 3px rgba(0, 0, 0, 0.5); }
.noshadow tr:hover { box-shadow: none !important; }
table.calendar > tbody tr:hover { background-color: unset !important; box-shadow: unset !important; }
.table.table-no-more td { padding-left: 10px !important; }
.calendar tbody th, .calendar tbody td, .list-calendar tbody th, .list-calendar tbody td { vertical-align: top !important; }
.sort { float: right; width: 2px; line-height: 0px; margin-top: 15px; }
.order { float: right; width: 2px; line-height: 0px; margin-top: 5px; margin-right: 10px; }
.order a { line-height: 7px; }
.note-editable { height: 450px !important; }
.table.table-no-more td { padding-left: 2px; }
.scrollable .scrollable-content { padding: 0px; }
label { display: block !important; width: 100%; }
.btn { padding: 2px 7px; }
.input-group-btn { width: 100%; display: block !important; }
.w4 input { padding: 0px; text-align: center; }
.v8-mini-tabs { height: 30px !important; }
.content-body .card-margin .card { margin-top: 0px; }
fieldset .card-header { padding: 10px 5px; }
select, input, textarea, .bootstrap-tagsinput { border: 0px !important; border-left: 2px solid #ccc !important; border-radius: 0px !important; background: transparent !important; }
select:focus, input:focus, textarea:focus { border : 1px solid silver !important; }
.dropdown-item { padding: 0px; }
.cspan { position: absolute; bottom: -12px; right: 0px; z-index: 9; width: 80px; font-size: 12px; color: black; }
.body-sign { height: 95vh !important; }
fieldset { min-height: 95px !important; }
fieldset.collapsed { min-height: unset !important; border-left: 0px !important; }
fieldset.collapsed legend { min-width: 150px; cursor: pointer; position: relative; }
fieldset:not(collapsed) legend a:after { display: block; content: '\f102'; font-family: FontAwesome; position: absolute; right: 5px; top: 3px; }
fieldset.collapsed legend a:after { display: block; content: '\f103'; font-family: FontAwesome; position: absolute; right: 5px; top: 3px; }
.add-event { height: 15px !important; min-width: 15px !important; cursor: pointer; }
.calendar .add-event:hover { width: 5em !important; }
ul.events { list-style: none; padding: 3px; }
.mdiv { border: 1px solid silver; border-radius: 10px; margin-right: 3px; margin-bottom: 10px; padding: 0px !important; }
#tips { display: none !important; }
.dropdown-menu-right a { padding: 5px; }
.lph { position: absolute; margin-top: -28px; left: 15px; color: silver; opacity: 0.5; }
.rph { position: absolute; margin-top: -23px; right: 5px; color: silver; opacity: 0.5; }
.body-sign { height: auto !important; margin-top: 6%; }
span.badge { padding: 5px; }
span.badge a { color: white !important; font-size: 10px !important; }
.homest .card-body { padding: 10px; }
.addtr { background: <?php echo $module["bcwarning"]?> !important; }
.cw { color: white !important; }
.cb { color: black !important; }
.cw .fa-times { color: white !important; }
.widget-summary .summary-icon { width: 60px !important; height: 60px !important; line-height: 60px !important; }
.pd0 { padding: 0px !important; }
.pd10 { padding: 10px !important; }
fieldset.pd10 legend { margin-left: 5px; }
ul.floating-tags { list-style: none; float: right; }
ul.task-dialog { list-style: none; }
ul.mini-menu { list-style: none; width: 75px; float: right; margin-top: -5px; }

/* =========================================
   DYNAMIC MODULE COLORS
   ========================================= */
<?php if($module["bcsuccess"]<>"" or $module["bcwarning"]<>"" or $module["bcdanger"]<>"" or $module["bcinfo"]<>""){?>
.v3-bg-default, .bg-default, .v3-panel-default, .panel-default, .v3-btn-default, .v3-btn-default:hover, .btn-default, .btn-default:hover, .v3-alert-default, .alert-default { background-color: <?php echo $module["bcdefault"];?> !important; color: <?php echo $module["clrcdefault"];?> !important; border-color: <?php echo $module["clrcdefault"];?>1c !important; }
.v3-bg-danger, .bg-danger, .v3-panel-danger, .panel-danger, .v3-btn-danger, .v3-btn-danger:hover, .btn-danger, .btn-danger:hover, .v3-alert-danger, .alert-danger { background-color: <?php echo $module["bcdanger"];?> !important; color: <?php echo $module["clrcdanger"];?> !important; border-color: <?php echo $module["clrcdanger"];?>1c !important; }
.v3-bg-info, .bg-info, .v3-panel-info, .panel-info, .v3-btn-info, .v3-btn-info:hover, .btn-info, .btn-info:hover, .v3-alert-info, .alert-info { background-color: <?php echo $module["bcinfo"];?> !important; color: <?php echo $module["clrcinfo"];?> !important; border-color: <?php echo $module["clrcinfo"];?>1c !important; }
.v3-bg-warning, .bg-warning, .v3-panel-warning, .panel-warning, .v3-btn-warning, .v3-btn-warning:hover, .btn-warning, .btn-warning:hover, .v3-alert-warning, .alert-warning { background-color: <?php echo $module["bcwarning"];?> !important; color: <?php echo $module["clrcwarning"];?> !important; border-color: <?php echo $module["clrcwarning"];?>1c !important; }
.v3-bg-success, .bg-success, .v3-panel-success, .panel-success, .v3-btn-success, .v3-btn-success:hover, .btn-success, .btn-success:hover, .v3-alert-success, .alert-success { background-color: <?php echo $module["bcsuccess"];?> !important; color: <?php echo $module["clrcsuccess"];?> !important; border-color: <?php echo $module["clrcsuccess"];?>1c !important; }

.v3-text-default, .text-default { color: <?php echo $module["clrcdefault"];?> !important; }
.v3-text-danger, .text-danger { color: <?php echo $module["clrcdanger"];?> !important; }
.v3-text-info, .text-info { color: <?php echo $module["clrcinfo"];?> !important; }
.v3-text-warning, .text-warning { color: <?php echo $module["clrcwarning"];?> !important; }
.v3-text-success, .text-success { color: <?php echo $module["clrcsuccess"];?> !important; }

.v3-border-default, .border-default { border: 1px solid <?php echo $module["bcdefault"];?> !important; }
.v3-border-danger, .border-danger { border: 1px solid <?php echo $module["bcdanger"];?> !important; }
.v3-border-info, .border-info { border: 1px solid <?php echo $module["bcinfo"];?> !important; }
.v3-border-warning, .border-warning { border: 1px solid <?php echo $module["bcwarning"];?> !important; }
.v3-border-success, .border-success { border: 1px solid <?php echo $module["bcsuccess"];?> !important; }
<?php }?>

.tab-content { border-radius: 20px 0 20px 20px; }
::-webkit-scrollbar { width: 5px !important; }
#rsearch { position: absolute; background: white; width: 100%; max-height: 200px; overflow: auto; margin-top: 40px; margin-left: 0px; z-index: 9999; filter: drop-shadow(2px 4px 6px black); }
.search-list li:hover { background: orange; }
.notification-menu .image i { height: 20px; line-height: 20px; width: 20px; }
#ntr td { border-top: 3px solid #ed9c28 !important; border-bottom: 3px solid #ed9c28 !important; }
.wcon { padding: 10px; margin-top: 5px; margin-right: 15px; background: beige; border-radius: 13px; text-align: center; }
.wicon { height: 70px; margin-top: -5px; margin-bottom: 5px; color: #bf882f; }
.wtext { font-size: 10px; margin-top: 5px; }
.wdeg { margin-top: -10px; margin-bottom: 10px; }
.wdate { margin-top: 5px; padding: 0px 2px; font-size: 16px; color: grey; }
.wloc { display: none; position: absolute; margin-top: -50px; right: 8%; padding: 3px 10px; border-radius: 0px 10px 0px 10px; background: beige; }
.select2-container--bootstrap .select2-selection--single { height: 32.5px; line-height: 1.7; padding: 4px 13px 6px 12px; }
.pricing-table .most-popular h3 { background-color: #d2312d; }
.pricing-table h3 span { font: bold 30px / 40px Georgia, Serif; }
.cp { cursor: pointer; }
.select2 { width: 100% !important; }
.select2-container--bootstrap .select2-selection--multiple .select2-search--inline .select2-search__field { width: 100% !important; border-radius: 5px; padding: 0px 0px; height: 30px; margin-left: 4px; margin-top: 4px; }

#smartbanner { position: absolute; left: 0; margin-top: -20px; margin-bottom: 20px; border-bottom: 1px solid #e8e8e8; width: 100%; height: 78px; font-family: 'Helvetica Neue', sans-serif; background: -webkit-linear-gradient(top, #f4f4f4 0%, #cdcdcd 100%); background-image: -ms-linear-gradient(top, #F4F4F4 0%, #CDCDCD 100%); background-image: -moz-linear-gradient(top, #F4F4F4 0%, #CDCDCD 100%); box-shadow: 0 1px 2px rgba(0, 0, 0, 0.5); z-index: 9998; -webkit-font-smoothing: antialiased; overflow: hidden; -webkit-text-size-adjust: none; }
#smartbanner, html.sb-animation { -webkit-transition: all .3s ease; }
#smartbanner .sb-container { margin: 0 auto; }
#smartbanner .sb-close { position: absolute; left: 5px; top: 5px; display: block; border: 0px solid #fff; width: 20px; height: 20px; font-family: 'ArialRoundedMTBold', Arial; font-size: 20px; line-height: 15px; text-align: center; color: #666; background: transparent; text-decoration: none; text-shadow: none; }
#smartbanner .sb-close:active { font-size: 13px; color: #aaa; }
#smartbanner .sb-icon { position: absolute; left: 30px; top: 10px; display: block; width: 57px; height: 57px; background: rgba(0, 0, 0, 0.6); background-size: cover; border-radius: 10px; box-shadow: 0 1px 3px rgba(0, 0, 0, 0.3); }
#smartbanner.no-icon .sb-icon { display: none; }
#smartbanner .sb-info { position: absolute; left: 98px; top: 18px; width: 44%; font-size: 11px; line-height: 1.2em; font-weight: bold; color: #6a6a6a; text-shadow: 0 1px 0 rgba(255, 255, 255, 0.8); }
#smartbanner #smartbanner.no-icon .sb-info { left: 34px; }
#smartbanner .sb-info strong { display: block; font-size: 13px; color: #4d4d4d; line-height: 18px; }
#smartbanner .sb-info > span { display: block; }
#smartbanner .sb-info em { font-style: normal; text-transform: uppercase; }
#smartbanner .sb-button { position: absolute; right: 20px; top: 24px; border: 1px solid #bfbfbf; padding: 0 10px; min-width: 10%; height: 24px; font-size: 14px; line-height: 24px; text-align: center; font-weight: bold; color: #6a6a6a; background: -webkit-linear-gradient(top, #efefef 0%, #dcdcdc 100%); text-transform: uppercase; text-decoration: none; text-shadow: 0 1px 0 rgba(255, 255, 255, 0.8); border-radius: 3px; box-shadow: 0 1px 0 rgba(255, 255, 255, 0.6), 0 1px 0 rgba(255, 255, 255, 0.7) inset; }
#smartbanner .sb-button:active, #smartbanner .sb-button:hover { background: -webkit-linear-gradient(top, #dcdcdc 0%, #efefef 100%); }
#smartbanner .sb-icon.gloss:after { content: ''; position: absolute; left: 0; top: -1px; border-top: 1px solid rgba(255, 255, 255, 0.8); width: 100%; height: 50%; background: -webkit-linear-gradient(top, rgba(255, 255, 255, 0.7) 0%, rgba(255, 255, 255, 0.2) 100%); border-radius: 10px 10px 12px 12px; }
#smartbanner.android { border-color: #212228; background: #3d3d3d url('data:image/gif;base64,R0lGODlhCAAIAIABAFVVVf///yH5BAEHAAEALAAAAAAIAAgAAAINRG4XudroGJBRsYcxKAA7'); border-top: 5px solid #88B131; box-shadow: none; }
#smartbanner.android .sb-close { border: 0; width: 17px; height: 17px; line-height: 17px; color: #b1b1b3; background: #1c1e21; text-shadow: 0 1px 1px #000; box-shadow: 0 1px 2px rgba(0, 0, 0, 0.8) inset, 0 1px 1px rgba(255, 255, 255, 0.3); }
#smartbanner.android .sb-close:active { color: #eee; }
#smartbanner.android .sb-info { color: #ccc; text-shadow: 0 1px 2px #000; }
#smartbanner.android .sb-info strong { color: #fff; }
#smartbanner.android .sb-button { min-width: 12%; border: 1px solid #DDDCDC; padding: 1px; color: #d1d1d1; background: none; border-radius: 0; box-shadow: none; min-height: 28px; }
#smartbanner.android .sb-button span { text-align: center; display: block; padding: 0 10px; background-color: #42B6C9; background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#42B6C9), to(#39A9BB)); background-image: -moz-linear-gradient(top, #42B6C9, #39A9BB); text-transform: none; text-shadow: none; box-shadow: none; }
#smartbanner.android .sb-button:active, #smartbanner.android .sb-button:hover { background: none; }
#smartbanner.android .sb-button:active span, #smartbanner.android .sb-button:hover span { background: #2AC7E1; }
#smartbanner.windows .sb-icon { border-radius: 0px; }

<?php if($mobile<>""){?>
.filter_form { display: none; position: absolute; background: #f7ead7; z-index: 9999; padding: 10px; left: 0px; top: 0px; }
<?php }?>

.input-group-btn .btn { padding-top: unset; padding-bottom: unset; }
.cp { cursor: pointer; }
.cw { color: white; }
.cb { color: black; }
.cr { color: red; }
.db { display: block; }
.dn { display: none; }
.dfx { display: flow-root; }
.pa { position: absolute; }
.pr { position: relative; }
.pf { position: fixed; }
.fl { float: left; }
.fn { float: none; }
.fr { float: right; }
.select2-selection--multiple { display: inline-table !important; }

/* =========================================
   MEDIA QUERY: DESKTOP
   ========================================= */
@media screen and (min-width: 1280px) {
    .w1600 { overflow-x: auto; -webkit-overflow-scrolling: touch; }
    .w1200 { overflow-x: auto; -webkit-overflow-scrolling: touch; }
    .ddb { display: block; }
    .ddfx { display: flow-root !important; }
    .ddn { display: none; }
    .dpa { position: absolute; }
    .dpr { position: relative; }
    .dpf { position: fixed; }
    .dtar { text-align: right; }
    .dtal { text-align: left; }
    .dtac { text-align: center; }
    .tan { text-align: none; }
    .dfl { float: left; }
    .dfn { float: none; }
    .dfr { float: right; }
    html { overflow: hidden !important; }
    .toright { position: fixed; right: 9px; top: 120px; z-index: 99; width: 96%; }
    .sidebar-toggle, .sidebar-header, .sidebar-left .nano:not(.hovered) { background: transparent !important; box-shadow: unset !important; }
    .inner-wrapper { overflow-x: hidden; overflow-y: auto; height: 85vh; padding-top: 0px !important; min-height: 85vh; }
    .header .logo { margin-left: 60px; }
    html.fixed.sidebar-left-collapsed .page-header { left: 60px; border-left: 3px <?php echo $clr2_hex;?> solid !important; }
    html.sidebar-left-collapsed .sidebar-left, html.sidebar-left-collapsed .sidebar-left .nano { width: 55px !important; background: #ffffff4d; }
    html.sidebar-light:not(.dark) ul.nav-main > li.nav-expanded > a { background: #fafafac4 !important; color: #ff8200 !important; }
    html.sidebar-left-collapsed.sidebar-left-opened .sidebar-left .nano .nav-main .nav-expanded > ul.nav-children { display: none; }
    .sidebar-left .nano:not(.hovered) ul.nav-main li a { color: #f6f6f6; }
    .sidebar-left .nano:not(.hovered) ul.nav-children li a, .nav-expanded a { color: #777 !important; }
    html.fixed .sidebar-left { z-index: 9999; height: 100vh; }
    html.sidebar-left-collapsed .sidebar-left .nav-main a span { visibility: hidden !important; }
    html.sidebar-left-collapsed .sidebar-left .nav-main li.nav-parent a:after { display: none !important; }
    html:no.sidebar-left-collapsed .sidebar-left .nano:not(.hovered) .nav-main .nav-expanded > ul.nav-children { display: none !important; }
    html.sidebar-left-collapsed .sidebar-left .nano.hovered { width: 250px !important; }
    html.fixed .page-header { left: 250px; }
    .sidebar-left .nano.hovered .nav-main li a span { visibility: visible !important; }
    .sidebar-left .nano.hovered li.nav-parent a:after { display: block !important; }
    .sidebar-left .nano.hovered .nav-main .nav-expanded > ul.nav-children { display: block !important; }
    .sidebar-left .nano:not(.hovered) .nav-active .nav-children a { color: #777 !important; }
    html.fixed .content-body { margin-left: 255px; }
    html.sidebar-light:not(.dark) .sidebar-left .sidebar-header .sidebar-title { background: transparent; }
    .wcon { width: 19.4%; }
    .cnews { max-width: 399px; }
    .col { padding-left: 0px !important; padding-right: 20px !important; }
    fieldset.v3-col-md-2 { width: 11% !important; margin-right: 3px; height: 95px !important; }
    fieldset.v3-col-md-3 { width: 24.7% !important; margin-right: 3px; height: 95px !important; }
    fieldset.v3-col-md-4 { width: 33% !important; margin-right: 3px; ; height: 95px !important; }
    fieldset.v3-col-md-6 { width: 49.5% !important; margin-right: 3px; height: 95px !important; }
    fieldset.v3-col-md-8 { width: 66% !important; margin-right: 3px; height: 95px !important; }
    fieldset.v3-col-md-9 { width: 74.5% !important; margin-right: 3px; height: 95px !important; }
    fieldset.v3-col-md-10 { width: 82% !important; margin-right: 3px; height: 95px !important; }
    fieldset.v3-col-md-12 { width: 99.3% !important; }
    #switchs fieldset { padding: 5px 20px; min-height: auto !important; }
    .xl { width: 500px !important; transform: translate3d(0px, 30px, 0px) !important; }
    html.fixed.sidebar-left-collapsed .content-body { <?php if($_GET["ne"]==""){echo "margin-left: 60px;";}else{echo "margin-left: 75px;";}?> padding: 15px 10px 0px 0px !important; margin-bottom: 50px; }
    #control-bar.fixed { width: 100%; left: 63px !important; top: 114px !important; }
    #control-bar { padding: 1em 17px !important; }
    .medias .v3-col-md-3 { width: 24.5% !important; margin-right: 3px !important; }
    #uploadarea:before { content: "<?php echo ctranslate("Görseli buraya bırakınız")?>"; position: absolute; font-size: 50px; opacity: 0.1; margin-left: 30%; margin-top: 10%; }
    .mdiv:hover { background: #fcf8e3; }
    .calendar tbody th, .calendar tbody td { height: 9em !important; }
    .more-events ul li a:hover { background: #ffd9d9; }
    .more-events { width: 100% !important; }
    .events li a { color: #585b62 !important; }
    .events li:hover a { color: #585b62 !important; }
    .events:hover { opacity: 1 !important; }
    .events li:hover { opacity: 1 !important; }
    .events li b { color: #ff3333 !important; }
    .events li .fa-times { position: absolute; right: 5px; top: 2px; font-size: 15px; width: 16px; height: 16px; opacity: 0; cursor: pointer; color: red !important; padding: 0px; }
    .events li:hover .fa-times { opacity: 1; }
    .header . { width: 220px !important; }
    .sam { position: absolute; right: 20px; margin-top: -15px; }
    .gesturepwdbtn { display: none; }
    .sinput { border: 1px solid #ccc !important; color: #3a3834 !important; background: #ffffffc4 !important; }
    .calendar tbody tr:nth-child(odd) .unavailable { background: #F2F2F2 url(assets/img/medium-grey-stripes.png) !important; }
    .table th, .table td { padding: 5px 10px; }
    .content-body { padding: 10px !important; }
    .content-body.card-margin .card { margin-top: 5px; }
    #wlogin { height: 5%; }
    .checkbox-custom { padding: 0 0 0 22px; }
    .form-control:not(.form-control-sm):not(.form-control-lg) { min-height: 0px !important; font-size: inherit; line-height: 1; }
    select.form-control:not([size]):not([multiple]) { height: calc(1.80rem + 2px); border: 0px; }
    .select2-selection { border: 0px; box-shadow: none; background: transparent; }
}

/* =========================================
   MEDIA QUERY: TABLET
   ========================================= */
@media only screen and (min-width: 500px) and (max-width: 1279px) {
    .modal { width: 80% !important; }
    .mw1600 { overflow-x: auto; }
    .mpl0 { padding-left: 0px; }
    .mdb { display: block; }
    .mdfx { display: flow-root !important; }
    ._mdn { display: none; }
    .mpa { position: absolute; }
    .mpr { position: relative; }
    .mpf { position: fixed; }
    .mtar { text-align: right; }
    .mtal { text-align: left; }
    .mtac { text-align: center; }
    .mtan { text-align: none; }
    .mfl { float: left; }
    .mfn { float: none; }
    .mfr { float: right; }
    html { overflow: hidden !important; }
    .userbox { position: absolute; display: block; right: 0px; top: 5px; }
    .sidebar-toggle, .sidebar-header, .sidebar-left .nano:not(.hovered) { background: transparent !important; box-shadow: unset !important; }
    .toright { position: fixed; right: 9px; top: 120px; z-index: 99; width: 96%; }
    .inner-wrapper { overflow-x: hidden; overflow-y: auto; height: 85vh; padding-top: 0px !important; min-height: 85vh; }
    .header .logo { margin-left: 60px; }
    .header-right { width: 48%; }
    html.fixed.sidebar-left-collapsed .page-header { left: 60px; border-left: 3px <?php echo $clr2_hex;?> solid !important; }
    html.sidebar-left-collapsed .sidebar-left, html.sidebar-left-collapsed .sidebar-left .nano { width: 55px !important; background: #ffffff4d; }
    html.sidebar-light:not(.dark) ul.nav-main > li.nav-expanded > a { background: #fafafac4 !important; color: #ff8200 !important; }
    html.sidebar-left-collapsed.sidebar-left-opened .sidebar-left .nano .nav-main .nav-expanded > ul.nav-children { display: none; }
    .sidebar-left .nano:not(.hovered) ul.nav-main li a { color: #f6f6f6; }
    .sidebar-left .nano:not(.hovered) ul.nav-children li a, .nav-expanded a { color: #777 !important; }
    html.fixed .sidebar-left { z-index: 9999; height: 100vh; }
    html.sidebar-left-collapsed .sidebar-left .nav-main a span { visibility: hidden !important; }
    html.sidebar-left-collapsed .sidebar-left .nav-main li.nav-parent a:after { display: none !important; }
    html:no.sidebar-left-collapsed .sidebar-left .nano:not(.hovered) .nav-main .nav-expanded > ul.nav-children { display: none !important; }
    html.sidebar-left-collapsed .sidebar-left .nano.hovered { width: 250px !important; }
    html.fixed .page-header { left: 250px; }
    .sidebar-left .nano.hovered .nav-main li a span { visibility: visible !important; }
    .sidebar-left .nano.hovered li.nav-parent a:after { display: block !important; }
    .sidebar-left .nano.hovered .nav-main .nav-expanded > ul.nav-children { display: block !important; }
    .sidebar-left .nano:not(.hovered) .nav-active .nav-children a { color: #777 !important; }
    html.fixed .content-body { <?php if($_GET["ne"]=="" and $_GET["islem"][0]<>"d"){echo "margin-left: 245px; margin-top: 90px;";}elseif($_GET["islem"][0]=="d"){echo "margin-left: 260px; margin-top: 78px;";}else{echo "margin-left: 260px; margin-top: 115px;";}?> }
    html.fixed.sidebar-left-collapsed .content-body { <?php if($_GET["ne"]=="" and $_GET["islem"][0]<>"d"){echo "margin-left: 60px; margin-top: 90px;";}elseif($_GET["islem"][0]=="d"){echo "margin-left: 78px; margin-top: 65px;";}else{echo "margin-left: 78px; margin-top: 105px;";}?> padding: 15px 10px 0px 0px !important; margin-bottom: 50px; }
    .card-actions { top: 0px; }
    html.sidebar-light:not(.dark) .sidebar-left .sidebar-header .sidebar-title { background: transparent; }
    .wcon { width: 19.4%; }
    .auts { display: none; background: white; width: 100%; padding: 10px; position: absolute; z-index: 99; }
    .auts .btn { width: 100% !important; display: block; margin-bottom: 5px; }
    .cnews { max-width: 399px; }
    .col { padding-left: 0px !important; padding-right: 20px !important; }
    fieldset.v3-col-md-2 { width: 11% !important; margin-right: 2px; height: 95px !important; }
    fieldset.v3-col-md-3 { width: 24.7% !important; margin-right: 2px; height: 95px !important; }
    fieldset.v3-col-md-4 { width: 33% !important; margin-right: 2px; ; height: 95px !important; }
    fieldset.v3-col-md-6 { width: 49.5% !important; margin-right: 2px; height: 95px !important; }
    fieldset.v3-col-md-8 { width: 66% !important; margin-right: 2px; height: 95px !important; }
    fieldset.v3-col-md-9 { width: 74.5% !important; margin-right: 2px; height: 95px !important; }
    fieldset.v3-col-md-10 { width: 82% !important; margin-right: 2px; height: 95px !important; }
    fieldset.v3-col-md-12 { width: 99.3% !important; }
    #switchs fieldset { padding: 5px 20px; min-height: auto !important; }
    .xl { width: 500px !important; transform: translate3d(0px, 30px, 0px) !important; }
    #control-bar.fixed { width: 100%; left: 63px !important; top: 114px !important; }
    #control-bar { padding: 1em 17px !important; }
    .medias .v3-col-md-3 { width: 24.5% !important; margin-right: 3px !important; }
    #uploadarea:before { content: "<?php echo ctranslate("Görseli buraya bırakınız")?>"; position: absolute; font-size: 50px; opacity: 0.1; margin-left: 30%; margin-top: 10%; }
    .mdiv:hover { background: #fcf8e3; }
    .calendar tbody th, .calendar tbody td { height: 9em !important; }
    .more-events ul li a:hover { background: #ffd9d9; }
    .more-events { width: 100% !important; }
    .events li a { color: #585b62 !important; }
    .events li:hover a { color: #585b62 !important; }
    .events:hover { opacity: 1 !important; }
    .events li:hover { opacity: 1 !important; }
    .events li b { color: #ff3333 !important; }
    .events li .fa-trash { position: absolute; right: 5px; top: 2px; font-size: 15px; width: 16px; height: 16px; opacity: 0; cursor: pointer; color: red !important; padding: 0px; }
    .events li:hover .fa-trash { opacity: 1; }
    .header . { width: 220px !important; }
    .sam { position: absolute; right: 20px; margin-top: -15px; }
    .gesturepwdbtn { display: none; }
    .v8-col200pxL-left #switchs { display: none; position: fixed; /*left: 0px;*/ width: 100%; z-index: 9999; background: #fff; top: 0px; padding: 30px; height: 100vh; overflow: auto; }
    .v8-col200pxL-left #switchs fieldset { display: block; width: 100%; }
    .v8-col200pxL-left #switchs .fa-arrow-right { position: absolute; right: 7px; top: 7px; padding: 5px; }
    .v8-col200pxL-left #switchs .form-control { color: #fe8100 !important; }
    .v8-col200pxL-left { width: 65px !important; }
    .mfixed { position: fixed !important; top: 125px; }
    .v8-col200pxL-right { margin-left: 25px !important; }
    ul.v8-side-tabs li > a > span { display: none !important; }
    .sinput { border: 1px solid #ccc !important; color: #3a3834 !important; background: #ffffffc4 !important; }
    .calendar tbody tr:nth-child(odd) .unavailable { background: #F2F2F2 url(assets/img/medium-grey-stripes.png) !important; }
    .table th, .table td { padding: 5px 10px; }
    .content-body { padding: 3px !important; }
    #wlogin { height: 5%; }
    .checkbox-custom { padding: 0 0 0 22px; }
    .form-control:not(.form-control-sm):not(.form-control-lg) { min-height: 0px !important; font-size: inherit; line-height: 1; }
    select.form-control:not([size]):not([multiple]) { height: calc(1.80rem + 2px); border: 0px; }
    .select2-selection { border: 0px; box-shadow: none; background: transparent; }
}

/* =========================================
   MEDIA QUERY: MOBILE
   ========================================= */
@media only screen and (max-width: 599px) {
    body { overflow: hidden; }
    .mw1600 { overflow-x: auto; }
    .mpl0 { padding-left: 0px; }
    .mdb { display: block !important; }
    .mdfx { display: flow-root !important; }
    .mdn { display: none !important; }
    .mpa { position: absolute; }
    .mpr { position: relative; }
    .mpf { position: fixed; }
    .mtar { text-align: right; }
    .mtal { text-align: left; }
    .mtac { text-align: center; }
    .mtan { text-align: none; }
    .mfl { float: left; }
    .mfn { float: none; }
    .mfr { float: right; }
    .lph { position: absolute; margin-top: -28px; left: 50px; color: silver; opacity: 0.5; }

    <?php if($user_agent=="android"){?>
    .header { margin-top: 70px; }
    <?php }else{?>
    section.body { margin-top: 70px; }
    .header { margin-top: 15px; }
    <?php }?>
    
    #dashboard .dbcb { height: 400px !important; }
    #server .dbcb { height: 180px !important; }
    .sidebar-header { display: none !important; }
    .inner-wrapper { overflow-x: hidden; overflow-y: auto; height: 82vh; padding-top: 0px !important; margin-top: 0px; min-height: 82vh; background: #ffffffc4; }
    .dark-mode .inner-wrapper { overflow-x: hidden; overflow-y: auto; height: 82vh; padding-top: 0px !important; margin-top: 0px; min-height: 82vh; background: #000000c4; }
    html.sidebar-left-big-icons .content-body { margin-left: 165px; }
    html.sidebar-left-big-icons .page-header { left: 175px; }
    #dashboard h2 { display: block !important; margin-top: 10px; }
    #dashboard .card-actions { margin-bottom: 15px !important; float: right; margin-top: 10px; }
    #dashboard .col-md-6 { padding: 3px; }
    #dashboard { margin-top: -10px; }
    .card-header h2 { display: none; }
    .card-actions { margin-bottom: 5px; }
    .toright { position: fixed; right: 9px; top: 120px; z-index: 99; width: 91%; }
    .userbox:after { background: #E9E9E6; content: ''; height: 63px; margin: 0; position: absolute; right: 0px; top: -18px; width: 0px; }
    .mbtns { display: none; position: absolute; top: -30px; right: 0px; z-index: 99; }
    .table th, .table td { padding: 2px; line-height: 34px; }
    .table tr { margin-bottom: 5px; }
    .header .logo-container { height: 70px !important; }
    .card-header { padding: 5px; }
    .card-body { font-size: 11px; }
    .auts { display: none; background: white; width: 100%; padding: 10px; position: absolute; z-index: 99; }
    .auts .btn { width: 100% !important; display: block; margin-bottom: 5px; }
    .cnews { max-width: 100%; }
    .notifications > li { margin: 0 8px 0 0; }
    fieldset.v3-col-xs-2 { width: 11% !important; height: 95px !important; }
    fieldset.v3-col-xs-3 { width: 24.7% !important; height: 95px !important; }
    fieldset.v3-col-xs-4 { width: 33% !important; height: 95px !important; }
    fieldset.v3-col-xs-6 { width: 46.5% !important; height: 95px !important; }
    fieldset.v3-col-xs-8 { width: 66% !important; height: 95px !important; }
    fieldset.v3-col-xs-9 { width: 74.5% !important; height: 95px !important; }
    fieldset.v3-col-xs-10 { width: 82% !important; height: 95px !important; }
    fieldset.v3-col-xs-12 { width: 99.3% !important; }
    .form label, .form .label { margin-bottom: 2px; }
    #qsearch { display: none; background: #ffffffed; width: 100%; height: 100%; position: fixed; z-index: 9999; padding: 5%; padding-top: 15%; top: 0px; }
    .header-right { height: 55px !important; margin-top: 0px !important; }
    .medias .v3-col-xs-12 { width: 99.3% !important; }
    ul.events { width: 70%; }
    .calendar .other-month .day { color: #999 !important; }
    .more-events { width: 68% !important; }
    .body-sign { margin-top: -30px !important; }
    .gesturepwd { display: none; position: fixed !important; top: 0px !important; left: 0px !important; width: 100% !important; height: 100% !important; z-index: 999999 !important; }
    .v8-col200pxL-left #switchs { display: none; position: fixed; left: 0px; width: 100%; z-index: 9999; background: #fff; top: 0px; padding: 30px; height: 100vh; overflow: auto; }
    .v8-col200pxL-left #switchs fieldset { display: block; width: 100%; }
    .v8-col200pxL-left #switchs .fa-arrow-right { position: absolute; right: 7px; top: 7px; padding: 5px; }
    .v8-col200pxL-left #switchs .form-control { color: #fe8100 !important; }
    .v8-col200pxL-left { width: 65px !important; }
    .mfixed { position: fixed !important; top: 125px; }
    .v8-col200pxL-right { margin-left: 25px !important; }
    ul.v8-side-tabs li > a > span { display: none !important; }
    .v8-tabs-content { padding: 30px 0px; }
    #control-bar.fixed { width: 100%; left: 0px !important; top: 60px !important; }
    #control-bar { padding: 1em 10px !important; }
    .unavailable { display: none !important; }
    .other-month { width: 100% !important; }
    .mbtn { width: 48%; margin-right: 1%; text-align: center; }
    .mbtn25 { width: 23%; margin-right: 1%; text-align: center; }
    .mbtn15 { width: 17.5%; margin-right: 1%; text-align: center; }
    .header .search { width: 100%; display: block; }
    .sinput { border: 1px solid #ccc !important; }
    .sam { position: absolute; right: 15px; margin-top: -14px; }
    .notifications, .userbox { margin-top: 15px; display: block; }
    .header { border-bottom: 0px solid #E9E9E6; }
    .content-body { padding: 3px !important; }
    .content-body.card-margin .card { margin-top: 0px; }
    #wmlogin { margin-top: 20%; }
    .checkbox-custom { padding: 0 0 0 22px; }
    .form-control:not(.form-control-sm):not(.form-control-lg) { min-height: 0px !important; font-size: small; line-height: 1; }
    select.form-control:not([size]):not([multiple]) { height: calc(1.80rem + 2px); border: 0px; }
    .select2-selection { border: 0px; box-shadow: none; background: transparent; }
    .page-header { display: none; }
}